<?php

return [
  'name' => 'CustomField',
  'table' => 'civicrm_custom_field',
  'class' => 'CRM_Core_DAO_CustomField',
  'getInfo' => fn() => [
    'title' => ts('Custom Field'),
    'title_plural' => ts('Custom Fields'),
    'description' => ts('Stores info about an extended (custom) property (data and form field info).'),
    'log' => TRUE,
    'add' => '1.1',
    'label_field' => 'label',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/admin/custom/group/field/add?reset=1&action=add&gid=[custom_group_id]',
    'update' => 'civicrm/admin/custom/group/field/update?action=update&reset=1&id=[id]&gid=[custom_group_id]',
    'preview' => 'civicrm/admin/custom/group/preview?reset=1&fid=[id]',
    'delete' => 'civicrm/admin/custom/group/field/delete?reset=1&id=[id]',
    'detach' => 'civicrm/admin/custom/group/field/move?reset=1&fid=[id]',
  ],
  'getIndices' => fn() => [
    'UI_label_custom_group_id' => [
      'fields' => [
        'label' => TRUE,
        'custom_group_id' => TRUE,
      ],
      'unique' => TRUE,
      'add' => '1.1',
    ],
    'UI_name_custom_group_id' => [
      'fields' => [
        'name' => TRUE,
        'custom_group_id' => TRUE,
      ],
      'unique' => TRUE,
      'add' => '4.3',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Custom Field ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Unique Custom Field ID'),
      'add' => '1.1',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'custom_group_id' => [
      'title' => ts('Custom Group ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('FK to civicrm_custom_group.'),
      'add' => '1.1',
      'input_attrs' => [
        'label' => ts('Custom Group'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_custom_group',
        'key_column' => 'id',
        'label_column' => 'title',
      ],
      'entity_reference' => [
        'entity' => 'CustomGroup',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'name' => [
      'title' => ts('Custom Field Name'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Text',
      'description' => ts('Variable name/programmatic handle for this field.'),
      'add' => '3.3',
    ],
    'label' => [
      'title' => ts('Custom Field Label'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'required' => TRUE,
      'localizable' => TRUE,
      'description' => ts('Text for form field label (also friendly name for administering this custom property).'),
      'add' => '1.1',
    ],
    'data_type' => [
      'title' => ts('Data Type'),
      'sql_type' => 'varchar(16)',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('Controls location of data storage in extended_data table.'),
      'add' => '1.1',
      'input_attrs' => [
        'label' => ts('Data Type'),
      ],
      'pseudoconstant' => [
        'callback' => ['CRM_Core_BAO_CustomField', 'dataType'],
      ],
    ],
    'html_type' => [
      'title' => ts('HTML Type'),
      'sql_type' => 'varchar(32)',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('HTML types plus several built-in extended types.'),
      'add' => '1.1',
      'input_attrs' => [
        'label' => ts('Field Input Type'),
      ],
      'pseudoconstant' => [
        'callback' => ['CRM_Core_SelectValues', 'customHtmlType'],
      ],
    ],
    'default_value' => [
      'title' => ts('Custom Field Default'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Use form_options.is_default for field_types which use options.'),
      'add' => '1.1',
    ],
    'is_required' => [
      'title' => ts('Custom Field Is Required?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is a value required for this property.'),
      'add' => '1.1',
      'default' => FALSE,
    ],
    'is_searchable' => [
      'title' => ts('Optimize for Search'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Adds a database index which helps speed up searches on this field significantly. However, it can require more storage and can slow down the system if the data is frequently updated.'),
      'add' => '1.1',
      'default' => FALSE,
    ],
    'is_search_range' => [
      'title' => ts('Search as a Range'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this property range searchable.'),
      'add' => '1.4',
      'default' => FALSE,
    ],
    'weight' => [
      'title' => ts('Order'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Controls field display order within an extended property group.'),
      'add' => '1.1',
      'default' => 1,
    ],
    'help_pre' => [
      'title' => ts('Custom Field Pre Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Description and/or help text to display before this field.'),
      'add' => '1.1',
    ],
    'help_post' => [
      'title' => ts('Custom Field Post Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Description and/or help text to display after this field.'),
      'add' => '1.1',
    ],
    'attributes' => [
      'title' => ts('Custom Field Attributes'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Store collection of type-appropriate attributes, e.g. textarea needs rows/cols attributes'),
      'add' => '1.1',
    ],
    'is_active' => [
      'title' => ts('Custom Field Is Active?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'description' => ts('Is this property active?'),
      'add' => '1.1',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'is_view' => [
      'title' => ts('Field is Viewable'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this property set by PHP Code? A code field is viewable but not editable'),
      'add' => '1.1',
      'default' => FALSE,
    ],
    'options_per_line' => [
      'title' => ts('Field Options Per Line'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('number of options per line for checkbox and radio'),
    ],
    'text_length' => [
      'title' => ts('Field Length'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('field length if alphanumeric'),
      'add' => '2.2',
    ],
    'start_date_years' => [
      'title' => ts('Field Start Date'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'description' => ts('Date may be up to start_date_years years prior to the current date.'),
      'add' => '1.4',
    ],
    'end_date_years' => [
      'title' => ts('Field End Date'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'description' => ts('Date may be up to end_date_years years after the current date.'),
      'add' => '1.4',
    ],
    'date_format' => [
      'title' => ts('Field Data Format'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Select',
      'description' => ts('date format for custom date'),
      'add' => '3.1',
      'pseudoconstant' => [
        'callback' => ['CRM_Core_SelectValues', 'getDatePluginInputFormats'],
      ],
    ],
    'time_format' => [
      'title' => ts('Field Time Format'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('time format for custom date'),
      'add' => '3.1',
      'pseudoconstant' => [
        'callback' => ['CRM_Core_SelectValues', 'getTimeFormats'],
      ],
    ],
    'note_columns' => [
      'title' => ts('Field Note Columns'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Number of columns in Note Field'),
      'add' => '1.4',
    ],
    'note_rows' => [
      'title' => ts('Field Note Rows'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Number of rows in Note Field'),
      'add' => '1.4',
    ],
    'column_name' => [
      'title' => ts('Field Column Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Name of the column that holds the values for this field.'),
      'add' => '2.0',
    ],
    'option_group_id' => [
      'title' => ts('Field Option Group ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('For elements with options, the option group id that is used'),
      'add' => '1.4',
      'input_attrs' => [
        'label' => ts('Field Option Group'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_option_group',
        'key_column' => 'id',
        'label_column' => 'title',
      ],
      'entity_reference' => [
        'entity' => 'OptionGroup',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'serialize' => [
      'title' => ts('Serialize'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('Serialization method - a non-zero value indicates a multi-valued field.'),
      'add' => '5.27',
      'default' => 0,
      'pseudoconstant' => [
        'callback' => ['CRM_Core_SelectValues', 'fieldSerialization'],
      ],
    ],
    'filter' => [
      'title' => ts('Field Filter'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Stores Contact Get API params contact reference custom fields. May be used for other filters in the future.'),
      'add' => '4.1',
    ],
    'in_selector' => [
      'title' => ts('Field Display'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Should the multi-record custom field values be displayed in tab table listing'),
      'add' => '4.5',
      'default' => FALSE,
    ],
    'fk_entity' => [
      'title' => ts('Entity'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Name of entity being referenced.'),
      'add' => '5.60',
      'default' => NULL,
    ],
    'fk_entity_on_delete' => [
      'title' => ts('On Referenced Entity Delete'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('Behavior if referenced entity is deleted.'),
      'add' => '5.71',
      'default' => 'set_null',
      'pseudoconstant' => [
        'callback' => ['CRM_Core_BAO_CustomField', 'getFkEntityOnDeleteOptions'],
      ],
    ],
  ],
];
