# CiviCRM 4.7.21

Released July 5, 2017

- **[Security advisories](#security)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="security"></a>Security advisories

- **[CIVI-SA-2017-01](https://civicrm.org/advisory/civi-sa-2017-01-pingback-url-not-encrypted)** Pingback URL not encrypted
- **[CIVI-SA-2017-02](https://civicrm.org/advisory/civi-sa-2017-02-privilage-escalation-via-leaked-key)** Privilage escalation via leaked key
- **[CIVI-SA-2017-03](https://civicrm.org/advisory/civi-sa-2017-03-cross-site-scritping-in-the-recently-viewed-block)** Cross-site scripting in "Recently Viewed" block
- **[CIVI-SA-2017-04](https://civicrm.org/advisory/civi-sa-2017-04-incorrect-escaping-for-on-behalf-of-block)** Incorrect escaping for "On Behalf Of" block
- **[CIVI-SA-2017-05](https://civicrm.org/advisory/civi-sa-2017-05-incorrect-escaping-for-search-results-column)** Incorrect escaping for "Search Results" column
- **[CIVI-SA-2017-06](https://civicrm.org/advisory/civi-sa-2017-06-incorrect-escaping-in-drupal-views-integration)** Incorrect escaping in Drupal Views integration
- **[CIVI-SA-2017-07](https://civicrm.org/advisory/civi-sa-2017-07-insuffient-permission-check-in-mailing-report)** Insuffient permission-check in mailing report
- **[CIVI-SA-2017-08](https://civicrm.org/advisory/civi-sa-2017-08-upgrade-multiple-js-libraries)** Upgrade multiple JS libraries


## <a name="features"></a>Features

### Core CiviCRM

- **[CRM-18081](https://issues.civicrm.org/jira/browse/CRM-18081) Allow search
  of active relationships during a custom range of dates
  ([10333](https://github.com/civicrm/civicrm-core/pull/10333))**

  It is now possible to filter on the active dates of a relationship in Advanced
  Search and the Relationship Report.  If relationship start and end dates are
  filled accurately, this allows finding active relationships at a specified
  point in time.

- **[CRM-20692](https://issues.civicrm.org/jira/browse/CRM-20692) Support jQuery
  options in AngularJS `crm-ui-tab-set`
  ([10477](https://github.com/civicrm/civicrm-core/pull/10477))**

  jQuery UI supports various tab set options.  This change allows for the
  options to be passed through from `crm-ui-tab-set` `<div>` elements in
  AngularJS.

- **[CRM-20680](https://issues.civicrm.org/jira/browse/CRM-20680) Make the
  CiviCRM logo spin while waiting for next page to load
  ([10465](https://github.com/civicrm/civicrm-core/pull/10465))**

  The spinning logo in the navigation menu provides visual indication that a new
  page is loading.

- **[CRM-20679](https://issues.civicrm.org/jira/browse/CRM-20679) Make the
  CiviCRM logo spin while quicksearch is running
  ([10464](https://github.com/civicrm/civicrm-core/pull/10464))**

  This provides confirmation that the search is running.

- **[CRM-20715](https://issues.civicrm.org/jira/browse/CRM-20715) Add index on
  `is_deceased` column in `civicrm_contact`
  ([10489](https://github.com/civicrm/civicrm-core/pull/10489))**

  Queries filtering deceased contacts will have improved performance now that the `is_deceased` field is indexed.

- **[CRM-20552](https://issues.civicrm.org/jira/browse/CRM-20552) Task for "Add
  Relationship - to individual" is missing
  ([10360](https://github.com/civicrm/civicrm-core/pull/10360)) (completes prior
  work)**

  The various search result actions for adding relationships based on different
  contact types are now abstracted to a single class.

- **[CRM-20684](https://issues.civicrm.org/jira/browse/CRM-20684) Standalone
  form for contact bulk actions
  ([10471](https://github.com/civicrm/civicrm-core/pull/10471))**

  A number of search result actions for contacts can now be accessed directly
  from their own URLs rather than solely from search results.

- **[CRM-20594](https://issues.civicrm.org/jira/browse/CRM-20594) Optimze
  Relationship Count on Contact Summary View
  ([10371](https://github.com/civicrm/civicrm-core/pull/10371))**

  The relationship count for a contact is now calculated by using the `COUNT()`
  SQL function rather than counting the number of rows in the query result.

- **[CRM-20238](https://issues.civicrm.org/jira/browse/CRM-20238) Hook for
  inbound SMS messages
  ([10347](https://github.com/civicrm/civicrm-core/pull/10347))**

  See
  [hook_civicrm_inboundSMS](https://docs.civicrm.org/dev/en/latest/hooks/hook_civicrm_inboundSMS/)

- **[CRM-20575](https://issues.civicrm.org/jira/browse/CRM-20575) Allow user to
  set created_id field for batch
  ([10358](https://github.com/civicrm/civicrm-core/pull/10358))**

  If custom code modifies the batch creation form, it can specify the contact ID
  creating the batch.  

- **[CRM-20091](https://issues.civicrm.org/jira/browse/CRM-20091) Case custom
  fields blocks ([10540](https://github.com/civicrm/civicrm-core/pull/10540),
  [10482](https://github.com/civicrm/civicrm-core/pull/10482), and
  [10460](https://github.com/civicrm/civicrm-core/pull/10460)) (tangential work)**

  A new CustomValue.getTree API action retrieves the labels and values for all
  of an entity's custom fields, given the entity's type and ID.y54

- **[CRM-20600](https://issues.civicrm.org/jira/browse/CRM-20600) Expose
  AngularJS screens to hooks
  ([10085](https://github.com/civicrm/civicrm-core/pull/10085) and
  [10381](https://github.com/civicrm/civicrm-core/pull/10381))**

  HTML partials in AngularJS can now be modified using
  `hook_civicrm_alterAngular`.  In addition, manipulated and compiled HTML is
  now cached in the files directory.

- **Surface errors from API calls to user on status page.
  ([10380](https://github.com/civicrm/civicrm-core/pull/10380))**

  API debug information in status checks now appear with the resulting message.

### CiviCase

- **[CRM-20475](https://issues.civicrm.org/jira/browse/CRM-20475) People
  involved tab ([10438](https://github.com/civicrm/civicrm-core/pull/10438))**

  The phone number for related contacts is now avaiable in the API.

- **[CRM-20097](https://issues.civicrm.org/jira/browse/CRM-20097) Case action
  menu ([10288](https://github.com/civicrm/civicrm-core/pull/10288)) (unrelated
  fixes)**

  The Case API now has better handling for activities with multiple related
  cases.

### CiviMail

- **[CRM-20309](https://issues.civicrm.org/jira/browse/CRM-20309) Ensure A/B
  tests can be sent in parallel
  ([10227](https://github.com/civicrm/civicrm-core/pull/10227))**

  This change improves A/B testing where the test group is larger than the
  mailer job size.  In these cases, each mailer job is scheduled one second
  after the prior one, ensuring that the first *A* job is followed by the first
  *B* job, then the next *A* job, and so on.

- **[CRM-20370](https://issues.civicrm.org/jira/browse/CRM-20370) include
  additional stats in mailing opened/click reports
  ([10089](https://github.com/civicrm/civicrm-core/pull/10089))**

  Open date and click date are now available as CiviMail reports.

### Drupal Integration

- **[CRM-20462](https://issues.civicrm.org/jira/browse/CRM-20462) Add filter for
  current employer in views
  ([443](https://github.com/civicrm/civicrm-drupal/pull/443))**

  This feature is now available in Drupal 6.x for CiviCRM 4.7.x.  It was
  previously added for other Drupal-CiviCRM version combinations.

- **[CRM-20205](https://issues.civicrm.org/jira/browse/CRM-20205) Expose current
  employer id to views
  ([434](https://github.com/civicrm/civicrm-drupal/pull/434) and
  [433](https://github.com/civicrm/civicrm-drupal/pull/433))**

  The current employer ID is now available as a display, contextual filter,
  filter, and sort field in Views.

### Joomla Integration

- **[CRM-12059](https://issues.civicrm.org/jira/browse/CRM-12059) Support
  hook_civicrm_permission on Joomla
  ([10344](https://github.com/civicrm/civicrm-core/pull/10344) and
  [43](https://github.com/civicrm/civicrm-joomla/pull/43))**

  CiviCRM permissions in Joomla can now be defined dynamically, allowing
  extensions using `hook_civicrm_permission` to work properly

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-20642](https://issues.civicrm.org/jira/browse/CRM-20642) Show/Hide Case
  activity toggle
  ([10451](https://github.com/civicrm/civicrm-core/pull/10451)) (preliminary
  work)**

  This fixes a bug in the Activity.get API where filtering on null case, tag, or
  file ID would yield inconsistent results.

- **[CRM-20590](https://issues.civicrm.org/jira/browse/CRM-20590) Add pre and
  post hook for EntityBatch
  ([10366](https://github.com/civicrm/civicrm-core/pull/10366))**

- **[CRM-20588](https://issues.civicrm.org/jira/browse/CRM-20588) Pre and Post
  hook for Batch ([10364](https://github.com/civicrm/civicrm-core/pull/10364))**

- **[CRM-20585](https://issues.civicrm.org/jira/browse/CRM-20585) Correct the
  from and to accounts for deferred revenue transactions
  ([10367](https://github.com/civicrm/civicrm-core/pull/10367))**

  The from and to accounts for deferred revenue transactions were reversed. This
  change corrects them moving forward, but it does not affect previously-created
  transactions.

- **[CRM-20768](https://issues.civicrm.org/jira/browse/CRM-20768) Web-based
  installation should accept non-standard MySQL port
  ([10555](https://github.com/civicrm/civicrm-core/pull/10555))**

- **[CRM-20644](https://issues.civicrm.org/jira/browse/CRM-20644) Column names
  on Advanced search results displayed on contacts are out of order.
  ([10556](https://github.com/civicrm/civicrm-core/pull/10556))**

- **[CRM-18408](https://issues.civicrm.org/jira/browse/CRM-18408) SMTP
  connection via SSL and TLS in PHP 5.6
  ([10329](https://github.com/civicrm/civicrm-core/pull/10329)) (preliminary
  work)**

  This loads a more recent build of `cacert.pem` for use on hosts which lack one.

- **[CRM-20556](https://issues.civicrm.org/jira/browse/CRM-20556) DataTables
  warning on merge screen
  ([10503](https://github.com/civicrm/civicrm-core/pull/10503))**

  This resolves a warning appearing on the duplicate contact merge listing
  indicating that it could not reinitialize DataTable.

- **[CRM-20672](https://issues.civicrm.org/jira/browse/CRM-20672) Related Fields
  don't populate for relationships with contact type "All Contacts" when mapping
  an export ([10456](https://github.com/civicrm/civicrm-core/pull/10456))**

- **[CRM-20226](https://issues.civicrm.org/jira/browse/CRM-20226) Parent Group
  do not inherit child group contacts
  ([10428](https://github.com/civicrm/civicrm-core/pull/10428))**

  A bug was fixed where members of smart groups would not appear as members of
  parent groups of the smart group.

- **[CRM-20381](https://issues.civicrm.org/jira/browse/CRM-20381) Can't stop
  geocoding on import
  ([10181](https://github.com/civicrm/civicrm-core/pull/10181))**

  This fixes a regression where imported contacts' addresses were geocoded
  despite bypassing geocoding in the import settings.

- **[CRM-20655](https://issues.civicrm.org/jira/browse/CRM-20655) Notice error
  on batch listing
  ([10436](https://github.com/civicrm/civicrm-core/pull/10436))**

- **Add help text to civicrm.settings.php re: DSNs containing quotes/backslashes
  ([10437](https://github.com/civicrm/civicrm-core/pull/10437))**

- **[CRM-20618](https://issues.civicrm.org/jira/browse/CRM-20618) Generate
  contact image if contact id is present
  ([10396](https://github.com/civicrm/civicrm-core/pull/10396))**

  This prevents a contact image from being generated for a transaction unless
  the transaction is actually related to a contact.

- **[CRM-20606](https://issues.civicrm.org/jira/browse/CRM-20606) Incorrect
  state/province names for Austria
  ([10391](https://github.com/civicrm/civicrm-core/pull/10391))**

  Two states of Austria were missing umlauts.

- **[CRM-20589](https://issues.civicrm.org/jira/browse/CRM-20589) Warning on
  Batch listing page
  ([10365](https://github.com/civicrm/civicrm-core/pull/10365))**

- **Remove call to nonexistent method
  ([10382](https://github.com/civicrm/civicrm-core/pull/10382))**

  A failure in Redis caching would call a nonexistent cache method.

- **[CRM-20578](https://issues.civicrm.org/jira/browse/CRM-20578) Empty update
  of Activity assignee/target results into DB error
  ([10361](https://github.com/civicrm/civicrm-core/pull/10361))**

- **[CRM-19896](https://issues.civicrm.org/jira/browse/CRM-19896)
  customTranslateFunction not mapped in MagicMerge
  ([9790](https://github.com/civicrm/civicrm-core/pull/9790))**

- **[CRM-20740](https://issues.civicrm.org/jira/browse/CRM-20740) Api fails to
  check on custom field is null in some cases
  ([10512](https://github.com/civicrm/civicrm-core/pull/10512))**

- **[CRM-19610](https://issues.civicrm.org/jira/browse/CRM-19610) Fatal when
  creating InnoDB fts indexes
  ([10453](https://github.com/civicrm/civicrm-core/pull/10453) and
  [10491](https://github.com/civicrm/civicrm-core/pull/10491))**

- **[CRM-20581](https://issues.civicrm.org/jira/browse/CRM-20581) Civi event
  users do not have access to StateProvince entity via the API
  ([10363](https://github.com/civicrm/civicrm-core/pull/10363))**

  All contacts with "Access CiviCRM" permission now can access all states and
  provinces.

### CiviContribute

- **[CRM-20253](https://issues.civicrm.org/jira/browse/CRM-20253) backend
  contribution receipt sent when option not selected
  ([10502](https://github.com/civicrm/civicrm-core/pull/10502),
  [10509](https://github.com/civicrm/civicrm-core/pull/10509),
  [10508](https://github.com/civicrm/civicrm-core/pull/10508), and
  [10506](https://github.com/civicrm/civicrm-core/pull/10506))**

- **[CRM-20718](https://issues.civicrm.org/jira/browse/CRM-20718) CiviCRM,
  Contribution page, when using the "On behalf of" Organisation Profile,
  fieldset title uses hardcoded "Organization Details"
  ([10499](https://github.com/civicrm/civicrm-core/pull/10499))**

  The on-behalf profile now uses the profile's name rather than "Organization
  Details".

- **[CRM-20690](https://issues.civicrm.org/jira/browse/CRM-20690) No more than
  25 Price Options listed
  ([10476](https://github.com/civicrm/civicrm-core/pull/10476))**

  This displays all options on a price field rather than the first 25.

- **[CRM-20706](https://issues.civicrm.org/jira/browse/CRM-20706) Notice error
  on using Contribution.getfield API
  ([10484](https://github.com/civicrm/civicrm-core/pull/10484))**

- **[CRM-20574](https://issues.civicrm.org/jira/browse/CRM-20574)  Deprecated:
  Group=''. Name='cvv_backoffice_required'.
  ([10357](https://github.com/civicrm/civicrm-core/pull/10357))**

- **[CRM-20516](https://issues.civicrm.org/jira/browse/CRM-20516) Card type
  widget appears on front end when a different processor selected
  ([10375](https://github.com/civicrm/civicrm-core/pull/10375))**

- **[CRM-20564](https://issues.civicrm.org/jira/browse/CRM-20564) custom date
  fields in on-behalf-of forms broken
  ([10354](https://github.com/civicrm/civicrm-core/pull/10354))**

- **[CRM-20747](https://issues.civicrm.org/jira/browse/CRM-20747)
  `{contribution.campaign}` token not working on Contribution ThankYou letter
  ([10575](https://github.com/civicrm/civicrm-core/pull/10575))**

- **[CRM-20678](https://issues.civicrm.org/jira/browse/CRM-20678)
  Repeattransaction produces contribution in default currency - instead of the
  series' currency
  ([10490](https://github.com/civicrm/civicrm-core/pull/10490))**

- **[CRM-19963](https://issues.civicrm.org/jira/browse/CRM-19963) Paypal Express
  not working in German
  ([9779](https://github.com/civicrm/civicrm-core/pull/9779))**

  Various conditions were conditional upon the locally-translated label of
  PayPal rather than the fixed name.

### CiviEvent

- **[CRM-20611](https://issues.civicrm.org/jira/browse/CRM-20611) Cancelling a
  line-item by changing fee selection of event, leads to incorrect financial
  records ([10390](https://github.com/civicrm/civicrm-core/pull/10390))**

- **method cannot be a protected static
  ([10404](https://github.com/civicrm/civicrm-core/pull/10404))**

  The method CRM_Event_Form_Registration_Register::getRegistrationContactID was
  marked as protected, even though it was called from
  CRM_Event_Form_Registration_AdditionalParticipant.

- **[CRM-20613](https://issues.civicrm.org/jira/browse/CRM-20613) User
  deprecated function: Deprecated function for New Participant
  ([10392](https://github.com/civicrm/civicrm-core/pull/10392))**

  This avoids notices when creating new participants from the backend.

- **[CRM-20562](https://issues.civicrm.org/jira/browse/CRM-20562) Wrong
  Activities created during participant registration via completetransaction.
  ([10362](https://github.com/civicrm/civicrm-core/pull/10362))**

### CiviMail

- **[CRM-20694](https://issues.civicrm.org/jira/browse/CRM-20694) CiviMail
  Report is missing Resubscribe Message
  ([10479](https://github.com/civicrm/civicrm-core/pull/10479))**

- **[CRM-20660](https://issues.civicrm.org/jira/browse/CRM-20660) Mail Summary
  Report showing same number for Total Opens and Unique Opens
  ([10443](https://github.com/civicrm/civicrm-core/pull/10443))**

  This resolves a problem where the Total Opens count was only querying
  `DISTINCT` open results.

- **[CRM-20789](https://issues.civicrm.org/jira/browse/CRM-20789) Unsubscribing
  from an AB test does not work in 4.7.21
  ([10583](https://github.com/civicrm/civicrm-core/pull/10583))**

### CiviMember

- **[CRM-20675](https://issues.civicrm.org/jira/browse/CRM-20675) Membership
  status update creates renewal activity
  ([10598](https://github.com/civicrm/civicrm-core/pull/10598))**

### Backdrop Integration

- **[CRM-20612](https://issues.civicrm.org/jira/browse/CRM-20612) Error:
  undefined function config() when installing on Backdrop
  ([10389](https://github.com/civicrm/civicrm-core/pull/10389))**

### Drupal Integration

- **[CRM-20698](https://issues.civicrm.org/jira/browse/CRM-20698) Make
  "disabled" table rows appear greyed-out
  ([10481](https://github.com/civicrm/civicrm-core/pull/10481))**

  CSS in the Seven theme conflicts with CiviCRM's CSS, preventing rows of
  disabled records from having grey text.

- **Improve Views checkbox value handling
  ([448](https://github.com/civicrm/civicrm-drupal/pull/448) and
  [449](https://github.com/civicrm/civicrm-drupal/pull/449))**

- **[CRM-19303](https://issues.civicrm.org/jira/browse/CRM-19303) CKEditor
  configuration can't be edited on a Drupal multisite installation
  ([10577](https://github.com/civicrm/civicrm-core/pull/10577) and
  [10511](https://github.com/civicrm/civicrm-core/pull/10511))**

## <a name="misc"></a>Miscellany

- **[CRM-20744](https://issues.civicrm.org/jira/browse/CRM-20744) Use
  bower_compoents images for datatable rather than packages
  ([10520](https://github.com/civicrm/civicrm-core/pull/10520))**

- **[CRM-20561](https://issues.civicrm.org/jira/browse/CRM-20561) Load
  Net_SMTP, Auth_SASL, Net_Socket via Composer
  ([10384](https://github.com/civicrm/civicrm-core/pull/10384),
  [3](https://github.com/seamuslee001/civicrm-core/pull/3),
  [4](https://github.com/seamuslee001/civicrm-core/pull/4),
  [10385](https://github.com/civicrm/civicrm-core/pull/10385),
  [185](https://github.com/civicrm/civicrm-packages/pull/185), and
  [186](https://github.com/civicrm/civicrm-packages/pull/186))**

- **[CRM-20687](https://issues.civicrm.org/jira/browse/CRM-20687) Issue numbers
  used as variables
  ([10473](https://github.com/civicrm/civicrm-core/pull/10473))**

- **(NFC) re add in animated-overlay.gif is no longer provided by jquery-ui
  ([10523](https://github.com/civicrm/civicrm-core/pull/10523))**

- **(NFC) Fix clearing messages to ensure test accuracy
  ([10525](https://github.com/civicrm/civicrm-core/pull/10525))**

- **(NFC) Attribution Chirojeugd Vlaanderen
  ([10519](https://github.com/civicrm/civicrm-core/pull/10519))**

- **[CRM-20620](https://issues.civicrm.org/jira/browse/CRM-20620) Use batch api
  to retrieve all the batches
  ([10397](https://github.com/civicrm/civicrm-core/pull/10397))**

  When retrieving the list of transaction batches, the BAO now uses the API
  rather than a direct SQL query.

- **API allows creating multiple addresses same location type
  ([10510](https://github.com/civicrm/civicrm-core/pull/10510))**

  This adds a test to confirm that two addresses with the same location type
  *can* be added in APIv3, even though it is not the desired behavior in the
  form layer or APIv4.

- **There's a better way to say it than "poor man's".
  ([10500](https://github.com/civicrm/civicrm-core/pull/10500))**

  Various comments referring to a "poor man's" version of something have been
  modified to be more specific.  Many contain implicit references to the Drupal
  module [poormanscron](https://www.drupal.org/project/poormanscron), which has
  less to do with poverty or masculinity than checking periodically for the
  duration since the previous run of a task.

- **[CRM-20651](https://issues.civicrm.org/jira/browse/CRM-20651) Change
  partial_amount_pay to partial_amount_to_pay for Partial Payment workflow
  ([10433](https://github.com/civicrm/civicrm-core/pull/10433))**

- **(NFC) Civi\API\Kernel - Add more docblocks
  ([10416](https://github.com/civicrm/civicrm-core/pull/10416))**

- **Fix passing null object
  ([452](https://github.com/civicrm/civicrm-drupal/pull/452))**

- **Legacy function param cleanup
  ([30](https://github.com/civicrm/civicrm-backdrop/pull/30))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

Agileware - Agileware Team; Arkadiusz Rzadkowolski; Arun Singh; Australian
Greens - Seamus Lee; Blackfly Solutions - Alan Dixon; British Humanist
Association - Andrew West; Circle Interactive - Dave Jenkins; CiviCRM - Coleman
Watts, Tim Otten; CiviDesk - Yashodha Chaku; CompuCorp - Camilo Rodriguez,
Michael Devery; Coop SymbioTIC - Mathieu Lutfy; Effy Elden; Eli Lisseck;
Francesc Bassas i Bullich; Freeform Solutions - Herb van den Dool; Fuzion -
Chris Burgess, Eileen McNaughton, Jitendra Purohit; Ginkgo Street Labs - Frank
Gómez; JMA Consulting - Monish Deb, Pradeep Nayak; Joinery - Allen Shaw; Jon
Goldberg; Lemniscus - Noah Miller; Lighthouse Design and Consulting - Brian
Shaughnessy; Oxfam Germany - Thomas Schüttler; Progressive Technology Project -
Jamie McClelland; Redfin Solutions - Chris Wells; Romain Thouvenin; Sean Madsen;
Systopia - Björn Endres; Web Access - Kurund Jalmi; Wikimedia Foundation -
Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Alcohol Justice - Bruce Wolfe; Alex Block; Andy Clarke; Blackfly Solutions -
Alan Dixon; Bob Silvern; Bob Vincent; Business & Code - Alain Benbassat; Circle
Interactive - Martin Castle; CiviDesk - Nicolas Ganivet; CiviHosting - Hershel
Robinson; CompuCorp - Guanhuan Chen, Mirela Stanila; Donald Hirst; Fuzion -
Peter Davis; Ginkgo Street Labs - Dan O'Brien; James van der Hoven; JMA
Consulting - Joe Murray; Joanne Chester; Johan Vervloet; Korlon - Stuart Gaston;
MC3 - Graham Mitchell; Michal Mach; Milton Zurita; MJW Consulting - Matthew
Wire; Nubay Services - David Tarrant; Registered Nurses' Association of Ontario -
Thomas Mannell; Richard van Oosterhout; Semper IT - Karin Gerritsen; Skvare -
Mark Hanna; Systopia - Fabian Schuttenberg; Tech To The People - Xavier Dutoit;
Web Access - Rohan Chavan; Wim De Craene
