<?php

return [
  [
    'name' => 'SavedSearch_Site_Email_Addresses',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Site_Email_Addresses',
        'label' => ts('Site From Email Addresses'),
        'api_entity' => 'SiteEmailAddress',
        'api_params' => [
          'version' => 4,
          'select' => [
            'display_name',
            'email',
            'description',
            'is_active',
            'is_default',
          ],
          'orderBy' => [],
          'where' => [
            ['domain_id:name', '=', 'current_domain'],
          ],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
      ],
      'match' => ['name'],
    ],
  ],
  [
    'name' => 'SavedSearch_Site_Email_Addresses_SearchDisplay_Site_Email_Addresses',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Site_Email_Addresses',
        'label' => ts('Site From Email Addresses'),
        'saved_search_id.name' => 'Site_Email_Addresses',
        'type' => 'table',
        'settings' => [
          'description' => ts('You can use this page to define one or more general Email Addresses that can be selected as the From Address.'),
          'sort' => [
            ['is_default', 'DESC'],
            ['display_name', 'ASC'],
          ],
          'limit' => 50,
          'pager' => [
            'hide_single' => TRUE,
            'show_count' => TRUE,
          ],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'display_name',
              'dataType' => 'String',
              'label' => ts('Display Name'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'email',
              'dataType' => 'String',
              'label' => ts('Email'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'description',
              'dataType' => 'Text',
              'label' => ts('Description'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'is_active',
              'dataType' => 'Boolean',
              'label' => ts('Enabled'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'is_default',
              'dataType' => 'Boolean',
              'label' => ts('Default'),
              'sortable' => TRUE,
              'icons' => [
                [
                  'icon' => 'fa-circle-check',
                  'side' => 'left',
                  'if' => ['is_default', '=', TRUE],
                ],
              ],
              'rewrite' => ' ',
            ],
            [
              'text' => ts(''),
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => 'SiteEmailAddress',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => ts('Edit Email Address'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'task' => 'disable',
                  'entity' => 'SiteEmailAddress',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => ts('Disable Email Addresses'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => [],
                ],
                [
                  'task' => 'enable',
                  'entity' => 'SiteEmailAddress',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => ts('Enable Email Addresses'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => FALSE,
          'classes' => [
            'table',
            'table-striped',
            'crm-sticky-header',
          ],
          'toolbar' => [
            [
              'entity' => 'SiteEmailAddress',
              'text' => ts('Add Email Address'),
              'icon' => 'fa-plus',
              'target' => 'crm-popup',
              'action' => 'add',
              'style' => 'primary',
              'join' => '',
              'path' => '',
              'task' => '',
              'condition' => [],
            ],
          ],
          'cssRules' => [
            ['disabled', 'is_active', '=', FALSE],
          ],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
