<?php
use CRM_CivicrmAdminUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_Personal_Campaign_Pages',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Personal_Campaign_Pages',
        'label' => E::ts('Personal Campaign Pages'),
        'api_entity' => 'PCP',
        'api_params' => [
          'version' => 4,
          'select' => [
            'title',
            'PCP_Contact_contact_id_01.sort_name',
            'IFNULL(PCP_ContributionPage_page_id_01.title, PCP_Event_page_id_01.title) AS IFNULL_PCP_ContributionPage_page_id_01_title_PCP_Event_page_id_01_title',
            'PCP_Event_page_id_01.title',
            'PCP_ContributionPage_page_id_01.start_date',
            'PCP_ContributionPage_page_id_01.end_date',
            'PCP_Event_page_id_01.start_date',
            'PCP_Event_page_id_01.end_date',
            'status_id:label',
            'is_active',
          ],
          'orderBy' => [],
          'where' => [],
          'groupBy' => [],
          'join' => [
            [
              'ContributionPage AS PCP_ContributionPage_page_id_01',
              'LEFT',
              [
                'page_id',
                '=',
                'PCP_ContributionPage_page_id_01.id',
              ],
              [
                'page_type',
                '=',
                '\'contribute\'',
              ],
            ],
            [
              'Contact AS PCP_Contact_contact_id_01',
              'LEFT',
              [
                'contact_id',
                '=',
                'PCP_Contact_contact_id_01.id',
              ],
            ],
            [
              'Event AS PCP_Event_page_id_01',
              'LEFT',
              [
                'page_id',
                '=',
                'PCP_Event_page_id_01.id',
              ],
              [
                'page_type',
                '=',
                '\'event\'',
              ],
            ],
          ],
          'having' => [],
        ],
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_Personal_Campaign_Pages_SearchDisplay_Personal_Campaign_Pages',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'Personal_Campaign_Pages',
        'label' => E::ts('Personal Campaign Pages'),
        'saved_search_id.name' => 'Personal_Campaign_Pages',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'title',
              'dataType' => 'String',
              'label' => E::ts('Page Title'),
              'sortable' => TRUE,
              'link' => [
                'path' => 'frontend://civicrm/pcp/info/?reset=1&id=[id]',
                'entity' => '',
                'action' => '',
                'join' => '',
                'target' => '',
              ],
            ],
            [
              'type' => 'field',
              'key' => 'PCP_Contact_contact_id_01.sort_name',
              'dataType' => 'String',
              'label' => E::ts('Supporter'),
              'sortable' => TRUE,
              'link' => [
                'path' => '',
                'entity' => 'Contact',
                'action' => 'view',
                'join' => 'PCP_Contact_contact_id_01',
                'target' => '',
              ],
              'title' => E::ts('View Personal Campaign Page Contact'),
            ],
            [
              'type' => 'field',
              'key' => 'IFNULL_PCP_ContributionPage_page_id_01_title_PCP_Event_page_id_01_title',
              'dataType' => 'String',
              'label' => E::ts('Contribution Page/Event'),
              'sortable' => TRUE,
              'rewrite' => '',
            ],
            [
              'type' => 'field',
              'key' => 'PCP_ContributionPage_page_id_01.start_date',
              'dataType' => 'Timestamp',
              'label' => E::ts('Start Date'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'PCP_ContributionPage_page_id_01.end_date',
              'dataType' => 'Timestamp',
              'label' => E::ts('End Date'),
              'sortable' => TRUE,
              'empty_value' => '(ongoing)',
            ],
            [
              'type' => 'field',
              'key' => 'status_id:label',
              'dataType' => 'Integer',
              'label' => E::ts('Status'),
              'sortable' => TRUE,
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'task' => '',
                  'entity' => 'PCP',
                  'join' => '',
                  'target' => '_blank',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Edit'),
                  'style' => 'default',
                  'path' => '',
                  'action' => 'update',
                  'condition' => [],
                ],
                [
                  'path' => 'civicrm/admin/pcp?action=revert&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Reject'),
                  'style' => 'default',
                  'condition' => [
                    'status_id:name',
                    'IN',
                    [
                      'Waiting Review',
                      'Approved',
                    ],
                  ],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '_blank',
                ],
                [
                  'path' => 'civicrm/admin/pcp?action=renew&id=[id]',
                  'icon' => 'fa-external-link',
                  'text' => E::ts('Approve'),
                  'style' => 'default',
                  'condition' => [
                    'status_id:name',
                    'IN',
                    [
                      'Waiting Review',
                      'Not Approved',
                    ],
                  ],
                  'task' => '',
                  'entity' => '',
                  'action' => '',
                  'join' => '',
                  'target' => '_blank',
                ],
                [
                  'path' => '',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'default',
                  'condition' => [
                    'is_active',
                    '=',
                    FALSE,
                  ],
                  'task' => 'enable',
                  'entity' => 'PCP',
                  'action' => '',
                  'join' => '',
                  'target' => 'crm-popup',
                ],
                [
                  'task' => 'disable',
                  'entity' => 'PCP',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                  'condition' => [
                    'is_active',
                    '=',
                    TRUE,
                  ],
                ],
                [
                  'task' => 'delete',
                  'entity' => 'PCP',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'action' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => TRUE,
          'classes' => [
            'table',
            'table-striped',
          ],
          'cssRules' => [
            [
              'disabled',
              'is_active',
              '=',
              FALSE,
            ],
          ],
        ],
      ],
      'match' => [
        'saved_search_id',
        'name',
      ],
    ],
  ],
];
