{**
 * Outer Region
 *}
<script type="text/template" id="designer_template">
  <div class="crm-designer-toolbar full-height">
    <div class="crm-designer-buttonset-region ui-dialog-buttonset"></div>
    <div class="crm-designer-palette-region full-height"></div>
  </div>
  <div class="crm-designer-canvas full-height scroll">
    <div class="crm-designer-preview-canvas"></div>
    <div class="crm-designer-form-region"></div>
    <div class="crm-designer-fields-region"></div>
  </div>
</script>

{**
 * Render the field-palette container
 *}
<script type="text/template" id="palette_template">
  <div class="crm-designer-palette">
    <div class="crm-designer-palette-search">
      <div class="crm-filter-objects">
        <span>{ts}Contact Type{/ts}:
          <select class="crm-form-select crm-contact-types">
          <option value="IndividualModel">{ts}Individual{/ts}</option>
          <option value="OrganizationModel">{ts}Organization{/ts}</option>
          <option value="HouseholdModel">{ts}Household{/ts}</option>
          </select>
        </span>
      </div>
      <input type="text" class="crm-form-text" placeholder="{ts escape='htmlattribute'}Search Fields{/ts}" />
      <a class="crm-designer-palette-clear-search crm-hover-button" href="#" style="visibility:hidden" title="{ts escape='htmlattribute'}Clear search{/ts}"><i class="crm-i fa-times" aria-hidden="true"></i></a>
      <div class="crm-designer-palette-controls">
        <a href="#" class="crm-designer-palette-toggle" rel="open_all">{ts}Open All{/ts}</a>&nbsp; |&nbsp;
        <a href="#" class="crm-designer-palette-toggle" rel="close_all">{ts}Close All{/ts}</a>
      </div>
    </div>

    <div class="crm-designer-palette-tree scroll">
    </div>
  </div>
</script>

{**
 * Template for CRM.UF.UFFieldModel, CRM.Designer.UFFieldView
 * @see extendedSerializeData()
 *}
<script type="text/template" id="field_row_template">
  <div class="crm-designer-row" data-field-cid="<%= _model.cid %>">
    <div class="crm-designer-field-summary"></div>
    <div class="crm-designer-field-detail"></div>
  </div>
</script>

{**
 * Template for CRM.UF.UFFieldModel, CRM.Designer.UFFieldSummaryView
 * @see extendedSerializeData()
 *}
<script type="text/template" id="field_summary_template">
  <span class="crm-designer-buttons">
    <a class="crm-i fa-pencil crm-designer-action-settings" title="{ts escape='htmlattribute'}Settings{/ts}" aria-hidden="true"></a>
    <a class="crm-i fa-trash crm-designer-action-remove" title="{ts escape='htmlattribute'}Remove{/ts}" aria-hidden="true"></a>
  </span>
  <div class="description"><%= help_pre %></div>
  <div class="crm-designer-row-label">
    <span class="crm-designer-label"><%= label %></span>
    <%= _view.getRequiredMarker() %>
    <span class="crm-designer-field-binding"><%= _view.getBindingLabel() %></span>
  </div>
  <div class="description"><%= help_post %></div>
</script>

{**
 * @param CRM.UF.UFGroupModel form
 *}
<script type="text/template" id="form_row_template">
  <div class="crm-designer-row">
    <div class="crm-designer-form-summary"></div>
    <div class="crm-designer-form-detail"></div>
  </div>
</script>

{**
 * Variables correspond to properties of CRM.UF.UFGroupModel
 *}
<script type="text/template" id="form_summary_template">
  <h3><%= title %></h3>
  <div class="crm-designer-buttons">
    <a class="crm-designer-action-settings crm-i fa-pencil" title="{ts escape='htmlattribute'}Settings{/ts}" aria-hidden="true"></a>
  </div>
</script>

<script type="text/template" id="designer_buttons_template">
  <button class="crm-designer-save">{ts}Save{/ts}</button>
</script>

<script type="text/template" id="field_canvas_view_template">
  <div class="crm-designer-fields">
    <div class="crm-designer-row placeholder">{ts}To add a field to this form, drag or double-click an item from the list to the right.{/ts}</div>
  </div>
</script>

{**
 * Variables correspond to properties of CRM.ProfileSelector.DummyModel
 *}
<script type="text/template" id="profile_selector_template">
    <div>
        <span class="crm-profile-selector-select"></span>
        <button type="button" class="crm-profile-selector-preview" title="{ts escape='htmlattribute'}Preview{/ts}"><i class="crm-i fa-television" aria-hidden="true"></i> {ts}Preview{/ts}</button>
        {if $perm}
          <button class="crm-profile-selector-edit">{ts}Edit{/ts}</button>
          <button class="crm-profile-selector-copy">{ts}Copy{/ts}</button>
          <button class="crm-profile-selector-create">{ts}Create{/ts}</button>
        {/if}
    </div>
    <form>
    <div class="crm-profile-selector-preview-pane">
        {ts}(Preview Area){/ts}
    </div>
    </form>
</script>

<script type="text/template" id="profile_selector_empty_preview_template">
{ts}(Preview Area){/ts}
</script>

<script type="text/template" id="profile_selector_option_template">
<%= title %>
</script>

{**
 * Variables correspond to properties of CRM.ProfileSelector.DummyModel
 *}
<script type="text/template" id="designer_dialog_template">
  <div class="crm-designer crm-container full-height">
  </div>
</script>
