<?php

return [
  'name' => 'MailSettings',
  'table' => 'civicrm_mail_settings',
  'class' => 'CRM_Core_DAO_MailSettings',
  'getInfo' => fn() => [
    'title' => ts('Mail Account'),
    'title_plural' => ts('Mail Accounts'),
    'description' => ts('Various email accounts for use by CiviMail (and its processor)'),
    'add' => '2.2',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/admin/mailSettings/edit?action=add&reset=1',
    'update' => 'civicrm/admin/mailSettings/edit?action=update&id=[id]&reset=1',
    'delete' => 'civicrm/admin/mailSettings/edit?action=delete&id=[id]&reset=1',
    'browse' => 'civicrm/admin/mailSettings',
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Mail Settings ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('primary key'),
      'add' => '2.2',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'domain_id' => [
      'title' => ts('Domain ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('Which Domain is this match entry for'),
      'add' => '3.1',
      'input_attrs' => [
        'label' => ts('Domain'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_domain',
        'key_column' => 'id',
        'label_column' => 'name',
      ],
      'entity_reference' => [
        'entity' => 'Domain',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'name' => [
      'title' => ts('Mail Settings Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('name of this group of settings'),
      'add' => '2.2',
    ],
    'is_default' => [
      'title' => ts('Is Default Mail Settings?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('whether this is the default set of settings for this domain'),
      'add' => '2.2',
      'default' => FALSE,
      'input_attrs' => [
        'label' => ts('Default'),
      ],
    ],
    'domain' => [
      'title' => ts('email Domain'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('email address domain (the part after @)'),
      'add' => '2.2',
    ],
    'localpart' => [
      'title' => ts('email Local Part'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('optional local part (like civimail+ for addresses like civimail+s.1.2@example.com)'),
      'add' => '2.2',
    ],
    'return_path' => [
      'title' => ts('Return Path'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('contents of the Return-Path header'),
      'add' => '2.2',
    ],
    'protocol' => [
      'title' => ts('Protocol'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Select',
      'description' => ts('name of the protocol to use for polling (like IMAP, POP3 or Maildir)'),
      'add' => '2.2',
      'pseudoconstant' => [
        'option_group_name' => 'mail_protocol',
      ],
    ],
    'server' => [
      'title' => ts('Mail Server'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('server to use when polling'),
      'add' => '2.2',
    ],
    'port' => [
      'title' => ts('Mail Port'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('port to use when polling'),
      'add' => '2.2',
    ],
    'username' => [
      'title' => ts('Mail Account Username'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('username to use when polling'),
      'add' => '2.2',
    ],
    'password' => [
      'title' => ts('Mail Account Password'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('password to use when polling'),
      'add' => '2.2',
    ],
    'is_ssl' => [
      'title' => ts('Mail Account Uses SSL'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('whether to use SSL or not'),
      'add' => '2.2',
      'default' => FALSE,
    ],
    'source' => [
      'title' => ts('Mail Folder'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('folder to poll from when using IMAP, path to poll from when using Maildir, etc.'),
      'add' => '2.2',
    ],
    'activity_status' => [
      'title' => ts('Activity Status'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Select',
      'description' => ts('Name of status to use when creating email to activity.'),
      'add' => '4.7',
      'pseudoconstant' => [
        'option_group_name' => 'activity_status',
        'key_column' => 'name',
      ],
    ],
    'is_non_case_email_skipped' => [
      'title' => ts('Skip emails which do not have a Case ID or Case hash'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Enabling this option will have CiviCRM skip any emails that do not have the Case ID or Case Hash so that the system will only process emails that can be placed on case records. Any emails that are not processed will be moved to the ignored folder.'),
      'add' => '5.31',
      'default' => FALSE,
    ],
    'is_contact_creation_disabled_if_no_match' => [
      'title' => ts('Do not create new contacts when filing emails'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('If this option is enabled, CiviCRM will not create new contacts when filing emails.'),
      'add' => '5.31',
      'default' => FALSE,
    ],
    'is_active' => [
      'title' => ts('Enabled?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Ignored for bounce processing, only for email-to-activity'),
      'add' => '5.66',
      'default' => TRUE,
    ],
    'activity_type_id' => [
      'title' => ts('Activity Type'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Implicit FK to civicrm_option_value where option_group = activity_type'),
      'add' => '5.66',
      'pseudoconstant' => [
        'option_group_name' => 'activity_type',
      ],
    ],
    'campaign_id' => [
      'title' => ts('Campaign ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('Foreign key to the Campaign.'),
      'add' => '5.66',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Campaign'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_campaign',
        'key_column' => 'id',
        'label_column' => 'title',
        'prefetch' => 'disabled',
      ],
      'entity_reference' => [
        'entity' => 'Campaign',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'activity_source' => [
      'title' => ts('Activity Source'),
      'sql_type' => 'varchar(4)',
      'input_type' => 'Select',
      'description' => ts('Which email recipient to add as the activity source (from, to, cc, bcc).'),
      'add' => '5.66',
    ],
    'activity_targets' => [
      'title' => ts('Activity Targets'),
      'sql_type' => 'varchar(16)',
      'input_type' => 'Select',
      'description' => ts('Which email recipients to add as the activity targets (from, to, cc, bcc).'),
      'add' => '5.66',
      'serialize' => CRM_Core_DAO::SERIALIZE_COMMA,
    ],
    'activity_assignees' => [
      'title' => ts('Activity Assignees'),
      'sql_type' => 'varchar(16)',
      'input_type' => 'Select',
      'description' => ts('Which email recipients to add as the activity assignees (from, to, cc, bcc).'),
      'add' => '5.66',
      'serialize' => CRM_Core_DAO::SERIALIZE_COMMA,
    ],
  ],
];
