<?php

return [
  'name' => 'Relationship',
  'table' => 'civicrm_relationship',
  'class' => 'CRM_Contact_DAO_Relationship',
  'getInfo' => fn() => [
    'title' => ts('Relationship'),
    'title_plural' => ts('Relationships'),
    'description' => ts('Relationship between any 2 types of contacts.'),
    'log' => TRUE,
    'add' => '1.1',
    'icon' => 'fa-handshake-o',
  ],
  'getPaths' => fn() => [
    'view' => 'civicrm/contact/view/rel?action=view&reset=1&cid=[contact_id_a]&id=[id]',
    'delete' => 'civicrm/contact/view/rel?action=delete&reset=1&cid=[contact_id_a]&id=[id]',
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Relationship ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Relationship ID'),
      'add' => '1.1',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'contact_id_a' => [
      'title' => ts('Contact A ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('id of the first contact'),
      'add' => '1.1',
      'input_attrs' => [
        'label' => ts('Contact A'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'contact_id_b' => [
      'title' => ts('Contact B ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('id of the second contact'),
      'add' => '1.1',
      'input_attrs' => [
        'label' => ts('Contact B'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'relationship_type_id' => [
      'title' => ts('Relationship Type ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('Type of relationship'),
      'add' => '1.1',
      'input_attrs' => [
        'label' => ts('Relationship Type'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_relationship_type',
        'key_column' => 'id',
        'name_column' => 'name_a_b',
        'label_column' => 'label_a_b',
      ],
      'entity_reference' => [
        'entity' => 'RelationshipType',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'start_date' => [
      'title' => ts('Relationship Start Date'),
      'sql_type' => 'date',
      'input_type' => 'Select Date',
      'description' => ts('date when the relationship started'),
      'add' => '1.1',
      'unique_name' => 'relationship_start_date',
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'end_date' => [
      'title' => ts('Relationship End Date'),
      'sql_type' => 'date',
      'input_type' => 'Select Date',
      'description' => ts('date when the relationship ended'),
      'add' => '1.1',
      'unique_name' => 'relationship_end_date',
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'is_active' => [
      'title' => ts('Relationship Is Active'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('is the relationship active ?'),
      'add' => '1.1',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'description' => [
      'title' => ts('Relationship Description'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Optional verbose description for the relationship.'),
      'add' => '1.5',
    ],
    'is_permission_a_b' => [
      'title' => ts('Contact A has Permission Over Contact B'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Radio',
      'required' => TRUE,
      'description' => ts('Permission that Contact A has to view/update Contact B'),
      'add' => '2.1',
      'default' => 0,
      'pseudoconstant' => [
        'callback' => ['CRM_Core_SelectValues', 'getPermissionedRelationshipOptions'],
        'suffixes' => [
          'name',
          'label',
          'icon',
        ],
      ],
    ],
    'is_permission_b_a' => [
      'title' => ts('Contact B has Permission Over Contact A'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Radio',
      'required' => TRUE,
      'description' => ts('Permission that Contact B has to view/update Contact A'),
      'add' => '2.1',
      'default' => 0,
      'pseudoconstant' => [
        'callback' => ['CRM_Core_SelectValues', 'getPermissionedRelationshipOptions'],
        'suffixes' => [
          'name',
          'label',
          'icon',
        ],
      ],
    ],
    'case_id' => [
      'title' => ts('Case ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to civicrm_case'),
      'add' => '2.2',
      'component' => 'CiviCase',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Case'),
      ],
      'entity_reference' => [
        'entity' => 'Case',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'created_date' => [
      'title' => ts('Created Date'),
      'sql_type' => 'timestamp',
      'input_type' => NULL,
      'required' => TRUE,
      'description' => ts('Relationship created date.'),
      'add' => '5.47',
      'default' => 'CURRENT_TIMESTAMP',
    ],
    'modified_date' => [
      'title' => ts('Relationship Modified Date'),
      'sql_type' => 'timestamp',
      'input_type' => NULL,
      'required' => TRUE,
      'readonly' => TRUE,
      'description' => ts('Relationship last modified.'),
      'add' => '5.47',
      'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
    ],
  ],
];
