
# CiviCRM 5.80.0

Released December 4, 2024;

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **SearchKit - Add link to edit search when viewing results
  ([31209](https://github.com/civicrm/civicrm-core/pull/31209))**

  Adds a link to edit the search when viewing a SearchKit display.

- **SearchKit - Support fields in apiBatch task
  ([31352](https://github.com/civicrm/civicrm-core/pull/31352))**

  Allows api batch tasks to include fields for the user to interact with.

- **SearchKit - Improve loading efficiency when multiple search displays are
  hidden ([31392](https://github.com/civicrm/civicrm-core/pull/31392))**

  Improves efficiency loading SearchKit displays.

- **Package RiverLea theme extension during CiviCRM build
  ([31527](https://github.com/civicrm/civicrm-core/pull/31527),
  [31545](https://github.com/civicrm/civicrm-core/pull/31545),
  [31535](https://github.com/civicrm/civicrm-core/pull/31535),
  [31389](https://github.com/civicrm/civicrm-core/pull/31389) and
  [31478](https://github.com/civicrm/civicrm-core/pull/31478))**

  Adds Riverlea theme extension.

- **SearchKit suggestion: Multiple action buttons
  ([dev/core#5572](https://lab.civicrm.org/dev/core/-/issues/5572):
  [31415](https://github.com/civicrm/civicrm-core/pull/31415))**

  Adds the ability to add Actions as buttons to SearchKit
  searches.

- **Advanced Search: compact the Search Settings
  ([31226](https://github.com/civicrm/civicrm-core/pull/31226))**

  Makes the Advanced Search screen more web responsive.

- **EnglishNumber - Create camel-case and hypenated names for 100-999
  ([31277](https://github.com/civicrm/civicrm-core/pull/31277))**

  Adds support for version numbers 5.100 - 5.999.

- **Optimize Change Log Viewing For A Contact
  ([31125](https://github.com/civicrm/civicrm-core/pull/31125))**

  Optimizes the code for viewing the change logs for a contact.

### CiviContribute

- **Log payment processor errors that get reported to the user
  ([31412](https://github.com/civicrm/civicrm-core/pull/31412))**

  Improves logging of payment processor errors.

- **Add CustomField support to Products
  ([31250](https://github.com/civicrm/civicrm-core/pull/31250))**

  Adds support for custom fields on Products.

- **Improve product description
  ([31288](https://github.com/civicrm/civicrm-core/pull/31288))**

  Improves description for product.

### CiviMail

- **Mass SMS: enable access to reports
  ([31425](https://github.com/civicrm/civicrm-core/pull/31425))**

  Adds reports for Mass SMS.

### CiviMember

- **Membership User Dashboard.tpl adding Recurring links and cleanup
  ([31342](https://github.com/civicrm/civicrm-core/pull/31342))**

  Adds recurring links to the membership section of the user dashboard.

### Standalone Integration

- **Standalone System - use authx_login for authenticate flow
  ([31153](https://github.com/civicrm/civicrm-core/pull/31153))**

  Use the authx_login flow in CRM_Utils_System_Standalone::authenticate.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **reference to used address is lost - address master_id is set to NULL when
  referenced address or owning contact are edited
  ([dev/core#5592](https://lab.civicrm.org/dev/core/-/issues/5592):
  [31559](https://github.com/civicrm/civicrm-core/pull/31559))**
  
- **API v4 explorer: boolean params don't render correctly for CV (short)
  ([dev/core#4129](https://lab.civicrm.org/dev/core/-/issues/4129):
  [31393](https://github.com/civicrm/civicrm-core/pull/31393))**

- **Search Kit: DB Entity needs all columns to work
  ([dev/core#4629](https://lab.civicrm.org/dev/core/-/issues/4629):
  [31328](https://github.com/civicrm/civicrm-core/pull/31328))**

- **Afform - Reset button click does not refresh the search result once clicked
  ([dev/core#4871](https://lab.civicrm.org/dev/core/-/issues/4871):
  [31263](https://github.com/civicrm/civicrm-core/pull/31263))**

- **Group delete confirmation messages gives Confirm Group Delete and not the
  group name as the deleted group
  ([dev/core#5321](https://lab.civicrm.org/dev/core/-/issues/5321):
  [31406](https://github.com/civicrm/civicrm-core/pull/31406))**

- **Advanced Search initiated from QuickSearch doesn't show default search view
  ([dev/core#5437](https://lab.civicrm.org/dev/core/-/issues/5437):
  [31052](https://github.com/civicrm/civicrm-core/pull/31052))**

- **SearchKit: Column links don't work with grouped by searches
  ([dev/core#5453](https://lab.civicrm.org/dev/core/-/issues/5453):
  [31211](https://github.com/civicrm/civicrm-core/pull/31211))**

- **API4 Explorer Index
  ([dev/core#5515](https://lab.civicrm.org/dev/core/-/issues/5515):
  [31251](https://github.com/civicrm/civicrm-core/pull/31251))**

- **SearchKit: Can't save a DB Entity
  ([dev/core#5520](https://lab.civicrm.org/dev/core/-/issues/5520):
  [31360](https://github.com/civicrm/civicrm-core/pull/31360))**

- **Don't require both first and last name when creating contact
  ([dev/core#5545](https://lab.civicrm.org/dev/core/-/issues/5545):
  [31289](https://github.com/civicrm/civicrm-core/pull/31289))**

- **SearchKit: CSS issue allows editable fields to show through sticky table
  headers ([dev/core#5568](https://lab.civicrm.org/dev/core/-/issues/5568):
  [31396](https://github.com/civicrm/civicrm-core/pull/31396))**

- **5.79 : unable to install with fr_FR locale : broken SQL
  ([dev/core#5590](https://lab.civicrm.org/dev/core/-/issues/5590):
  [31482](https://github.com/civicrm/civicrm-core/pull/31482))**

- **Literal `<del>` appears in activity tab when source contact is soft-deleted
  ([dev/core#5609](https://lab.civicrm.org/dev/core/-/issues/5609):
  [31494](https://github.com/civicrm/civicrm-core/pull/31494))**

- **Afform - Do not allow DisplayOnly fields to submit
  ([31421](https://github.com/civicrm/civicrm-core/pull/31421))**

- **Afform - add css selector to distinguish multi select af field
  ([31316](https://github.com/civicrm/civicrm-core/pull/31316))**

- **Afform - Fix LocBlock address/email/phone saving
  ([31343](https://github.com/civicrm/civicrm-core/pull/31343))**

- **SearchKit - Fix collapsible toggle
  ([31474](https://github.com/civicrm/civicrm-core/pull/31474))**

- **SearchKit - Make hierarchical tables collapsible
  ([31408](https://github.com/civicrm/civicrm-core/pull/31408))**

- **AuthX [PHP User Deprecation] Permission 'authenticate with password' should
  be declared with 'label' and 'description' keys. ->
  Update hook_civicrm_permission to use new format
  ([dev/core#5551](https://lab.civicrm.org/dev/core/-/issues/5551):
  [31356](https://github.com/civicrm/civicrm-core/pull/31356))**

- **APIv4 - Fix date formatting
  ([31422](https://github.com/civicrm/civicrm-core/pull/31422))**

- **Api4 - Un-duplicate setLegacyDateFormat function
  ([31340](https://github.com/civicrm/civicrm-core/pull/31340))**

- **AdminUI - Add 'sticky-header' to all tables
  ([31414](https://github.com/civicrm/civicrm-core/pull/31414))**

- **Regression: resets text-rendered radio button width in confirmation screens
  ([31345](https://github.com/civicrm/civicrm-core/pull/31345))**

- **SettingsManager::bootSettings - derive $civicrm_root global if not set
  ([31335](https://github.com/civicrm/civicrm-core/pull/31335))**

- **Fix addScriptUrl missing joining / between base and file paths
  ([31362](https://github.com/civicrm/civicrm-core/pull/31362))**

- **Run successful scheduled jobs first
  ([29598](https://github.com/civicrm/civicrm-core/pull/29598))**

- **Add *.boot.setting.php meta for CIVICRM_UF_BASEURL and CIVICRM_DOMAIN_ID  
  ([31155](https://github.com/civicrm/civicrm-core/pull/31155))**

- **Api3 Setting.revert - dont swallow errors, fix one reverting constant
  settings ([31334](https://github.com/civicrm/civicrm-core/pull/31334))**

- **Update the help wording for DB Entity permissions
  ([31350](https://github.com/civicrm/civicrm-core/pull/31350))**

- **OAuth - opt into scan-classes to pick up Api4 entities
  ([31254](https://github.com/civicrm/civicrm-core/pull/31254))**

- **FormBuilder: Relative datetime doesn't support time
  ([dev/core#5517](https://lab.civicrm.org/dev/core/-/issues/5517):
  [31257](https://github.com/civicrm/civicrm-core/pull/31257))**

- **SearchSegmentExtraField - use AutoService rather than LegacySpecScanner
  ([31230](https://github.com/civicrm/civicrm-core/pull/31230))**

- **SearchDisplay rewrites: don't truncate long field keys
  ([31333](https://github.com/civicrm/civicrm-core/pull/31333))**

- **Increase size of url fields for website/activity
  ([31420](https://github.com/civicrm/civicrm-core/pull/31420))**

- **Drop binding current domain settings bag to CRM_Core_Config on boot
  ([30899](https://github.com/civicrm/civicrm-core/pull/30899))**

- **Advanced Search: icon for the Search Settings
  ([31293](https://github.com/civicrm/civicrm-core/pull/31293))**

- **Avoid duplicate ID on location form
  ([31287](https://github.com/civicrm/civicrm-core/pull/31287))**

- **crmSnippet - Fix regexes to match
  ([31349](https://github.com/civicrm/civicrm-core/pull/31349))**

- **Prevent CiviCRM resources from loading when not in CiviCRM admin
  ([331](https://github.com/civicrm/civicrm-wordpress/pull/331))**

- **Bugfix for windows machines
  ([31265](https://github.com/civicrm/civicrm-core/pull/31265))**

- **Notice fix
  ([31434](https://github.com/civicrm/civicrm-core/pull/31434))**

- **Fix merge
  ([31431](https://github.com/civicrm/civicrm-core/pull/31431))**

- **Fix fatal error if source is unavailable
  ([335](https://github.com/civicrm/civicrm-wordpress/pull/335))**

- **Fix deprecated warning in explode
  ([31227](https://github.com/civicrm/civicrm-core/pull/31227))**

### CiviCase

- **CiviCase Smarty5 Compatibility: Error "Unknown modifier 'sizeof'" when
  editing Case Status
  ([dev/core#5516](https://lab.civicrm.org/dev/core/-/issues/5516):
  [31256](https://github.com/civicrm/civicrm-core/pull/31256))**

### CiviCampaign

- **fix end date field in campaign form
  ([31506](https://github.com/civicrm/civicrm-core/pull/31506))**

- **add parent_id to campaign form entity fields
  ([31518](https://github.com/civicrm/civicrm-core/pull/31518))**

### CiviContribute

- **Incorrect profile retrieved for tribute profile
  ([dev/core#5510](https://lab.civicrm.org/dev/core/-/issues/5510):
  [31246](https://github.com/civicrm/civicrm-core/pull/31246))**

- **financial account mapping column on financial type admin screen shows
  english account names
  ([dev/financial#229](https://lab.civicrm.org/dev/financial/-/issues/229):
  [31486](https://github.com/civicrm/civicrm-core/pull/31486))**

- **Extract payment function
  ([31404](https://github.com/civicrm/civicrm-core/pull/31404))**

- **Contribution Confirm/ThankYou.tpl cleanup
  ([31311](https://github.com/civicrm/civicrm-core/pull/31311))**

- **Price Field: Field Type: remove help, simplify label
  ([31269](https://github.com/civicrm/civicrm-core/pull/31269))**

- **fix schema for financial type/account to have label_field=label
  ([31483](https://github.com/civicrm/civicrm-core/pull/31483))**

### CiviEvent

- **Emails no longer validated on event registration
  ([dev/core#5587](https://lab.civicrm.org/dev/core/-/issues/5587):
  [31455](https://github.com/civicrm/civicrm-core/pull/31455))**

- **Formbuilder/ event location: for an event creation, Existing event location
  cannot be selected if update box is not ticked
  ([dev/core#5526](https://lab.civicrm.org/dev/core/-/issues/5526):
  [31358](https://github.com/civicrm/civicrm-core/pull/31358))**

- **Formbuilder: event location is half created : I can see it in Manage events,
  but not in Searchkit/ Location address
  ([dev/core#5524](https://lab.civicrm.org/dev/core/-/issues/5524):
  [31285](https://github.com/civicrm/civicrm-core/pull/31285))**

- **set NOINDEX on non-public event registration pages
  ([dev/core#5449](https://lab.civicrm.org/dev/core/-/issues/5449):
  [31083](https://github.com/civicrm/civicrm-core/pull/31083))**

- **Event confirmation emails do not populate guest details when payment is
  confirmed by IPN (API)
  ([dev/core#224](https://lab.civicrm.org/dev/core/-/issues/224):
  [30374](https://github.com/civicrm/civicrm-core/pull/30374))**

- **Fix poor quality markup on no events message
  ([31329](https://github.com/civicrm/civicrm-core/pull/31329))**

- **fix typo in ParticipantStatusType entity
  ([31252](https://github.com/civicrm/civicrm-core/pull/31252))**

- **Event Profiles: remove HR tags
  ([31383](https://github.com/civicrm/civicrm-core/pull/31383))**

- **Event Profile: remove the preview button from the popup
  ([31384](https://github.com/civicrm/civicrm-core/pull/31384))**

### Backdrop Integration

- **FormBuilder on Backdrop does not show fields and elements to drag on to form
  ([dev/core#5561](https://lab.civicrm.org/dev/core/-/issues/5561):
  [31457](https://github.com/civicrm/civicrm-core/pull/31457))**

### Drupal Integration

- **searchkit download to xlsx broken in drupal 10
  ([dev/core#5620](https://lab.civicrm.org/dev/core/-/issues/5620):
  [31504](https://github.com/civicrm/civicrm-core/pull/31504))**

### Standalone Integration

- **standalone: can no longer login
  ([dev/core#5523](https://lab.civicrm.org/dev/core/-/issues/5523):
  [31281](https://github.com/civicrm/civicrm-core/pull/31281))**

- **Standalone: 'Reset Paths' in 'Cleanup Caches and Update Paths' logs the user
  out ([dev/core#5406](https://lab.civicrm.org/dev/core/-/issues/5406):
  [31418](https://github.com/civicrm/civicrm-core/pull/31418))**

- **Standalone: timezone handling issues
  ([dev/core#5392](https://lab.civicrm.org/dev/core/-/issues/5392):
  [31225](https://github.com/civicrm/civicrm-core/pull/31225))**

- **Disable FollowSymLinks by default in Standalone .htaccess
  ([30866](https://github.com/civicrm/civicrm-core/pull/30866))**

- **email propogation during Standalone user email creation
  ([31363](https://github.com/civicrm/civicrm-core/pull/31363))**

- **change param name for CRM_Core_Permission_Standalone::check to something
  that means something.
  ([31249](https://github.com/civicrm/civicrm-core/pull/31249))**

- **Standalone System - bring default Civi::paths factories in line with
  installer defaults
  ([31150](https://github.com/civicrm/civicrm-core/pull/31150))**

- **Standalone - Omit trailing `?` from query string
  ([31284](https://github.com/civicrm/civicrm-core/pull/31284))**

- **SettingsManager::bootSettings - fix providing CIVICRM_DSN directly on
  Standalone ([31216](https://github.com/civicrm/civicrm-core/pull/31216))**

- **standalone.css: lower padding around crm-container
  ([31361](https://github.com/civicrm/civicrm-core/pull/31361))**

### WordPress Integration

- **Shortcodes don't render in my theme in Civi 5.78+
  ([dev/core#5553](https://lab.civicrm.org/dev/core/-/issues/5553):
  [337](https://github.com/civicrm/civicrm-wordpress/pull/337))**

- **revert 151-lab due to issues discovered with shortcode button
  ([334](https://github.com/civicrm/civicrm-wordpress/pull/334))**

## <a name="misc"></a>Miscellany

- **Slightly more understandable tokens() function
  ([31379](https://github.com/civicrm/civicrm-core/pull/31379))**

- **Clean up the distmaker scripts
  ([31325](https://github.com/civicrm/civicrm-core/pull/31325))**

- **remove outdated references to getSystemDefaults in bootstrap_comments
  ([31248](https://github.com/civicrm/civicrm-core/pull/31248))**

- **Api4 - Remove unused pass-by-ref
  ([31245](https://github.com/civicrm/civicrm-core/pull/31245))**

- **Remove function that was deprecated over 2 years ago
  ([31407](https://github.com/civicrm/civicrm-core/pull/31407))**

- **Remove unreachable noisily deprecated code
  ([31242](https://github.com/civicrm/civicrm-core/pull/31242))**

- **Remove a chunk of unreachable noisily deprecated code
  ([31239](https://github.com/civicrm/civicrm-core/pull/31239))**

- **Remove noisily deprecated unreachable code
  ([31223](https://github.com/civicrm/civicrm-core/pull/31223))**

- **Remove unused variable
  ([31368](https://github.com/civicrm/civicrm-core/pull/31368))**

- **[REF] Standalone System - graduate some functions from
  Civi\Standalone\Security to CRM_Utils_System_Standalone and
  Civi\Authx\Standalone
  ([31127](https://github.com/civicrm/civicrm-core/pull/31127))**

- **[REF] Update PHPSpreadsheet to latest version in the 1.x series and allow
  composer to install the 2.x in D10
  ([31496](https://github.com/civicrm/civicrm-core/pull/31496))**

- **[REF] AfformGui - Update editOptions code to ES6
  ([31266](https://github.com/civicrm/civicrm-core/pull/31266))**

- **[REF] Fix empty label accessibility issue on report elements
  ([30694](https://github.com/civicrm/civicrm-core/pull/30694))**

- **[REF] Accessibility fixes in contact summary page
  ([30765](https://github.com/civicrm/civicrm-core/pull/30765))**

- **[REF] Ensure that when copying a mailing the status is reset to draftand
  start date and end date are blanked out
  ([31522](https://github.com/civicrm/civicrm-core/pull/31522))**

- **[REF] Fix setting mailing start date when the parent job starts "running"
  for delivery rather than when a child job is picked up
  ([31517](https://github.com/civicrm/civicrm-core/pull/31517))**

- **[REF][PHP8.2] Declare properies in CRM_Export_Form_Select
  ([31366](https://github.com/civicrm/civicrm-core/pull/31366))**

- **[REF][PHP8.2] Declare properies in CRM_Contact_Page_View_Tag
  ([31367](https://github.com/civicrm/civicrm-core/pull/31367))**

- **(NFC) Standalone - Tweak grammar
  ([31387](https://github.com/civicrm/civicrm-core/pull/31387))**

- **(Test-Only) Fix MinkBase::login() on WordPress
  ([31488](https://github.com/civicrm/civicrm-core/pull/31488))**

- **Add unit test to validate event
  ([31234](https://github.com/civicrm/civicrm-core/pull/31234))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Justin Freeman; Artful Robot - Rich
Lott; Benjamin W; BrightMinded Ltd - Bradley Taylor; Christian Wach; CiviCRM -
Coleman Watts, Tim Otten; Coop SymbioTIC - Mathieu Lutfy, Shane Bill; Dave D;
ECOPLAN - Torben Bertram; forumZFD - Marc Michalsky; JMA Consulting - Monish
Deb, Seamus Lee; John Kingsnorth; Lemniscus - Noah Miller; Megaphone Technology
Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Mosier Consulting -
Justin Mosier; Nicol Wistreich; Outlandish - Rasmus Winter; Parlamentwatch
e.V. - Philipp Michael; Squiffle Consulting - Aidan Saunders; Tadpole
Collective - Kevin Cristiano; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

ASMAC (American Society of Music Arrangers and Composers) - Jeff Kellem;
Australian Greens - Andrew Cormick-Dockery; Blackfly Solutions - Alan Dixon;
Circle Interactive - Dave Jenkins; CiviCRM - Coleman Watts, Tim Otten;
CiviDesk - Yashodha Chaku; Guydn; Humanists UK - Andrew West; Jade Gaunt;
Richard van Oosterhout; Stephen Palmstrom; Third Sector Design - Michael
McAndrew, William Mortada;
