<?php

return [
  'name' => 'Survey',
  'table' => 'civicrm_survey',
  'class' => 'CRM_Campaign_DAO_Survey',
  'getInfo' => fn() => [
    'title' => ts('Survey'),
    'title_plural' => ts('Surveys'),
    'description' => ts('Campaign Survey Details.'),
    'add' => '3.2',
    'icon' => 'fa-clipboard',
    'label_field' => 'title',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/survey/add?reset=1',
    'update' => 'civicrm/survey/configure/main?reset=1&action=update&id=[id]',
    'delete' => 'civicrm/survey/delete?reset=1&id=[id]',
  ],
  'getIndices' => fn() => [
    'UI_activity_type_id' => [
      'fields' => [
        'activity_type_id' => TRUE,
      ],
      'add' => '3.3',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Survey ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Survey id.'),
      'add' => '3.3',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'title' => [
      'title' => ts('Survey Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'required' => TRUE,
      'localizable' => TRUE,
      'description' => ts('Title of the Survey.'),
      'add' => '3.3',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'campaign_id' => [
      'title' => ts('Campaign ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('Foreign key to the Campaign.'),
      'add' => '3.3',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Campaign'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_campaign',
        'key_column' => 'id',
        'label_column' => 'title',
        'prefetch' => 'disabled',
      ],
      'entity_reference' => [
        'entity' => 'Campaign',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'activity_type_id' => [
      'title' => ts('Activity Type'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Implicit FK to civicrm_option_value where option_group = activity_type'),
      'add' => '3.3',
      'default' => NULL,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'pseudoconstant' => [
        'option_group_name' => 'activity_type',
        'condition_provider' => ['CRM_Campaign_BAO_Survey', 'alterActivityTypes'],
      ],
    ],
    'instructions' => [
      'title' => ts('Instructions'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('Script instructions for volunteers to use for the survey.'),
      'add' => '3.3',
      'input_attrs' => [
        'rows' => 20,
        'cols' => 80,
      ],
    ],
    'release_frequency' => [
      'title' => ts('Survey Hold Duration'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Number of days for recurrence of release.'),
      'add' => '3.3',
      'default' => NULL,
    ],
    'max_number_of_contacts' => [
      'title' => ts('Maximum number of contacts'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Maximum number of contacts to allow for survey.'),
      'add' => '3.3',
      'default' => NULL,
    ],
    'default_number_of_contacts' => [
      'title' => ts('Default number of contacts'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Default number of contacts to allow for survey.'),
      'add' => '3.3',
      'default' => NULL,
    ],
    'is_active' => [
      'title' => ts('Survey Is Active'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this survey enabled or disabled/cancelled?'),
      'add' => '3.3',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'is_default' => [
      'title' => ts('Is Default Survey'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this default survey?'),
      'add' => '3.3',
      'default' => FALSE,
      'input_attrs' => [
        'label' => ts('Default'),
      ],
    ],
    'created_id' => [
      'title' => ts('Created By Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to civicrm_contact, who created this Survey.'),
      'add' => '3.3',
      'default_callback' => ['CRM_Core_Session', 'getLoggedInContactID'],
      'input_attrs' => [
        'label' => ts('Created By'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'created_date' => [
      'title' => ts('Campaign Created Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time that Survey was created.'),
      'required' => TRUE,
      'readonly' => TRUE,
      'default' => 'CURRENT_TIMESTAMP',
      'input_attrs' => [
        'format_type' => 'activityDateTime',
        'label' => ts('Created Date'),
      ],
      'add' => '3.3',
    ],
    'last_modified_id' => [
      'title' => ts('Modified By Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to civicrm_contact, who recently edited this Survey.'),
      'add' => '3.3',
      'default_callback' => ['CRM_Core_Session', 'getLoggedInContactID'],
      'input_attrs' => [
        'label' => ts('Modified By'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'last_modified_date' => [
      'title' => ts('Survey Modified On'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time that Survey was edited last time.'),
      'required' => TRUE,
      'readonly' => TRUE,
      'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
      'add' => '3.3',
    ],
    'result_id' => [
      'title' => ts('Survey Result'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Used to store option group id.'),
      'add' => '3.3',
      'default' => NULL,
      'pseudoconstant' => [
        'table' => 'civicrm_option_group',
        'key_column' => 'id',
        'label_column' => 'title',
        'name_column' => 'name',
        'condition' => 'name LIKE "civicrm_survey_%"',
      ],
    ],
    'bypass_confirm' => [
      'title' => ts('No Email Verification'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Bypass the email verification.'),
      'add' => '4.2',
      'default' => FALSE,
    ],
    'thankyou_title' => [
      'title' => ts('Thank-you Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Title for Thank-you page (header title tag, and display at the top of the page).'),
      'add' => '4.2',
    ],
    'thankyou_text' => [
      'title' => ts('Thank-you Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('text and html allowed. displayed above result on success page'),
      'add' => '4.2',
      'input_attrs' => [
        'rows' => 8,
        'cols' => 60,
      ],
    ],
    'is_share' => [
      'title' => ts('Is shared through social media'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Can people share the petition through social media?'),
      'add' => '4.4',
      'default' => TRUE,
    ],
  ],
];
