<?php

return [
  'name' => 'PCP',
  'table' => 'civicrm_pcp',
  'class' => 'CRM_PCP_DAO_PCP',
  'getInfo' => fn() => [
    'title' => ts('Personal Campaign Page'),
    'title_plural' => ts('Personal Campaign Pages'),
    'description' => ts('Table containing list of Personal Campaign Pages'),
    'log' => TRUE,
    'add' => '2.2',
    'label_field' => 'title',
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Personal Campaign Page ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Personal Campaign Page ID'),
      'add' => '2.2',
      'unique_name' => 'pcp_id',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'contact_id' => [
      'title' => ts('Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('FK to Contact ID'),
      'add' => '2.2',
      'unique_name' => 'pcp_contact_id',
      'input_attrs' => [
        'label' => ts('Contact'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'status_id' => [
      'title' => ts('Personal Campaign Page Status'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'required' => TRUE,
      'add' => '2.2',
      'pseudoconstant' => [
        'option_group_name' => 'pcp_status',
      ],
    ],
    'title' => [
      'title' => ts('Personal Campaign Page Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'add' => '2.2',
      'default' => NULL,
    ],
    'intro_text' => [
      'title' => ts('Intro Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'add' => '2.2',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Intro Text'),
      ],
    ],
    'page_text' => [
      'title' => ts('Page Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'add' => '2.2',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Page Text'),
      ],
    ],
    'donate_link_text' => [
      'title' => ts('Donate Link Text'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'add' => '2.2',
      'default' => NULL,
    ],
    'page_id' => [
      'title' => ts('Contribution Page'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('The Contribution or Event Page which triggered this pcp'),
      'add' => '4.1',
      'entity_reference' => [
        'dynamic_entity' => 'page_type',
        'key' => 'id',
      ],
    ],
    'page_type' => [
      'title' => ts('PCP Page Type'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Select',
      'description' => ts('The type of PCP this is: contribute or event'),
      'add' => '2.2',
      'default' => 'contribute',
      'pseudoconstant' => [
        'callback' => 'CRM_PCP_BAO_PCP::pageTypeOptions',
      ],
    ],
    'pcp_block_id' => [
      'title' => ts('PCP Block'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('The pcp block that this pcp page was created from'),
      'add' => '4.1',
    ],
    'is_thermometer' => [
      'title' => ts('Use Thermometer?'),
      'sql_type' => 'int unsigned',
      'input_type' => 'CheckBox',
      'add' => '2.2',
      'default' => 0,
    ],
    'is_honor_roll' => [
      'title' => ts('Show Honor Roll?'),
      'sql_type' => 'int unsigned',
      'input_type' => 'CheckBox',
      'add' => '2.2',
      'default' => 0,
    ],
    'goal_amount' => [
      'title' => ts('Goal Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => 'Text',
      'description' => ts('Goal amount of this Personal Campaign Page.'),
      'add' => '2.2',
    ],
    'currency' => [
      'title' => ts('Currency'),
      'sql_type' => 'varchar(3)',
      'input_type' => 'Select',
      'description' => ts('3 character string, value from config setting or input via user.'),
      'add' => '3.2',
      'default' => NULL,
      'pseudoconstant' => [
        'table' => 'civicrm_currency',
        'key_column' => 'name',
        'label_column' => 'full_name',
        'name_column' => 'name',
        'abbr_column' => 'symbol',
      ],
    ],
    'is_active' => [
      'title' => ts('Enabled?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is Personal Campaign Page enabled/active?'),
      'add' => '2.2',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'is_notify' => [
      'title' => ts('Notify Owner?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Notify owner via email when someone donates to page?'),
      'add' => '4.6',
      'default' => FALSE,
    ],
  ],
];
