<?php

return [
  'name' => 'Participant',
  'table' => 'civicrm_participant',
  'class' => 'CRM_Event_DAO_Participant',
  'getInfo' => fn() => [
    'title' => ts('Participant'),
    'title_plural' => ts('Participants'),
    'description' => ts('Records of contacts\' attendance and roles in events.'),
    'log' => TRUE,
    'add' => '1.7',
    'icon' => 'fa-ticket',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/participant/add?action=add&context=standalone&reset=1',
    'view' => 'civicrm/contact/view/participant?id=[id]&cid=[contact_id]&action=view&reset=1',
    'update' => 'civicrm/contact/view/participant?id=[id]&cid=[contact_id]&action=update&reset=1',
    'detach' => 'civicrm/event/selfsvcupdate?reset=1&pid=[id]&is_backoffice=1',
    'delete' => 'civicrm/participant/delete?id=[id]&reset=1',
  ],
  'getIndices' => fn() => [
    'index_status_id' => [
      'fields' => [
        'status_id' => TRUE,
      ],
      'add' => '1.8',
    ],
    'index_role_id' => [
      'fields' => [
        'role_id' => TRUE,
      ],
      'add' => '1.8',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Participant ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Participant ID'),
      'add' => '1.7',
      'unique_name' => 'participant_id',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'contact_id' => [
      'title' => ts('Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('FK to Contact ID'),
      'add' => '1.7',
      'unique_name' => 'participant_contact_id',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Contact'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'event_id' => [
      'title' => ts('Event ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('FK to Event ID'),
      'add' => '1.7',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Event'),
      ],
      'entity_reference' => [
        'entity' => 'Event',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'status_id' => [
      'title' => ts('Status ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('Participant status ID. FK to civicrm_participant_status_type. Default of 1 should map to status = Registered.'),
      'add' => '1.7',
      'unique_name' => 'participant_status_id',
      'default' => 1,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Status'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_participant_status_type',
        'key_column' => 'id',
        'label_column' => 'label',
      ],
      'entity_reference' => [
        'entity' => 'ParticipantStatusType',
        'key' => 'id',
      ],
    ],
    'role_id' => [
      'title' => ts('Participant Role ID'),
      'sql_type' => 'varchar(128)',
      'input_type' => 'Select',
      'description' => ts('Participant role ID. Implicit FK to civicrm_option_value where option_group = participant_role.'),
      'add' => '1.7',
      'unique_name' => 'participant_role_id',
      'default' => NULL,
      'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_TRIMMED,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'multiple' => '1',
        'label' => ts('Participant Role'),
      ],
      'pseudoconstant' => [
        'option_group_name' => 'participant_role',
      ],
    ],
    'register_date' => [
      'title' => ts('Register date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('When did contact register for event?'),
      'add' => '1.7',
      'unique_name' => 'participant_register_date',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'format_type' => 'activityDateTime',
      ],
    ],
    'source' => [
      'title' => ts('Participant Source'),
      'sql_type' => 'varchar(128)',
      'input_type' => 'Text',
      'description' => ts('Source of this event registration.'),
      'add' => '1.7',
      'unique_name' => 'participant_source',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'fee_level' => [
      'title' => ts('Fee level'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'description' => ts('Populate with the label (text) associated with a fee level for paid events with multiple levels. Note that we store the label value and not the key'),
      'add' => '1.7',
      'unique_name' => 'participant_fee_level',
      'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_BOOKEND,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'is_test' => [
      'title' => ts('Test'),
      'sql_type' => 'boolean',
      'input_type' => 'Radio',
      'required' => TRUE,
      'add' => '1.7',
      'unique_name' => 'participant_is_test',
      'default' => FALSE,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'is_pay_later' => [
      'title' => ts('Is Pay Later'),
      'sql_type' => 'boolean',
      'input_type' => 'Radio',
      'required' => TRUE,
      'add' => '2.1',
      'unique_name' => 'participant_is_pay_later',
      'default' => FALSE,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'fee_amount' => [
      'title' => ts('Fee Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => 'Text',
      'description' => ts('actual processor fee if known - may be 0.'),
      'add' => '2.1',
      'unique_name' => 'participant_fee_amount',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'registered_by_id' => [
      'title' => ts('Registered By Participant ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to Participant ID'),
      'add' => '2.1',
      'unique_name' => 'participant_registered_by_id',
      'default' => NULL,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Registered By Participant'),
      ],
      'entity_reference' => [
        'entity' => 'Participant',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'discount_id' => [
      'title' => ts('Discount ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to Discount ID'),
      'add' => '2.1',
      'unique_name' => 'participant_discount_id',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Discount'),
      ],
      'entity_reference' => [
        'entity' => 'Discount',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'fee_currency' => [
      'title' => ts('Fee Currency'),
      'sql_type' => 'varchar(3)',
      'input_type' => 'Select',
      'description' => ts('3 character string, value derived from config setting.'),
      'add' => '3.0',
      'unique_name' => 'participant_fee_currency',
      'default' => NULL,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_currency',
        'key_column' => 'name',
        'label_column' => 'full_name',
        'name_column' => 'name',
        'abbr_column' => 'symbol',
      ],
    ],
    'campaign_id' => [
      'title' => ts('Campaign ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('The campaign for which this participant has been registered.'),
      'add' => '3.4',
      'unique_name' => 'participant_campaign_id',
      'component' => 'CiviCampaign',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Campaign'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_campaign',
        'key_column' => 'id',
        'label_column' => 'title',
        'prefetch' => 'disabled',
      ],
      'entity_reference' => [
        'entity' => 'Campaign',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'discount_amount' => [
      'title' => ts('Discount Amount'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Discount Amount'),
      'add' => '4.1',
    ],
    'must_wait' => [
      'title' => ts('Must Wait on List'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'description' => ts('On Waiting List'),
      'add' => '4.1',
    ],
    'transferred_to_contact_id' => [
      'title' => ts('Transferred to Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to Contact ID'),
      'add' => '4.7',
      'unique_name' => 'transferred_to_contact_id',
      'default' => NULL,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Transferred to'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'created_id' => [
      'title' => ts('Created by Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('Contact responsible for registering this participant'),
      'add' => '5.54',
      'input_attrs' => [
        'label' => ts('Created By'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
  ],
];
