<?php

return [
  'name' => 'CustomGroup',
  'table' => 'civicrm_custom_group',
  'class' => 'CRM_Core_DAO_CustomGroup',
  'getInfo' => fn() => [
    'title' => ts('Custom Field Group'),
    'title_plural' => ts('Custom Field Groups'),
    'description' => ts('All extended (custom) properties are associated with a group. These are logical sets of related data.'),
    'log' => TRUE,
    'add' => '1.1',
    'label_field' => 'title',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/admin/custom/group/edit?action=add&reset=1',
    'update' => 'civicrm/admin/custom/group/edit?action=update&reset=1&id=[id]',
    'preview' => 'civicrm/admin/custom/group/preview?reset=1&gid=[id]',
    'delete' => 'civicrm/admin/custom/group/delete?reset=1&id=[id]',
    'browse' => 'civicrm/admin/custom/group',
  ],
  'getIndices' => fn() => [
    'UI_title_extends' => [
      'fields' => [
        'title' => TRUE,
        'extends' => TRUE,
      ],
      'unique' => TRUE,
      'add' => '2.1',
    ],
    'UI_name' => [
      'fields' => [
        'name' => TRUE,
      ],
      'unique' => TRUE,
      'add' => '5.47',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Custom Group ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Unique Custom Group ID'),
      'add' => '1.1',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'name' => [
      'title' => ts('Custom Group Name'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Text',
      'description' => ts('Variable name/programmatic handle for this group.'),
      'add' => '1.1',
    ],
    'title' => [
      'title' => ts('Custom Group Title'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Text',
      'required' => TRUE,
      'localizable' => TRUE,
      'description' => ts('Friendly Name.'),
      'add' => '1.1',
    ],
    'extends' => [
      'title' => ts('Custom Group Extends'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Select',
      'description' => ts('Type of object this group extends (can add other options later e.g. contact_address, etc.).'),
      'add' => '1.1',
      'default' => 'Contact',
      'pseudoconstant' => [
        'callback' => 'CRM_Core_BAO_CustomGroup::getCustomGroupExtendsOptions',
        'suffixes' => [
          'name',
          'label',
          'grouping',
          'icon',
        ],
      ],
    ],
    'extends_entity_column_id' => [
      'title' => ts('Custom Group Subtype List'),
      'sql_type' => 'int unsigned',
      'input_type' => 'ChainSelect',
      'description' => ts('FK to civicrm_option_value.value (for option group custom_data_type)'),
      'add' => '2.2',
      'default' => NULL,
      'input_attrs' => [
        'control_field' => 'extends',
      ],
      'pseudoconstant' => [
        'callback' => 'CRM_Core_BAO_CustomGroup::getExtendsEntityColumnIdOptions',
        'suffixes' => [
          'name',
          'label',
          'grouping',
        ],
      ],
    ],
    'extends_entity_column_value' => [
      'title' => ts('Custom Group Subtype'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'ChainSelect',
      'description' => ts('linking custom group for dynamic object'),
      'add' => '1.6',
      'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_BOOKEND,
      'input_attrs' => [
        'control_field' => 'extends_entity_column_id',
      ],
      'pseudoconstant' => [
        'callback' => 'CRM_Core_BAO_CustomGroup::getExtendsEntityColumnValueOptions',
      ],
    ],
    'style' => [
      'title' => ts('Custom Group Style'),
      'sql_type' => 'varchar(15)',
      'input_type' => 'Select',
      'description' => ts('Visual relationship between this form and its parent.'),
      'add' => '1.1',
      'pseudoconstant' => [
        'callback' => 'CRM_Core_SelectValues::customGroupStyle',
      ],
    ],
    'collapse_display' => [
      'title' => ts('Collapse Custom Group?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Will this group be in collapsed or expanded mode on initial display ?'),
      'add' => '1.1',
      'default' => FALSE,
    ],
    'help_pre' => [
      'title' => ts('Custom Group Pre Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Description and/or help text to display before fields in form.'),
      'add' => '1.1',
      'input_attrs' => [
        'rows' => 4,
        'cols' => 80,
      ],
    ],
    'help_post' => [
      'title' => ts('Custom Group Post Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Description and/or help text to display after fields in form.'),
      'add' => '1.1',
      'input_attrs' => [
        'rows' => 4,
        'cols' => 80,
      ],
    ],
    'weight' => [
      'title' => ts('Order'),
      'sql_type' => 'int',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Controls display order when multiple extended property groups are setup for the same class.'),
      'add' => '1.1',
      'default' => 1,
    ],
    'is_active' => [
      'title' => ts('Custom Group Is Active?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this property active?'),
      'add' => '1.1',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'table_name' => [
      'title' => ts('Table Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => NULL,
      'readonly' => TRUE,
      'description' => ts('Name of the table that holds the values for this group.'),
      'add' => '2.0',
      'input_attrs' => [
        'label' => ts('Table Name'),
      ],
    ],
    'is_multiple' => [
      'title' => ts('Supports Multiple Records'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Does this group hold multiple values?'),
      'add' => '2.0',
      'default' => FALSE,
    ],
    'min_multiple' => [
      'title' => ts('Minimum Multiple Records'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('minimum number of multiple records (typically 0?)'),
      'add' => '2.2',
    ],
    'max_multiple' => [
      'title' => ts('Maximum Multiple Records'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('maximum number of multiple records, if 0 - no max'),
      'add' => '2.2',
    ],
    'collapse_adv_display' => [
      'title' => ts('Collapse Group Display'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Will this group be in collapsed or expanded mode on advanced search display ?'),
      'add' => '3.0',
      'default' => FALSE,
    ],
    'created_id' => [
      'title' => ts('Created By Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to civicrm_contact, who created this custom group'),
      'add' => '3.0',
      'input_attrs' => [
        'label' => ts('Created By'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'created_date' => [
      'title' => ts('Custom Group Created Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time this custom group was created.'),
      'add' => '3.0',
    ],
    'is_reserved' => [
      'title' => ts('Reserved Group?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this a reserved Custom Group?'),
      'add' => '4.4',
      'default' => FALSE,
    ],
    'is_public' => [
      'title' => ts('Custom Group Is Public?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this property public?'),
      'add' => '4.7',
      'default' => TRUE,
    ],
    'icon' => [
      'title' => ts('Icon'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('crm-i icon class'),
      'add' => '5.28',
      'default' => NULL,
    ],
  ],
];
