<?php

return [
  'name' => 'ContributionRecur',
  'table' => 'civicrm_contribution_recur',
  'class' => 'CRM_Contribute_DAO_ContributionRecur',
  'getInfo' => fn() => [
    'title' => ts('Recurring Contribution'),
    'title_plural' => ts('Recurring Contributions'),
    'description' => ts('Table of Recurring Contributions'),
    'log' => TRUE,
    'add' => '1.6',
  ],
  'getIndices' => fn() => [
    'UI_contrib_trxn_id' => [
      'fields' => [
        'trxn_id' => TRUE,
      ],
      'unique' => TRUE,
      'add' => '2.1',
    ],
    'UI_contrib_invoice_id' => [
      'fields' => [
        'invoice_id' => TRUE,
      ],
      'unique' => TRUE,
      'add' => '2.1',
    ],
    'index_contribution_status' => [
      'fields' => [
        'contribution_status_id' => TRUE,
      ],
      'add' => '1.6',
    ],
    'UI_contribution_recur_payment_instrument_id' => [
      'fields' => [
        'payment_instrument_id' => TRUE,
      ],
      'add' => '4.1',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Recurring Contribution ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Contribution Recur ID'),
      'add' => '1.6',
      'unique_name' => 'contribution_recur_id',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'contact_id' => [
      'title' => ts('Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('Foreign key to civicrm_contact.id.'),
      'add' => '1.6',
      'input_attrs' => [
        'label' => ts('Contact'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'amount' => [
      'title' => ts('Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('Amount to be collected (including any sales tax) by payment processor each recurrence.'),
      'add' => '1.6',
    ],
    'currency' => [
      'title' => ts('Currency'),
      'sql_type' => 'varchar(3)',
      'input_type' => 'Select',
      'description' => ts('3 character string, value from config setting or input via user.'),
      'add' => '3.2',
      'default' => NULL,
      'pseudoconstant' => [
        'table' => 'civicrm_currency',
        'key_column' => 'name',
        'label_column' => 'full_name',
        'name_column' => 'name',
        'abbr_column' => 'symbol',
      ],
    ],
    'frequency_unit' => [
      'title' => ts('Frequency Unit'),
      'sql_type' => 'varchar(8)',
      'input_type' => 'Select',
      'description' => ts('Time units for recurrence of payment.'),
      'add' => '1.6',
      'default' => 'month',
      'pseudoconstant' => [
        'option_group_name' => 'recur_frequency_units',
        'key_column' => 'name',
      ],
    ],
    'frequency_interval' => [
      'title' => ts('Interval (number of units)'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('Number of time units for recurrence of payment.'),
      'add' => '1.6',
      'default' => 1,
    ],
    'installments' => [
      'title' => ts('Number of Installments'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'description' => ts('Total number of payments to be made. Set this to 0 if this is an open-ended commitment i.e. no set end date.'),
      'add' => '1.6',
    ],
    'start_date' => [
      'title' => ts('Start Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'required' => TRUE,
      'description' => ts('The date the first scheduled recurring contribution occurs.'),
      'add' => '1.6',
      'unique_name' => 'contribution_recur_start_date',
      'unique_title' => 'Recurring Contribution Start Date',
      'default' => 'CURRENT_TIMESTAMP',
      'input_attrs' => [
        'format_type' => 'activityDateTime',
      ],
    ],
    'create_date' => [
      'title' => ts('Created Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'required' => TRUE,
      'description' => ts('When this recurring contribution record was created.'),
      'add' => '1.6',
      'unique_name' => 'contribution_recur_create_date',
      'unique_title' => 'Recurring Contribution Create Date',
      'default' => 'CURRENT_TIMESTAMP',
      'input_attrs' => [
        'format_type' => 'activityDateTime',
      ],
    ],
    'modified_date' => [
      'title' => ts('Modified Date'),
      'sql_type' => 'timestamp',
      'input_type' => 'Select Date',
      'readonly' => TRUE,
      'description' => ts('Last updated date for this record. mostly the last time a payment was received'),
      'add' => '1.6',
      'unique_name' => 'contribution_recur_modified_date',
      'unique_title' => 'Recurring Contribution Modified Date',
      'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
      'input_attrs' => [
        'format_type' => 'activityDateTime',
      ],
    ],
    'cancel_date' => [
      'title' => ts('Cancel Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date this recurring contribution was cancelled by contributor- if we can get access to it'),
      'add' => '1.6',
      'unique_name' => 'contribution_recur_cancel_date',
      'unique_title' => 'Recurring Contribution Cancel Date',
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'cancel_reason' => [
      'title' => ts('Cancellation Reason'),
      'sql_type' => 'text',
      'input_type' => 'Text',
      'description' => ts('Free text field for a reason for cancelling'),
      'add' => '5.13',
      'unique_name' => 'contribution_recur_cancel_reason',
      'unique_title' => 'Recurring Contribution Cancel Reason',
      'input_attrs' => [
        'size' => '40',
      ],
    ],
    'end_date' => [
      'title' => ts('Recurring Contribution End Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date this recurring contribution finished successfully'),
      'add' => '1.6',
      'unique_name' => 'contribution_recur_end_date',
      'unique_title' => 'Recurring Contribution End Date',
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'processor_id' => [
      'title' => ts('Processor ID'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Possibly needed to store a unique identifier for this recurring payment order - if this is available from the processor??'),
      'add' => '1.6',
      'unique_name' => 'contribution_recur_processor_id',
    ],
    'payment_token_id' => [
      'title' => ts('Payment Token ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('Optionally used to store a link to a payment token used for this recurring contribution.'),
      'add' => '4.6',
      'input_attrs' => [
        'label' => ts('Payment Token'),
      ],
      'entity_reference' => [
        'entity' => 'PaymentToken',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'trxn_id' => [
      'title' => ts('Transaction ID'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('unique transaction id (deprecated - use processor_id)'),
      'add' => '1.6',
      'unique_name' => 'contribution_recur_trxn_id',
    ],
    'invoice_id' => [
      'title' => ts('Invoice ID'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('unique invoice id, system generated or passed in'),
      'add' => '1.6',
    ],
    'contribution_status_id' => [
      'title' => ts('Status'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'add' => '1.6',
      'unique_name' => 'contribution_recur_contribution_status_id',
      'default' => 2,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'pseudoconstant' => [
        'option_group_name' => 'contribution_recur_status',
      ],
    ],
    'is_test' => [
      'title' => ts('Test'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'default' => FALSE,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'cycle_day' => [
      'title' => ts('Cycle Day'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('Day in the period when the payment should be charged e.g. 1st of month, 15th etc.'),
      'add' => '1.6',
      'default' => 1,
    ],
    'next_sched_contribution_date' => [
      'title' => ts('Next Scheduled Contribution Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Next scheduled date'),
      'add' => '4.4',
      'unique_name' => 'contribution_recur_next_sched_contribution_date',
      'unique_title' => 'Next Scheduled Recurring Contribution',
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'failure_count' => [
      'title' => ts('Number of Failures'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'description' => ts('Number of failed charge attempts since last success. Business rule could be set to deactivate on more than x failures.'),
      'add' => '1.6',
      'default' => 0,
    ],
    'failure_retry_date' => [
      'title' => ts('Retry Failed Attempt Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date to retry failed attempt'),
      'add' => '1.6',
      'unique_name' => 'contribution_recur_failure_retry_date',
      'unique_title' => 'Failed Recurring Contribution Retry Date',
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'auto_renew' => [
      'title' => ts('Auto Renew'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Some systems allow contributor to set a number of installments - but then auto-renew the subscription or commitment if they do not cancel.'),
      'add' => '1.6',
      'default' => FALSE,
    ],
    'payment_processor_id' => [
      'title' => ts('Payment Processor ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Foreign key to civicrm_payment_processor.id'),
      'add' => '3.3',
      'unique_name' => 'contribution_recur_payment_processor_id',
      'input_attrs' => [
        'label' => ts('Payment Processor'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_payment_processor',
        'key_column' => 'id',
        'label_column' => 'title',
      ],
      'entity_reference' => [
        'entity' => 'PaymentProcessor',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'financial_type_id' => [
      'title' => ts('Financial Type ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('FK to Financial Type'),
      'add' => '4.3',
      'input_attrs' => [
        'label' => ts('Financial Type'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_financial_type',
        'key_column' => 'id',
        'label_column' => 'name',
      ],
      'entity_reference' => [
        'entity' => 'FinancialType',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'payment_instrument_id' => [
      'title' => ts('Payment Method'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('FK to Payment Instrument'),
      'add' => '4.1',
      'pseudoconstant' => [
        'option_group_name' => 'payment_instrument',
      ],
    ],
    'campaign_id' => [
      'title' => ts('Campaign ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('The campaign for which this contribution has been triggered.'),
      'add' => '4.1',
      'unique_name' => 'contribution_campaign_id',
      'component' => 'CiviCampaign',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Campaign'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_campaign',
        'key_column' => 'id',
        'label_column' => 'title',
        'prefetch' => 'disabled',
      ],
      'entity_reference' => [
        'entity' => 'Campaign',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'is_email_receipt' => [
      'title' => ts('Send email Receipt?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if TRUE, receipt is automatically emailed to contact on each successful payment'),
      'add' => '4.1',
      'default' => TRUE,
    ],
  ],
];
