<?php

return [
  'name' => 'SavedSearch',
  'table' => 'civicrm_saved_search',
  'class' => 'CRM_Contact_DAO_SavedSearch',
  'getInfo' => fn() => [
    'title' => ts('Saved Search'),
    'title_plural' => ts('Saved Searches'),
    'description' => ts('Users can save their complex SQL queries and use them later.'),
    'add' => '1.1',
    'icon' => 'fa-search-plus',
    'label_field' => 'label',
  ],
  'getIndices' => fn() => [
    'UI_name' => [
      'fields' => [
        'name' => TRUE,
      ],
      'unique' => TRUE,
      'add' => '5.32',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Saved Search ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Saved Search ID'),
      'add' => '1.1',
      'input_attrs' => [
        'label' => ts('ID'),
      ],
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'name' => [
      'title' => ts('Saved Search Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Unique name of saved search'),
      'add' => '1.0',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Name'),
      ],
    ],
    'label' => [
      'title' => ts('Saved Search Label'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('Administrative label for search'),
      'add' => '5.32',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Label'),
      ],
    ],
    'form_values' => [
      'title' => ts('Submitted Form Values'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'description' => ts('Submitted form values for this search'),
      'add' => '1.1',
      'serialize' => CRM_Core_DAO::SERIALIZE_PHP,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'mapping_id' => [
      'title' => ts('Mapping ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('Foreign key to civicrm_mapping used for saved search-builder searches.'),
      'add' => '1.5',
      'input_attrs' => [
        'label' => ts('Mapping'),
      ],
      'entity_reference' => [
        'entity' => 'Mapping',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'search_custom_id' => [
      'title' => ts('Option Value ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Foreign key to civicrm_option value table used for saved custom searches.'),
      'add' => '2.0',
    ],
    'api_entity' => [
      'title' => ts('Entity Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Select',
      'description' => ts('Entity name for API based search'),
      'add' => '5.24',
      'input_attrs' => [
        'label' => ts('For'),
      ],
      'pseudoconstant' => [
        'callback' => 'CRM_Contact_BAO_SavedSearch::getApiEntityOptions',
      ],
    ],
    'api_params' => [
      'title' => ts('API Parameters'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'description' => ts('Parameters for API based search'),
      'add' => '5.24',
      'serialize' => CRM_Core_DAO::SERIALIZE_JSON,
    ],
    'created_id' => [
      'title' => ts('Created By Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => NULL,
      'readonly' => TRUE,
      'description' => ts('FK to contact table.'),
      'add' => '5.36',
      'input_attrs' => [
        'label' => ts('Created By'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'modified_id' => [
      'title' => ts('Modified By Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => NULL,
      'readonly' => TRUE,
      'description' => ts('FK to contact table.'),
      'add' => '5.36',
      'input_attrs' => [
        'label' => ts('Modified By'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'expires_date' => [
      'title' => ts('Search Expiry Date'),
      'sql_type' => 'timestamp',
      'input_type' => NULL,
      'description' => ts('Optional date after which the search is not needed'),
      'add' => '5.36',
    ],
    'created_date' => [
      'title' => ts('Created Date'),
      'sql_type' => 'timestamp',
      'input_type' => NULL,
      'required' => TRUE,
      'readonly' => TRUE,
      'description' => ts('When the search was created.'),
      'add' => '5.36',
      'default' => 'CURRENT_TIMESTAMP',
    ],
    'modified_date' => [
      'title' => ts('Modified Date'),
      'sql_type' => 'timestamp',
      'input_type' => NULL,
      'required' => TRUE,
      'readonly' => TRUE,
      'description' => ts('When the search was last modified.'),
      'add' => '5.36',
      'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP',
    ],
    'description' => [
      'title' => ts('Saved Search Description'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'add' => '5.36',
      'input_attrs' => [
        'label' => ts('Description'),
        'rows' => 2,
        'cols' => 60,
      ],
    ],
  ],
];
