<?php
use CRM_CivicrmAdminUi_ExtensionUtil as E;

return [
  [
    'name' => 'SavedSearch_SMS_Provider',
    'entity' => 'SavedSearch',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'SMS_Provider',
        'label' => E::ts('SMS Provider'),
        'api_entity' => 'SmsProvider',
        'api_params' => [
          'version' => 4,
          'select' => [
            'id',
            'title',
            'is_active',
            'name',
            'api_params',
            'username',
            'api_url',
            'api_type:label',
          ],
          'orderBy' => [],
          'where' => [],
          'groupBy' => [],
          'join' => [],
          'having' => [],
        ],
      ],
      'match' => [
        'name',
      ],
    ],
  ],
  [
    'name' => 'SavedSearch_SMS_Provider_SearchDisplay_SMS_Provider_Table_1',
    'entity' => 'SearchDisplay',
    'cleanup' => 'unused',
    'update' => 'unmodified',
    'params' => [
      'version' => 4,
      'values' => [
        'name' => 'SMS_Provider_Table_1',
        'label' => E::ts('SMS Provider'),
        'saved_search_id.name' => 'SMS_Provider',
        'type' => 'table',
        'settings' => [
          'description' => NULL,
          'sort' => [],
          'limit' => 50,
          'pager' => [],
          'placeholder' => 5,
          'columns' => [
            [
              'type' => 'field',
              'key' => 'id',
              'dataType' => 'Integer',
              'label' => E::ts('ID'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'html',
              'key' => 'name',
              'dataType' => 'String',
              'label' => E::ts('Provider Details'),
              'sortable' => TRUE,
              'rewrite' => '<strong>[name]</strong> ([title])<br>API Type: [api_type:label]<br>API Url:[api_url]',
            ],
            [
              'type' => 'field',
              'key' => 'username',
              'dataType' => 'String',
              'label' => E::ts('Username'),
              'sortable' => TRUE,
            ],
            [
              'type' => 'field',
              'key' => 'api_params',
              'dataType' => 'Text',
              'label' => E::ts('API Parameters'),
              'sortable' => TRUE,
              'rewrite' => '',
            ],
            [
              'text' => '',
              'style' => 'default',
              'size' => 'btn-xs',
              'icon' => 'fa-bars',
              'links' => [
                [
                  'entity' => 'SmsProvider',
                  'action' => 'update',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-pencil',
                  'text' => E::ts('Edit'),
                  'style' => 'default',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
                [
                  'task' => 'enable',
                  'entity' => 'SmsProvider',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-on',
                  'text' => E::ts('Enable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                ],
                [
                  'task' => 'disable',
                  'entity' => 'SmsProvider',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-toggle-off',
                  'text' => E::ts('Disable'),
                  'style' => 'default',
                  'path' => '',
                  'action' => '',
                ],
                [
                  'entity' => 'SmsProvider',
                  'action' => 'delete',
                  'join' => '',
                  'target' => 'crm-popup',
                  'icon' => 'fa-trash',
                  'text' => E::ts('Delete'),
                  'style' => 'danger',
                  'path' => '',
                  'task' => '',
                  'condition' => [],
                ],
              ],
              'type' => 'menu',
              'alignment' => 'text-right',
            ],
          ],
          'actions' => [
            'delete',
            'disable',
            'enable',
          ],
          'classes' => [
            'table',
            'table-striped',
          ],
          'toolbar' => [
            [
              'action' => 'add',
              'entity' => 'SmsProvider',
              'text' => E::ts('Add SMS Provider'),
              'icon' => 'fa-plus',
              'style' => 'primary',
              'target' => 'crm-popup',
              'join' => '',
              'path' => '',
              'task' => '',
              'condition' => [],
            ],
          ],
          'cssRules' => [
            [
              'disabled',
              'is_active',
              '=',
              FALSE,
            ],
          ],
        ],
      ],
      'match' => [
        'name',
        'saved_search_id',
      ],
    ],
  ],
];
