<?php

return [
  'name' => 'Pledge',
  'table' => 'civicrm_pledge',
  'class' => 'CRM_Pledge_DAO_Pledge',
  'getInfo' => fn() => [
    'title' => ts('Pledge'),
    'title_plural' => ts('Pledges'),
    'description' => ts('Promises to contribute at a future time, either in full, or at regular intervals until a total goal is reached.'),
    'log' => TRUE,
    'add' => '2.1',
    'icon' => 'fa-paper-plane',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/pledge/add?action=add&context=standalone&reset=1',
    'view' => 'civicrm/contact/view/pledge?id=[id]&cid=[contact_id]&action=view&reset=1',
    'update' => 'civicrm/contact/view/pledge?id=[id]&cid=[contact_id]&action=update&reset=1',
    'delete' => 'civicrm/contact/view/pledge?id=[id]&cid=[contact_id]&action=delete&reset=1',
  ],
  'getIndices' => fn() => [
    'index_status' => [
      'fields' => [
        'status_id' => TRUE,
      ],
      'add' => '2.1',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Pledge ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Pledge ID'),
      'add' => '2.1',
      'unique_name' => 'pledge_id',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'contact_id' => [
      'title' => ts('Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('Foreign key to civicrm_contact.id .'),
      'add' => '2.1',
      'unique_name' => 'pledge_contact_id',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Contact'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'CASCADE',
      ],
    ],
    'financial_type_id' => [
      'title' => ts('Financial Type ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('FK to Financial Type'),
      'add' => '4.3',
      'unique_name' => 'pledge_financial_type_id',
      'input_attrs' => [
        'label' => ts('Financial Type'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_financial_type',
        'key_column' => 'id',
        'label_column' => 'label',
      ],
      'entity_reference' => [
        'entity' => 'FinancialType',
        'key' => 'id',
      ],
    ],
    'contribution_page_id' => [
      'title' => ts('Contribution Page ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('The Contribution Page which triggered this contribution'),
      'add' => '2.1',
      'unique_name' => 'pledge_contribution_page_id',
      'input_attrs' => [
        'label' => ts('Contribution Page'),
      ],
      'entity_reference' => [
        'entity' => 'ContributionPage',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'amount' => [
      'title' => ts('Total Pledged'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('Total pledged amount.'),
      'add' => '2.1',
      'unique_name' => 'pledge_amount',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'original_installment_amount' => [
      'title' => ts('Original Installment Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('Original amount for each of the installments.'),
      'add' => '3.2',
      'unique_name' => 'pledge_original_installment_amount',
      'usage' => [
        'export',
      ],
    ],
    'currency' => [
      'title' => ts('Pledge Currency'),
      'sql_type' => 'varchar(3)',
      'input_type' => 'Select',
      'description' => ts('3 character string, value from config setting or input via user.'),
      'add' => '3.2',
      'default' => NULL,
      'pseudoconstant' => [
        'table' => 'civicrm_currency',
        'key_column' => 'name',
        'label_column' => 'full_name',
        'name_column' => 'name',
        'abbr_column' => 'symbol',
        'description_column' => 'IFNULL(CONCAT(name, " (", symbol, ")"), name)',
      ],
    ],
    'frequency_unit' => [
      'title' => ts('Pledge Frequency Unit'),
      'sql_type' => 'varchar(8)',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('Time units for recurrence of pledge payments.'),
      'add' => '2.1',
      'unique_name' => 'pledge_frequency_unit',
      'default' => 'month',
      'pseudoconstant' => [
        'option_group_name' => 'recur_frequency_units',
        'key_column' => 'name',
      ],
    ],
    'frequency_interval' => [
      'title' => ts('Pledge Frequency Interval'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('Number of time units for recurrence of pledge payments.'),
      'add' => '2.1',
      'unique_name' => 'pledge_frequency_interval',
      'default' => 1,
    ],
    'frequency_day' => [
      'title' => ts('Pledge day'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('Day in the period when the pledge payment is due e.g. 1st of month, 15th etc. Use this to set the scheduled dates for pledge payments.'),
      'add' => '2.1',
      'default' => 3,
    ],
    'installments' => [
      'title' => ts('Pledge Number of Installments'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('Total number of payments to be made.'),
      'add' => '2.1',
      'default' => 1,
      'usage' => [
        'export',
      ],
    ],
    'start_date' => [
      'title' => ts('Pledge Start Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'required' => TRUE,
      'description' => ts('The date the first scheduled pledge occurs.'),
      'add' => '2.1',
      'unique_name' => 'pledge_start_date',
      'unique_title' => 'Payments Start Date',
      'usage' => [
        'export',
      ],
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'create_date' => [
      'title' => ts('Pledge Made'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'required' => TRUE,
      'description' => ts('When this pledge record was created.'),
      'add' => '2.1',
      'unique_name' => 'pledge_create_date',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'acknowledge_date' => [
      'title' => ts('Pledge Acknowledged'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('When a pledge acknowledgement message was sent to the contributor.'),
      'add' => '2.1',
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'modified_date' => [
      'title' => ts('Pledge Modified Date'),
      'sql_type' => 'datetime',
      'input_type' => NULL,
      'readonly' => TRUE,
      'description' => ts('Last updated date for this pledge record.'),
      'add' => '2.1',
    ],
    'cancel_date' => [
      'title' => ts('Pledge Cancelled Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date this pledge was cancelled by contributor.'),
      'add' => '2.1',
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'end_date' => [
      'title' => ts('Pledge End Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date this pledge finished successfully (total pledge payments equal to or greater than pledged amount).'),
      'add' => '2.1',
      'unique_name' => 'pledge_end_date',
      'unique_title' => 'Payments Ended Date',
      'usage' => [
        'export',
      ],
      'input_attrs' => [
        'format_type' => 'activityDate',
      ],
    ],
    'max_reminders' => [
      'title' => ts('Maximum Number of Reminders'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'description' => ts('The maximum number of payment reminders to send for any given payment.'),
      'add' => '2.1',
      'default' => 1,
    ],
    'initial_reminder_day' => [
      'title' => ts('Initial Reminder Day'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Send initial reminder this many days prior to the payment due date.'),
      'add' => '2.1',
      'default' => 5,
    ],
    'additional_reminder_day' => [
      'title' => ts('Additional Reminder Days'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'description' => ts('Send additional reminder this many days after last one sent, up to maximum number of reminders.'),
      'add' => '2.1',
      'default' => 5,
    ],
    'status_id' => [
      'title' => ts('Pledge Status ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('Implicit foreign key to civicrm_option_values in the pledge_status option group.'),
      'add' => '2.1',
      'unique_name' => 'pledge_status_id',
      'usage' => [
        'import',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Status'),
      ],
      'pseudoconstant' => [
        'option_group_name' => 'pledge_status',
        'condition_provider' => ['CRM_Pledge_BAO_Pledge', 'alterStatus'],
      ],
    ],
    'is_test' => [
      'title' => ts('Test'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'unique_name' => 'pledge_is_test',
      'default' => FALSE,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'campaign_id' => [
      'title' => ts('Campaign ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('The campaign for which this pledge has been initiated.'),
      'add' => '3.4',
      'unique_name' => 'pledge_campaign_id',
      'component' => 'CiviCampaign',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Campaign'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_campaign',
        'key_column' => 'id',
        'label_column' => 'title',
        'prefetch' => 'disabled',
      ],
      'entity_reference' => [
        'entity' => 'Campaign',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
  ],
];
