<?php

return [
  'name' => 'Event',
  'table' => 'civicrm_event',
  'class' => 'CRM_Event_DAO_Event',
  'getInfo' => fn() => [
    'title' => ts('Event'),
    'title_plural' => ts('Events'),
    'description' => ts('Scheduled in-person or online events which contacts can register for and attend.'),
    'log' => TRUE,
    'add' => '1.7',
    'icon' => 'fa-calendar',
    'label_field' => 'title',
  ],
  'getPaths' => fn() => [
    'add' => 'civicrm/event/add?reset=1',
    'view' => 'civicrm/event/info?reset=1&id=[id]',
  ],
  'getIndices' => fn() => [
    'index_event_type_id' => [
      'fields' => [
        'event_type_id' => TRUE,
      ],
      'add' => '1.8',
    ],
    'index_participant_listing_id' => [
      'fields' => [
        'participant_listing_id' => TRUE,
      ],
      'add' => '2.0',
    ],
    'index_parent_event_id' => [
      'fields' => [
        'parent_event_id' => TRUE,
      ],
      'add' => '4.1',
    ],
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Event ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Event'),
      'add' => '1.7',
      'input_attrs' => [
        'label' => ts('ID'),
      ],
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'title' => [
      'title' => ts('Event Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Event Title (e.g. Fall Fundraiser Dinner)'),
      'add' => '1.7',
      'unique_name' => 'event_title',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Title'),
      ],
    ],
    'summary' => [
      'title' => ts('Event Summary'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Brief summary of event. Text and html allowed. Displayed on Event Registration form and can be used on other CMS pages which need an event summary.'),
      'add' => '1.7',
      'input_attrs' => [
        'label' => ts('Summary'),
        'rows' => 4,
        'cols' => 60,
      ],
    ],
    'description' => [
      'title' => ts('Event Description'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('Full description of event. Text and html allowed. Displayed on built-in Event Information screens.'),
      'add' => '1.7',
      'unique_name' => 'event_description',
      'input_attrs' => [
        'label' => ts('Description'),
        'rows' => 8,
        'cols' => 60,
      ],
    ],
    'event_type_id' => [
      'title' => ts('Event Type'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Event Type ID.Implicit FK to civicrm_option_value where option_group = event_type.'),
      'add' => '1.7',
      'unique_name' => 'event_type_id',
      'default' => 0,
      'input_attrs' => [
        'label' => ts('Event Type'),
      ],
      'pseudoconstant' => [
        'option_group_name' => 'event_type',
      ],
    ],
    'participant_listing_id' => [
      'title' => ts('Participant Listing'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Should we expose the participant list? Implicit FK to civicrm_option_value where option_group = participant_listing.'),
      'add' => '2.0',
      'unique_name' => 'participant_listing_id',
      'default' => NULL,
      'pseudoconstant' => [
        'option_group_name' => 'participant_listing',
      ],
    ],
    'is_public' => [
      'title' => ts('Is Event Public'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Public events will be included in the iCal feeds. Access to private event information may be limited using ACLs.'),
      'add' => '1.7',
      'default' => TRUE,
      'input_attrs' => [
        'label' => ts('Public'),
      ],
    ],
    'start_date' => [
      'title' => ts('Event Start Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time that event starts.'),
      'add' => '1.7',
      'unique_name' => 'event_start_date',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Start Date'),
        'format_type' => 'activityDateTime',
      ],
    ],
    'end_date' => [
      'title' => ts('Event End Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time that event ends. May be NULL if no defined end date/time'),
      'add' => '1.7',
      'unique_name' => 'event_end_date',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('End Date'),
        'format_type' => 'activityDateTime',
      ],
    ],
    'is_online_registration' => [
      'title' => ts('Is Online Registration'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('If TRUE, include registration link on Event Info page.'),
      'add' => '1.7',
      'default' => FALSE,
      'input_attrs' => [
        'label' => ts('Online Registration'),
      ],
    ],
    'registration_link_text' => [
      'title' => ts('Event Registration Link Text'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Text for link to Event Registration form which is displayed on Event Information screen when is_online_registration is true.'),
      'add' => '1.7',
    ],
    'registration_start_date' => [
      'title' => ts('Registration Start Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time that online registration starts.'),
      'add' => '1.8',
      'input_attrs' => [
        'format_type' => 'activityDateTime',
        'label' => ts('Registration Start Date'),
      ],
    ],
    'registration_end_date' => [
      'title' => ts('Registration End Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time that online registration ends.'),
      'add' => '1.8',
      'input_attrs' => [
        'format_type' => 'activityDateTime',
        'label' => ts('Registration End Date'),
      ],
    ],
    'max_participants' => [
      'title' => ts('Max Participants'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'description' => ts('Maximum number of registered participants to allow. After max is reached, a custom Event Full message is displayed. If NULL, allow unlimited number of participants.'),
      'add' => '1.7',
      'default' => NULL,
    ],
    'event_full_text' => [
      'title' => ts('Event Information'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Message to display on Event Information page and INSTEAD OF Event Registration form if maximum participants are signed up. Can include email address/info about getting on a waiting list, etc. Text and html allowed.'),
      'add' => '1.7',
      'input_attrs' => [
        'label' => ts('Event Full Message'),
        'rows' => 4,
        'cols' => 60,
      ],
    ],
    'is_monetary' => [
      'title' => ts('Is this a PAID event?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('If TRUE, one or more fee amounts must be set and a Payment Processor must be configured for Online Event Registration.'),
      'add' => '1.7',
      'default' => FALSE,
      'input_attrs' => [
        'label' => ts('Paid Event'),
      ],
    ],
    'financial_type_id' => [
      'title' => ts('Financial Type'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Financial type assigned to paid event registrations for this event. Required if is_monetary is true.'),
      'add' => '4.3',
      'default' => NULL,
      'pseudoconstant' => [
        'table' => 'civicrm_financial_type',
        'key_column' => 'id',
        'label_column' => 'label',
        'condition_provider' => ['CRM_Financial_BAO_FinancialType', 'alterIncomeFinancialTypes'],
      ],
    ],
    'payment_processor' => [
      'title' => ts('Payment Processor'),
      'sql_type' => 'varchar(128)',
      'input_type' => 'Select',
      'description' => ts('Payment Processors configured for this Event (if is_monetary is true)'),
      'add' => '1.8',
      'serialize' => CRM_Core_DAO::SERIALIZE_SEPARATOR_TRIMMED,
      'input_attrs' => [
        'label' => ts('Payment Processors'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_payment_processor',
        'key_column' => 'id',
        'label_column' => 'name',
      ],
    ],
    'is_map' => [
      'title' => ts('Map Enabled'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Include a map block on the Event Information page when geocode info is available and a mapping provider has been specified?'),
      'add' => '1.7',
      'default' => FALSE,
    ],
    'is_active' => [
      'title' => ts('Is Active'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Is this Event enabled or disabled/cancelled?'),
      'add' => '1.7',
      'default' => FALSE,
      'input_attrs' => [
        'label' => ts('Enabled'),
      ],
    ],
    'fee_label' => [
      'title' => ts('Fee Label'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'add' => '1.8',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'is_show_location' => [
      'title' => ts('Show Location'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('If TRUE, show event location.'),
      'add' => '1.7',
      'default' => TRUE,
    ],
    'loc_block_id' => [
      'title' => ts('Location Block ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to Location Block ID'),
      'add' => '2.0',
      'input_attrs' => [
        'label' => ts('Location Block'),
      ],
      'entity_reference' => [
        'entity' => 'LocBlock',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'default_role_id' => [
      'title' => ts('Default Role'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Participant role ID. Implicit FK to civicrm_option_value where option_group = participant_role.'),
      'add' => '2.0',
      'unique_name' => 'default_role_id',
      'default' => 1,
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'pseudoconstant' => [
        'option_group_name' => 'participant_role',
      ],
    ],
    'intro_text' => [
      'title' => ts('Introductory Message'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('Introductory message for Event Registration page. Text and html allowed. Displayed at the top of Event Registration form.'),
      'add' => '1.7',
      'input_attrs' => [
        'rows' => 6,
        'cols' => 50,
      ],
    ],
    'footer_text' => [
      'title' => ts('Footer Message'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('Footer message for Event Registration page. Text and html allowed. Displayed at the bottom of Event Registration form.'),
      'add' => '1.7',
      'input_attrs' => [
        'rows' => 6,
        'cols' => 50,
      ],
    ],
    'confirm_title' => [
      'title' => ts('Confirmation Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Title for Confirmation page.'),
      'add' => '1.7',
      'default' => NULL,
    ],
    'confirm_text' => [
      'title' => ts('Confirm Text'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('Introductory message for Event Registration page. Text and html allowed. Displayed at the top of Event Registration form.'),
      'add' => '1.7',
      'input_attrs' => [
        'rows' => 6,
        'cols' => 50,
      ],
    ],
    'confirm_footer_text' => [
      'title' => ts('Footer Text'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('Footer message for Event Registration page. Text and html allowed. Displayed at the bottom of Event Registration form.'),
      'add' => '1.7',
      'input_attrs' => [
        'rows' => 6,
        'cols' => 50,
      ],
    ],
    'is_email_confirm' => [
      'title' => ts('Is confirm email'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('If TRUE, confirmation is automatically emailed to contact on successful registration.'),
      'add' => '1.7',
      'default' => FALSE,
    ],
    'confirm_email_text' => [
      'title' => ts('Confirmation Email Text'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('text to include above standard event info on confirmation email. emails are text-only, so do not allow html for now'),
      'add' => '1.7',
      'input_attrs' => [
        'rows' => 4,
        'cols' => 50,
      ],
    ],
    'confirm_from_name' => [
      'title' => ts('Confirm From Name'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('FROM email name used for confirmation emails.'),
      'add' => '1.7',
    ],
    'confirm_from_email' => [
      'title' => ts('Confirm From Email'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('FROM email address used for confirmation emails.'),
      'add' => '1.7',
    ],
    'cc_confirm' => [
      'title' => ts('Cc Confirm'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('comma-separated list of email addresses to cc each time a confirmation is sent'),
      'add' => '1.7',
      'input_attrs' => [
        'label' => ts('CC Confirm'),
      ],
    ],
    'bcc_confirm' => [
      'title' => ts('Bcc Confirm'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('comma-separated list of email addresses to bcc each time a confirmation is sent'),
      'add' => '1.7',
      'input_attrs' => [
        'label' => ts('BCC Confirm'),
      ],
    ],
    'default_fee_id' => [
      'title' => ts('Default Fee ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('FK to civicrm_option_value.'),
      'add' => '1.7',
    ],
    'default_discount_fee_id' => [
      'title' => ts('Default Discount Fee ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('FK to civicrm_option_value.'),
      'add' => '1.7',
    ],
    'thankyou_title' => [
      'title' => ts('ThankYou Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Title for ThankYou page.'),
      'add' => '1.7',
      'default' => NULL,
    ],
    'thankyou_text' => [
      'title' => ts('ThankYou Text'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('ThankYou Text.'),
      'add' => '1.7',
      'input_attrs' => [
        'rows' => 6,
        'cols' => 50,
      ],
    ],
    'thankyou_footer_text' => [
      'title' => ts('Footer Text'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('Footer message.'),
      'add' => '1.7',
      'input_attrs' => [
        'rows' => 6,
        'cols' => 50,
      ],
    ],
    'is_pay_later' => [
      'title' => ts('Pay Later Allowed'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - allows the user to send payment directly to the org later'),
      'add' => '2.0',
      'default' => FALSE,
    ],
    'pay_later_text' => [
      'title' => ts('Pay Later Text'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('The text displayed to the user in the main form'),
      'add' => '2.0',
    ],
    'pay_later_receipt' => [
      'title' => ts('Pay Later Receipt Text'),
      'sql_type' => 'text',
      'input_type' => 'RichTextEditor',
      'localizable' => TRUE,
      'description' => ts('The receipt sent to the user instead of the normal receipt text'),
      'add' => '2.0',
    ],
    'is_partial_payment' => [
      'title' => ts('Partial Payments Enabled'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('is partial payment enabled for this event'),
      'add' => '4.3',
      'default' => FALSE,
    ],
    'initial_amount_label' => [
      'title' => ts('Initial Amount Label'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Initial amount label for partial payment'),
      'add' => '4.3',
    ],
    'initial_amount_help_text' => [
      'title' => ts('Initial Amount Help Text'),
      'sql_type' => 'text',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Initial amount help text for partial payment'),
      'add' => '4.3',
    ],
    'min_initial_amount' => [
      'title' => ts('Minimum Initial Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => 'Text',
      'description' => ts('Minimum initial amount for partial payment'),
      'add' => '4.3',
    ],
    'is_multiple_registrations' => [
      'title' => ts('Allow Multiple Registrations'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - allows the user to register multiple participants for event'),
      'add' => '2.1',
      'default' => FALSE,
    ],
    'max_additional_participants' => [
      'title' => ts('Maximum number of additional participants per registration'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Maximum number of additional participants that can be registered on a single booking'),
      'add' => '4.7',
      'default' => 0,
    ],
    'allow_same_participant_emails' => [
      'title' => ts('Does Event allow multiple registrations from same email address?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true - allows the user to register multiple registrations from same email address.'),
      'add' => '2.2',
      'default' => FALSE,
    ],
    'has_waitlist' => [
      'title' => ts('Waitlist Enabled'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Whether the event has waitlist support.'),
      'add' => '3.0',
      'default' => FALSE,
    ],
    'requires_approval' => [
      'title' => ts('Requires Approval'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Whether participants require approval before they can finish registering.'),
      'add' => '3.0',
      'default' => FALSE,
      'input_attrs' => [
        'label' => ts('Requires Approval'),
      ],
    ],
    'expiration_time' => [
      'title' => ts('Expiration Time'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'description' => ts('Expire pending but unconfirmed registrations after this many hours.'),
      'add' => '3.0',
      'input_attrs' => [
        'label' => ts('Expiration Time'),
      ],
    ],
    'allow_selfcancelxfer' => [
      'title' => ts('Allow Self-service Cancellation or Transfer'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Allow self service cancellation or transfer for event?'),
      'add' => '4.7',
      'default' => FALSE,
    ],
    'selfcancelxfer_time' => [
      'title' => ts('Self-service Cancellation or Transfer Time'),
      'sql_type' => 'int',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('Number of hours prior to event start date to allow self-service cancellation or transfer.'),
      'add' => '4.7',
      'default' => 0,
    ],
    'waitlist_text' => [
      'title' => ts('Waitlist Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Text to display when the event is full, but participants can signup for a waitlist.'),
      'add' => '3.0',
      'input_attrs' => [
        'rows' => 4,
        'cols' => 60,
        'label' => ts('Waitlist Text'),
      ],
    ],
    'approval_req_text' => [
      'title' => ts('Approval Req Text'),
      'sql_type' => 'text',
      'input_type' => 'TextArea',
      'localizable' => TRUE,
      'description' => ts('Text to display when the approval is required to complete registration for an event.'),
      'add' => '3.0',
      'input_attrs' => [
        'rows' => 4,
        'cols' => 60,
        'label' => ts('Approval Required Text'),
      ],
    ],
    'is_template' => [
      'title' => ts('Is an Event Template'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('whether the event has template'),
      'add' => '3.0',
      'default' => FALSE,
    ],
    'template_title' => [
      'title' => ts('Event Template Title'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'localizable' => TRUE,
      'description' => ts('Event Template Title'),
      'add' => '3.0',
      'unique_name' => 'template_title',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'created_id' => [
      'title' => ts('Created By Contact ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to civicrm_contact, who created this event'),
      'add' => '3.0',
      'input_attrs' => [
        'label' => ts('Created By'),
      ],
      'entity_reference' => [
        'entity' => 'Contact',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'created_date' => [
      'title' => ts('Event Created Date'),
      'sql_type' => 'datetime',
      'input_type' => 'Select Date',
      'description' => ts('Date and time that event was created.'),
      'add' => '3.0',
    ],
    'currency' => [
      'title' => ts('Currency'),
      'sql_type' => 'varchar(3)',
      'input_type' => 'Select',
      'description' => ts('3 character string, value from config setting or input via user.'),
      'add' => '3.3',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
      'input_attrs' => [
        'label' => ts('Currency'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_currency',
        'key_column' => 'name',
        'label_column' => 'full_name',
        'name_column' => 'name',
        'abbr_column' => 'symbol',
        'description_column' => 'IFNULL(CONCAT(name, " (", symbol, ")"), name)',
      ],
    ],
    'campaign_id' => [
      'title' => ts('Campaign ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('The campaign for which this event has been created.'),
      'add' => '3.4',
      'component' => 'CiviCampaign',
      'input_attrs' => [
        'label' => ts('Campaign'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_campaign',
        'key_column' => 'id',
        'label_column' => 'title',
        'prefetch' => 'disabled',
      ],
      'entity_reference' => [
        'entity' => 'Campaign',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'is_share' => [
      'title' => ts('Is shared through social media'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('Can people share the event through social media?'),
      'add' => '4.1',
      'default' => TRUE,
    ],
    'is_confirm_enabled' => [
      'title' => ts('Is the booking confirmation screen enabled?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('If FALSE, the event booking confirmation screen gets skipped'),
      'add' => '4.5',
      'default' => TRUE,
    ],
    'parent_event_id' => [
      'title' => ts('Parent Event ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('Implicit FK to civicrm_event: parent event'),
      'add' => '4.1',
      'default' => NULL,
    ],
    'slot_label_id' => [
      'title' => ts('Subevent Slot Label ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'deprecated' => TRUE,
      'description' => ts('Needs to be moved to Event cart extension. Subevent slot label. Implicit FK to civicrm_option_value where option_group = conference_slot.'),
      'add' => '4.1',
      'default' => NULL,
    ],
    'dedupe_rule_group_id' => [
      'title' => ts('Dedupe Rule ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('Rule to use when matching registrations for this event'),
      'add' => '4.5',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Dedupe Rule'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_dedupe_rule_group',
        'key_column' => 'id',
        'name_column' => 'name',
        'label_column' => 'title',
      ],
      'entity_reference' => [
        'entity' => 'DedupeRuleGroup',
        'key' => 'id',
      ],
    ],
    'is_billing_required' => [
      'title' => ts('Is billing block required'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('if true than billing block is required this event'),
      'add' => '4.6',
      'default' => FALSE,
    ],
    'is_show_calendar_links' => [
      'title' => ts('Are calendar links shown?'),
      'sql_type' => 'boolean',
      'input_type' => 'CheckBox',
      'required' => TRUE,
      'description' => ts('If true then calendar links are shown for this event.'),
      'add' => '5.68',
      'default' => TRUE,
    ],
  ],
];
