# CiviCRM 6.4.0

Released July 2, 2025;

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add CONTAINS One Of to API and SK
  ([27012](https://github.com/civicrm/civicrm-core/pull/27012))**

  Adds a "contains one of" and "not contains one of" to API4 and Searchkit.
  Makes it possible to select multiple values for "contains" and "not contains".

- **SearchKit - Add links between search display and import
  ([32759](https://github.com/civicrm/civicrm-core/pull/32759))**

  Improves user experience by adding links from batch import screen to "My
  Imports"/"All Imports" And vice versa.

- **SearchKit - Support > 1 condition per link
  ([32854](https://github.com/civicrm/civicrm-core/pull/32854) and
  [32874](https://github.com/civicrm/civicrm-core/pull/32874))**

  Makes it so one can setup more than one condition per link in searchkit.

- **SearchUI: new Find Activities search
  ([32862](https://github.com/civicrm/civicrm-core/pull/32862))**

  Adds a version of Find Activities to SearchUI.

- **SearchUI: add version of List Reports
  ([32863](https://github.com/civicrm/civicrm-core/pull/32863))**

  Adds a version of List Reports under Search > Experimental for sites using
  SearchUI.

- **SearchKit - Selectable mailing type
  ([32916](https://github.com/civicrm/civicrm-core/pull/32916))**

  With Mosaico installed, this gives the user a choice of which type of mailing
  they want (Mosaico or Traditional).

- **Add Group Type filter to Manage Groups
  ([32894](https://github.com/civicrm/civicrm-core/pull/32894))**

  Adds a Group Type filter to the Manage Groups page.

- **Add `QueueItem` api
  ([28488](https://github.com/civicrm/civicrm-core/pull/28488))**

  Adds a `QueueItem` entity to APIv4.

- **Riverlea: Improve contast of tag checkboxes
  ([32810](https://github.com/civicrm/civicrm-core/pull/32810))**

  Improves accessibility of checkboxes for sites using Riverlea.

- **Add static cache to Civi\Api4\Generic\AbstractEntity::getInfo() for
  performance ([32781](https://github.com/civicrm/civicrm-core/pull/32781))**

  Improves performance.

- **Afform - Add support for dynamic foreign key handling in EntityRef
  ([32868](https://github.com/civicrm/civicrm-core/pull/32868))**

  Enhances the EntityRef field to dynamically adjust foreign key entities
  (dfk_entities) based on a control field's value. Updated isDisabled logic for
  UX.

- **add settings meta for `navigation` cache code
  ([32893](https://github.com/civicrm/civicrm-core/pull/32893))**

  Adds meta data for the `navigation` cache.

### CiviContribute

- **Manage Premiums: remove the tiny thumbnail
  ([31082](https://github.com/civicrm/civicrm-core/pull/31082))**

  Minor improvements to the Manage Premium form, notably by removing the tiny
  thumbnail.

### CiviEvent

- **AdminUI version of Administer Badge Layout - Replaces PR#29588
  ([32839](https://github.com/civicrm/civicrm-core/pull/32839))**

  Adds an Searchkit/Afform version of "Administer Badge Layout" page for sites
  using AdminUI.

- **Better event registration message for future events
  ([32795](https://github.com/civicrm/civicrm-core/pull/32795))**

  Improves the messaging for future events where registration is not open.

### CiviMail

- **move civimail settings to extension; move core mailing settings to core
  Outbound Mail settings page
  ([32816](https://github.com/civicrm/civicrm-core/pull/32816))**

  Consolidates CiviMail Settings.

- **Add subject to SMS activity
  ([32888](https://github.com/civicrm/civicrm-core/pull/32888))**

  Adds a subject to SMS activities.

### CiviMember

- **AdminUI: Membership Status Rules
  ([32860](https://github.com/civicrm/civicrm-core/pull/32860),
  [32849](https://github.com/civicrm/civicrm-core/pull/32849) and
  [32898](https://github.com/civicrm/civicrm-core/pull/32898))**

  Adds a SearchKit/FormBuilder version of the Administer > CiviMember >
  Membership Status Rules for sites with AdminUI enabled.

### WordPress Integration

- **Add new WP CiviCRM setting option that allows for controlling whether new WP
  users will be automatically logged in when their user account is created
  ([344](https://github.com/civicrm/civicrm-wordpress/pull/344) and
  [32861](https://github.com/civicrm/civicrm-core/pull/32861))**

  Adds a new setting option in the WP CiviCRM settings screen which will allow
  the site to control whether or not the new WP user will be automatically
  logged in when their user account is created.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Number field input validation does not respect decimal separator setting
  ([dev/core#4154](https://lab.civicrm.org/dev/core/-/issues/4154):
  [32791](https://github.com/civicrm/civicrm-core/pull/32791))**

- **Help bubbles on system settings - misc give errors
  ([dev/core#5955](https://lab.civicrm.org/dev/core/-/issues/5955):
  [33018](https://github.com/civicrm/civicrm-core/pull/33018))**

- **RiverLea Regressions: as found in deduper extension: .panel-body and
  .btn-block issues
  ([33023](https://github.com/civicrm/civicrm-core/pull/33023))**

- **Drop down menus don't overflow Search Display tables with navtabs, making
  them only visible by scrolling
  ([dev/core#5948](https://lab.civicrm.org/dev/core/-/issues/5948):
  [33016](https://github.com/civicrm/civicrm-core/pull/33016))**

- **RiverLea regression fix: 'other' link on SearchKit admin hides icon select
  (RL#134) ([32975](https://github.com/civicrm/civicrm-core/pull/32975))**

- **RiverLea: fixes variable name typo for padding on new/edit contact
  ([32969](https://github.com/civicrm/civicrm-core/pull/32969))**

- **Revert "Riverlea - Reset details css for consistency"
  ([32959](https://github.com/civicrm/civicrm-core/pull/32959))**

- **RiverLea Regressions: Contact Summary inline edit issues, with some tidying
  ([32936](https://github.com/civicrm/civicrm-core/pull/32936))**

- **RiverLea regression: css input size modifiers oftenbeing over-ridden
  ([32942](https://github.com/civicrm/civicrm-core/pull/32942))**

- **Riverlea - Reset details css for consistency
  ([32902](https://github.com/civicrm/civicrm-core/pull/32902))**

- **Add a more specific custom data selector
  ([32801](https://github.com/civicrm/civicrm-core/pull/32801))**

- **Remove any existing ForeignKey before adding one
  ([32955](https://github.com/civicrm/civicrm-core/pull/32955))**

- **Rename multisite is_enabled setting
  ([32750](https://github.com/civicrm/civicrm-core/pull/32750))**

- **Only create table if not exists
  ([32953](https://github.com/civicrm/civicrm-core/pull/32953))**

- **SearchKit - Fix saving pager settings
  ([32858](https://github.com/civicrm/civicrm-core/pull/32858))**

- **SearchKit - Fix undefined variable 'requestId'
  ([33032](https://github.com/civicrm/civicrm-core/pull/33032))**

- **SearchKit - Inline-edit fixes
  ([32904](https://github.com/civicrm/civicrm-core/pull/32904))**

- **fix User afform entity meta for formbuilder
  ([32983](https://github.com/civicrm/civicrm-core/pull/32983))**

- **Fix comment, type hints
  ([32927](https://github.com/civicrm/civicrm-core/pull/32927))**

- **Use checkPermissions = FALSE for retrieving weight
  ([33009](https://github.com/civicrm/civicrm-core/pull/33009))**

- **AdminUI - use the correct ExtensionUtils class
  ([32896](https://github.com/civicrm/civicrm-core/pull/32896))**

- **move component extension settings to their extensions
  ([32815](https://github.com/civicrm/civicrm-core/pull/32815))**

- **SettingsBag - fix typo in hasExplicit, provide deprecated alias
  ([32895](https://github.com/civicrm/civicrm-core/pull/32895))**

- **Permit negative amounts to be treated as 'truthy' for the purposes of the
  boolean money filter
  ([32890](https://github.com/civicrm/civicrm-core/pull/32890))**

- **Update Preview template to match changes made in #30681 to fix the radio
  group role and the orphaned label in wave on custom field radio
  ([32910](https://github.com/civicrm/civicrm-core/pull/32910))**

- **Autocomplete - Fix more results after searching by ID  
  ([32864](https://github.com/civicrm/civicrm-core/pull/32864))**

  Fixes "no results" when autocomplete with numeric input.

- **Allow custom separators to pass through numeric rule
  ([32832](https://github.com/civicrm/civicrm-core/pull/32832))**

- **Select active not draft translation in API4 wrapper
  ([32828](https://github.com/civicrm/civicrm-core/pull/32828))**

- **api3 Setting - pass NULL instead of "current_domain" to SettingsMetadata
  ([30543](https://github.com/civicrm/civicrm-core/pull/30543))**

- **Riverlea: Set color of icon in contactname block same as the text
  ([32809](https://github.com/civicrm/civicrm-core/pull/32809))**

- **FormBuilder Website field does not validate for a properly formatted URL
  ([dev/core#5882](https://lab.civicrm.org/dev/core/-/issues/5882):
  [32784](https://github.com/civicrm/civicrm-core/pull/32784))**

- **Problem with quick search on job title, postal code and city.
  ([dev/coreE#5880](https://lab.civicrm.org/dev/core/-/issues/5880):
  [32773](https://github.com/civicrm/civicrm-core/pull/32773))**

- **Add some more variables to event online receipt deprecation warnings
  ([32757](https://github.com/civicrm/civicrm-core/pull/32757))**

- **SearchKit: "Show linebreaks" should work when copying HTML
  ([32701](https://github.com/civicrm/civicrm-core/pull/32701))**

- **Process existing membership instead of creating a new one when submitting
  contribution page in Invoice Payment mode
  ([32769](https://github.com/civicrm/civicrm-core/pull/32769))**

- **Avoid deprecation warning
  ([32869](https://github.com/civicrm/civicrm-core/pull/32869))**

- **CustomGroup - Fix mismatched css vs style attr on custom group form
  ([32681](https://github.com/civicrm/civicrm-core/pull/32681))**

- **Fix passing NULL to string function
  ([32876](https://github.com/civicrm/civicrm-core/pull/32876))**

- **fix warning in Setting::getFields when non-existent name filter is passed
  ([33060](https://github.com/civicrm/civicrm-core/pull/33060))**

- **Fix UserJob templates to load without optional keys
  ([33050](https://github.com/civicrm/civicrm-core/pull/33050))**

- **Fix format handling of state abbreviation
  ([32756](https://github.com/civicrm/civicrm-core/pull/32756))**

- **Call narrower function from event cart
  ([32754](https://github.com/civicrm/civicrm-core/pull/32754))**

- **Clarify that microformat is never passed to Contact::retrieve
  ([32740](https://github.com/civicrm/civicrm-core/pull/32740))**

- **Fix hard crash when adding PriceSetEntity entity_table to Afform as a filter
  ([32867](https://github.com/civicrm/civicrm-core/pull/32867))**

- **AfformAdmin - Fix missing Url field type
  ([32806](https://github.com/civicrm/civicrm-core/pull/32806))**

- **Api4 - Fix deleting files
  ([32733](https://github.com/civicrm/civicrm-core/pull/32733))**

- **fix undefined notice in CRM_Core_Controller
  ([32822](https://github.com/civicrm/civicrm-core/pull/32822))**

- **Fix undeclared property, add standard helpers to Profile Field edit form
  ([31012](https://github.com/civicrm/civicrm-core/pull/31012))**

- **Add type hint & fix place where it is mis-passed
  ([32749](https://github.com/civicrm/civicrm-core/pull/32749))**

- **Notice fix on apiv4
  ([32782](https://github.com/civicrm/civicrm-core/pull/32782))**

- **Type notice fix
  ([32793](https://github.com/civicrm/civicrm-core/pull/32793))**

- **Fix undeclared property to Profile Field edit form
  ([32841](https://github.com/civicrm/civicrm-core/pull/32841))**

- **Php8.x notice
  ([427](https://github.com/civicrm/civicrm-packages/pull/427))**

- **Use local variable for mapperFields
  ([32878](https://github.com/civicrm/civicrm-core/pull/32878))**

### CiviCase

- **PHP8 Fatal error when adding files on Case custom field
  ([dev/core#4749](https://lab.civicrm.org/dev/core/-/issues/4749):
  [32903](https://github.com/civicrm/civicrm-core/pull/32903) and
  [32905](https://github.com/civicrm/civicrm-core/pull/32905))**

### CiviContribute

- **Move tax term
  ([32829](https://github.com/civicrm/civicrm-core/pull/32829))**

  Makes the tax term admin setting in CiviContribute Component Settings always
  shown instead of conditional on "Enable Tax and Invoicing" being checked
  because it is used whether or not "Enable Tax and Invoicing" is checked.

- **Financial ACLs prevent adding payment processors (Civi 6.1+)
  ([dev/core#5851](https://lab.civicrm.org/dev/core/-/issues/5851):
  [32729](https://github.com/civicrm/civicrm-core/pull/32729))**

- **Fix Duplicate Transaction Creation Due To Invalid Amount Comparison
  ([32218](https://github.com/civicrm/civicrm-core/pull/32218))**

### CiviEvent

- **Assign tax term (eg. VAT) to Smarty on participant.view form
  ([32879](https://github.com/civicrm/civicrm-core/pull/32879))**

- **Tokens in URLs in event confirmations don't render
  ([dev/core#5676](https://lab.civicrm.org/dev/core/-/issues/5676):
  [32674](https://github.com/civicrm/civicrm-core/pull/32674))**

### CiviMail

- **Provide additional information to Mail class (original values)
  ([31842](https://github.com/civicrm/civicrm-core/pull/31842))**

- **Mailing draft or draft?
  ([dev/core#5936](https://lab.civicrm.org/dev/core/-/issues/5936):
  [32950](https://github.com/civicrm/civicrm-core/pull/32950))**

  Fixes duplicate draft statuses appearing in mailing search form.

- **Bounce Reasons are unreasonable truncated
  ([dev/core#5281](https://lab.civicrm.org/dev/core/-/issues/5281):
  [32913](https://github.com/civicrm/civicrm-core/pull/32913))**

  Increases the length of MailingEventBounce.bounce_reason field.

- **In the abstract method 'send' of the SMS provider, fix the typo
  ([32785](https://github.com/civicrm/civicrm-core/pull/32785))**

### Drupal Integration

- **fix phpoffice requiring dev stability for drupal 8 installs
  ([32932](https://github.com/civicrm/civicrm-core/pull/32932))**

- **fix style issue
  ([107](https://github.com/civicrm/civicrm-drupal-8/pull/107))**

### Standalone Integration

- **Standalone - more consistently prefer /civicrm/home to /civicrm/dashboard
  ([32824](https://github.com/civicrm/civicrm-core/pull/32824))**

- **direct standalone-frontend.tpl to standalone.tpl by default
  ([32820](https://github.com/civicrm/civicrm-core/pull/32820))**

- **Standalone: error $(...).notify is not a function on login page
  ([dev/core#5887](https://lab.civicrm.org/dev/core/-/issues/5887):
  [32786](https://github.com/civicrm/civicrm-core/pull/32786))**

- **Standalone page template - move crm-public to crm-container element to match
  other UFs ([32872](https://github.com/civicrm/civicrm-core/pull/32872))**

### WordPress Integration

- **Admin UI: Constructed links do not consider front end or back end in
  WordPress ([dev/core#5904](https://lab.civicrm.org/dev/core/-/issues/5904):
  [32857](https://github.com/civicrm/civicrm-core/pull/32857))**

- **WordPress backend url may be different than "wp-admin"  
  ([30792](https://github.com/civicrm/civicrm-core/pull/30792))**

  Ensures CiviCRM plays nicely when the WordPress backend url is different than
  "wp-admin".

## <a name="misc"></a>Miscellany

- **Add standard helpers to profile field form
  ([32842](https://github.com/civicrm/civicrm-core/pull/32842))**

- **Use Civi-statics instead of static
  ([32851](https://github.com/civicrm/civicrm-core/pull/32851))**

- **Use api to get phone & email, narrow getLocations call
  ([32738](https://github.com/civicrm/civicrm-core/pull/32738))**

- **Add bcmath to composer require
  ([32771](https://github.com/civicrm/civicrm-core/pull/32771))**

- **Update vcard function to accept a standard v4 address array
  ([32744](https://github.com/civicrm/civicrm-core/pull/32744))**

- **Why does composer.json contain `"include-path": ["vendor/tecnickcom"]`
  ([dev/core#2072](https://lab.civicrm.org/dev/core/-/issues/2072):
  [32900](https://github.com/civicrm/civicrm-core/pull/32900))**

- **Refactoring CRM_Utils_System::theme to split out $maintenance
  ([dev/core#5803](https://lab.civicrm.org/dev/core/-/issues/5803):
  [32429](https://github.com/civicrm/civicrm-core/pull/32429))**

- **Finish deprecating smarty location variable in event templates
  ([32742](https://github.com/civicrm/civicrm-core/pull/32742))**

- **Deprecate a couple of token functions not used in core
  ([32846](https://github.com/civicrm/civicrm-core/pull/32846))**

- **Deprecate CRM_Contact_Form_Task_LabelCommon
  ([32798](https://github.com/civicrm/civicrm-core/pull/32798))**

- **Simplify check on pan_truncation
  ([32833](https://github.com/civicrm/civicrm-core/pull/32833))**

- **AdminUI cleanup
  ([32843](https://github.com/civicrm/civicrm-core/pull/32843))**

- **Stop assigning legacy smarty variable event.participant_role
  ([32748](https://github.com/civicrm/civicrm-core/pull/32748))**

- **Simplify numeric check
  ([32823](https://github.com/civicrm/civicrm-core/pull/32823))**

- **Add New Contributor
  ([32855](https://github.com/civicrm/civicrm-core/pull/32855))**

- **Added my info to contributor-key.yml
  ([32873](https://github.com/civicrm/civicrm-core/pull/32873))**

- **Tidy up SearchEvent.tpl
  ([32772](https://github.com/civicrm/civicrm-core/pull/32772))**

- **Slight simplification of legacy code
  ([32747](https://github.com/civicrm/civicrm-core/pull/32747))**

- **Mailing code cleanup (minor)  
  ([32847](https://github.com/civicrm/civicrm-core/pull/32847))**

- **Extract & share function to augment missing fields
  ([32758](https://github.com/civicrm/civicrm-core/pull/32758))**

- **Add test to lock in contact import creating related membership & switch to
  using less code
  ([32764](https://github.com/civicrm/civicrm-core/pull/32764))**

- **Remove/deprecate addHtmlHead cruft
  ([32831](https://github.com/civicrm/civicrm-core/pull/32831))**

- **Remove getTokenDetails function noisily deprecated in 2022
  ([32880](https://github.com/civicrm/civicrm-core/pull/32880))**

- **Remove code deprecatd noisily in 2021
  ([32834](https://github.com/civicrm/civicrm-core/pull/32834))**

- **Remove code noisily deprecated in 2023
  ([32743](https://github.com/civicrm/civicrm-core/pull/32743))**

- **remove redundant CIVICRM_UF_HEAD
  ([343](https://github.com/civicrm/civicrm-wordpress/pull/343))**

- **remove redundant CIVICRM_UF_HEAD
  ([106](https://github.com/civicrm/civicrm-drupal-8/pull/106))**

- **remove redundant CIVICRM_UF_HEAD
  ([690](https://github.com/civicrm/civicrm-drupal/pull/690))**

- **Remove unnecessary code
  ([32739](https://github.com/civicrm/civicrm-core/pull/32739))**

- **Remove calculation of unused variable
  ([32746](https://github.com/civicrm/civicrm-core/pull/32746))**

- **[REF][PHP8.2] Declare properties for Petition Signature
  ([32848](https://github.com/civicrm/civicrm-core/pull/32848))**

- **[REF][PHP8.2] Declare properties CRM_Contact_Page_View_CustomData
  ([32808](https://github.com/civicrm/civicrm-core/pull/32808))**

- **REF: Slice off 4 lines
  ([32850](https://github.com/civicrm/civicrm-core/pull/32850))**

- **REF: ContributionPage: Replace direct access to _ccid with getter function
  ([32768](https://github.com/civicrm/civicrm-core/pull/32768))**

- **[REF] Add Getter function for formComponent protected var in ContribueDetail
  report ([30687](https://github.com/civicrm/civicrm-core/pull/30687))**

- **[REF] Update Composer.json PHP extension requirements to match the Install
  Guide ([32777](https://github.com/civicrm/civicrm-core/pull/32777))**

- **[REF] Set outer tr of a custom field row to be a radiogroup role for aria
  reasons to improve accessibility
  ([30681](https://github.com/civicrm/civicrm-core/pull/30681))**

- **[REF] Remove Foreign Key Constraints on cache tables
  ([30614](https://github.com/civicrm/civicrm-core/pull/30614))**

- **[REF] Fix accessibility issue with multiple form labels in Search Kit Pager
  ([30750](https://github.com/civicrm/civicrm-core/pull/30750))**

- **[REF] getContentTemplate - move if case into switch, carefully
  ([31114](https://github.com/civicrm/civicrm-core/pull/31114))**

- **[REF] Follow up to #32499 to followup to use standard frontend function
  ([32897](https://github.com/civicrm/civicrm-core/pull/32897))**

- **[REF] Migrate Upgrade step from Matt to 6.4 as 6.4 has just been set
  ([32753](https://github.com/civicrm/civicrm-core/pull/32753))**

- **NFC: Improve comments
  ([32767](https://github.com/civicrm/civicrm-core/pull/32767))**

- **[NFC] fix edge case in testFileHash
  ([32761](https://github.com/civicrm/civicrm-core/pull/32761))**

- **NFC: Fix further codestyle issues
  ([346](https://github.com/civicrm/civicrm-wordpress/pull/346))**

- **NFC: Fix codestyle
  ([345](https://github.com/civicrm/civicrm-wordpress/pull/345))**

- **[NFC] first pass at 6.4 release notes
  ([33062](https://github.com/civicrm/civicrm-core/pull/33062))**

- **[NFC] remove duplicate contributor
  ([33068](https://github.com/civicrm/civicrm-core/pull/33068))**

- **[NFC] fix standalone typo in comment
  ([32871](https://github.com/civicrm/civicrm-core/pull/32871))**

- **[NFC] Bring back testCaseReassignForCustomFiles removed in 32319
  ([32770](https://github.com/civicrm/civicrm-core/pull/32770))**

- **[NFC] dev/core#5854 - unit test for overlay popup clarifying what groups
  should appear in it
  ([32783](https://github.com/civicrm/civicrm-core/pull/32783))**

- **Separate auto_increment values for tests
  ([32264](https://github.com/civicrm/civicrm-core/pull/32264))**

- **Strict id tests2
  ([32883](https://github.com/civicrm/civicrm-core/pull/32883))**

- **CaseTest - fix hard coded custom file path
  ([32796](https://github.com/civicrm/civicrm-core/pull/32796))**

- **Add test for api4 Product.get options unserialize
  ([30446](https://github.com/civicrm/civicrm-core/pull/30446))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Benjamin W; BrightMinded Ltd - Bradley Taylor;
Christian Wach; CiviCRM - Coleman Watts, Tim Otten; Coop SymbioTIC - Mathieu
Lutfy, Samuel Vanhove; Dave D; Evita Wagner; Freeform Solutions -
Herb van den Dool; iXiam - Rubén Pineda; JMA Consulting - Monish Deb, Seamus
Lee; Lemniscus - Noah Miller; Makoa - Usha F. Matisson; Megaphone Technology
Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; NIAB - Stuart; Nicol
Wistreich; OPEN - dewy; PERORA SRL - Samuele Masetto; Reflexive
Communications - Sandor Semsey; Richard Baugh; Squiffle Consulting - Aidan
Saunders; Tadpole Collective - Kevin Cristiano; Wikimedia Foundation - Eileen
McNaughton, Elliott Eggleston

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Artful Robot - Rich Lott; Australian Greens - Andrew Cormick-Dockery; Benjamin
W; Christian Wach; CompuCorp - Shahrukh Sayyed; Coop SymbioTIC - mmyriam;
Francesc Bassas i Bullich;
Fuzion - Luke Stewart; JMA Consulting - Joe Murray; John Kingsnorth; RaulJMCD;
Systopia - Lena Jukna; Third Sector Design - William Mortada; Wildsight - Lars
Sander-Green
