# CiviCRM 5.69.0

Released January 3, 2024

- **[Synopsis](#synopsis)**
- **[Security advisories](#security)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add system check encouraging Smarty3
  ([28521](https://github.com/civicrm/civicrm-core/pull/28521))**

  Adds a system check encouraging Smarty3.

- **Afform: Support conditional logic
  ([24699](https://github.com/civicrm/civicrm-core/pull/24699))**

  Adds client-side support for conditional logic to hide fields and containers
  based on rules using and/or/not logic.

- **Afform - Add shortcuts to Edit Forms and related Searchs on Search Forms
  ([dev/core#4786](https://lab.civicrm.org/dev/core/-/issues/4786):
  [28206](https://github.com/civicrm/civicrm-core/pull/28206))**

  Adds shortcuts (for those with permission) to edit afforms and related
  searches on afform search forms.

- **Improve FormBuilder handling of non logged in flows
  ([dev/core#4232](https://lab.civicrm.org/dev/core/-/issues/4232):
  [27107](https://github.com/civicrm/civicrm-core/pull/27107))**

  Allows afforms that can save the data only as submission, manually
  processing of afform submissions and the ability to confirm submission via
  Email.

- **Add Afform field for input type `Url`
  ([28024](https://github.com/civicrm/civicrm-core/pull/28024))**

  Adds an Afform field input type for "Url".

- **Afform - ability to set fixed or now date defaults
  ([28014](https://github.com/civicrm/civicrm-core/pull/28014))**

  Adds the ability to set date defaults to fixed or now.

- **Afform - improve loading performance
  ([27783](https://github.com/civicrm/civicrm-core/pull/27783))**

  Improves performance when loading afforms.

- **Afform - improve display of error messages
  ([28021](https://github.com/civicrm/civicrm-core/pull/28021))**

  Improves the display of error messages on afforms.

- **APIv4 - Pass form values to autocomplete field
  ([28452](https://github.com/civicrm/civicrm-core/pull/28452))**

  Makes Afform APIv4 autocomplete field user selections available on the form.

- **Formbuilder: support rows and columns values for Note (textarea) custom
  field type ([28388](https://github.com/civicrm/civicrm-core/pull/28388))**

  Displaying a custom field of type Note in Form Builder now shows the textarea
  tag with rows and cols set to the custom field definition set by the admin for
  that field

- **ADMIN_UI: default checkbox
  ([dev/core#4734](https://lab.civicrm.org/dev/core/-/issues/4734):
  [28001](https://github.com/civicrm/civicrm-core/pull/28001))**

  Adds row checkboxes and the Actions menu for AdminUI screens. Standardises
  edit/disable/delete/etc actions in a menu instead of buttons.

- **Added Export Mapping search kit UI
  ([28509](https://github.com/civicrm/civicrm-core/pull/28509))**

  Moves the Import/Export mappings page to a search kit user interface.

- **Add searchkit and afform display
  ([28484](https://github.com/civicrm/civicrm-core/pull/28484) and
  [28472](https://github.com/civicrm/civicrm-core/pull/28472))**

  Moves the 'Headers Footers and Automated Messages' page to use a search
  kit/afform user interface.

- **Create Formbuilder page to view Queue status
  ([dev/core#4815](https://lab.civicrm.org/dev/core/-/issues/4815):
  [28348](https://github.com/civicrm/civicrm-core/pull/28348))**

  Adds a page powered by afform/searchkit to view queue status.

- **SearchUI - Updates to Label Format display
  ([28546](https://github.com/civicrm/civicrm-core/pull/28546),
  [28513](https://github.com/civicrm/civicrm-core/pull/28513) and
  [28545](https://github.com/civicrm/civicrm-core/pull/28545))**

  Switches the Label format screen to use a searchkit ui.

- **Add support for spreadsheet format in imports
  ([28495](https://github.com/civicrm/civicrm-core/pull/28495))**

  Adds support for spreadsheet formats ods and xlsx in imports.

- **make Mapping entity available on searchkit
  ([28508](https://github.com/civicrm/civicrm-core/pull/28508) and
  [28534](https://github.com/civicrm/civicrm-core/pull/28534))**

  Adds Mapping entity to SearchKit.

- **Adding PreferencesDate API
  ([28482](https://github.com/civicrm/civicrm-core/pull/28482))**

  Adds APIv4 and searchkit support for `PreferencesDate`.

- **Changed the URL path for DatePreference screen
  ([28500](https://github.com/civicrm/civicrm-core/pull/28500))**

  Changes the URL path for the DatePreference screen to play nicely with
  searchkit.

- **Added DatePreference admin UI
  ([28483](https://github.com/civicrm/civicrm-core/pull/28483))**

  Transitions Date Preference admin user interface to an afform/searchkit
  interface.

- **Adds an accessible accordion, applies to news-feed dashlet
  ([28415](https://github.com/civicrm/civicrm-core/pull/28415))**

  Adds an accessible accordion and starts the process of updating the user
  interface to use it by updating the news-feed dashlet.

- **Applies accessible accordion to SearchKit, adds fallbacks
  ([28441](https://github.com/civicrm/civicrm-core/pull/28441),
  [28449](https://github.com/civicrm/civicrm-core/pull/28449),
  [28606](https://github.com/civicrm/civicrm-core/pull/28606),
  [28781](https://github.com/civicrm/civicrm-core/pull/28781),
  [28541](https://github.com/civicrm/civicrm-core/pull/28541),
  [28421](https://github.com/civicrm/civicrm-core/pull/28421),
  [28665](https://github.com/civicrm/civicrm-core/pull/28665),
  [28661](https://github.com/civicrm/civicrm-core/pull/28661),
  [28430](https://github.com/civicrm/civicrm-core/pull/28430) and
  [28418](https://github.com/civicrm/civicrm-core/pull/28418))**

  User interface changes that makes the SearchKit accordions more accessible.

- **Add userEnteredText as generic workflow template smarty variable
  ([27162](https://github.com/civicrm/civicrm-core/pull/27162))**

  Makes userEnteredText a property across all WorkflowMessages - with it
  outputting the smarty variable user_text.

- **convert .aff.json to .aff.php and add ts()
  ([28499](https://github.com/civicrm/civicrm-core/pull/28499))**

  Makes afform file titles translatable.

- **SearchKit - Add inputMode setting to allow clauses to reference column
  values ([28112](https://github.com/civicrm/civicrm-core/pull/28112))**

  Adds more power to SearchKit by allowing clauses to reference fields.

- **APIv4 - Add GROUP_FIRST aggregate function
  ([28164](https://github.com/civicrm/civicrm-core/pull/28164))**

  Adds a useful new SQL function (GROUP_FIRST aggregate function) to APIv4, and
  exposes it to SearchKit.

- **SearchKit - Hide empty menus
  ([28454](https://github.com/civicrm/civicrm-core/pull/28454))**

  If a user doesn't have access to any actions, hides the actions menu.

- **Add CRM_Utils_CacheWrapper to all caches
  ([28428](https://github.com/civicrm/civicrm-core/pull/28428))**

  Wraps all caches and dispatches a 'civi.cache.clear' event when deleting items
  from the cache.

- **setup: Allow language selection regardless of whether languages are
  available ([28139](https://github.com/civicrm/civicrm-core/pull/28139),
  [28209](https://github.com/civicrm/civicrm-core/pull/28209) and
  [28179](https://github.com/civicrm/civicrm-core/pull/28179))**

  Allow language selection regardless of whether the files are downloaded.

- **Setup: able to download translation files automatically
  ([28061](https://github.com/civicrm/civicrm-core/pull/28061) and
  [28169](https://github.com/civicrm/civicrm-core/pull/28169))**

  Makes it so the CiviCRM setup utility downloads the translation files
  automatically, making the download of the l10n civicrm files an obsolete step,
  and adds a system check for multiple l10n dirs.

- **Update language download during install to use existing folder if present
  ([28425](https://github.com/civicrm/civicrm-core/pull/28425))**

  Use language folder if present instead of always downloading.

- **Log extension download errors
  ([28176](https://github.com/civicrm/civicrm-core/pull/28176))**

  Improves logs by logging extension download errors.

- **Include separator text in details send to log
  ([28034](https://github.com/civicrm/civicrm-core/pull/28034))**

  Improves logging by adding separator text for queue specific logs.

- **Add missing Zambia provinces
  ([28025](https://github.com/civicrm/civicrm-core/pull/28025))**

  Adds missing Zambia provinces.

- **Add system check for if people disabled default location type
  ([28330](https://github.com/civicrm/civicrm-core/pull/28330))**

  Disabling the default location type causes problems, this adds a system check
  to let the user know if it has been disabled.

- **Add suffix to sort name
  ([28393](https://github.com/civicrm/civicrm-core/pull/28393))**

  Adds suffix to default sort name configuration.

### CiviCase

- **Case activity filter causes performance headache for non-superusers
  ([dev/core#4822](https://lab.civicrm.org/dev/core/-/issues/4822):
  [28383](https://github.com/civicrm/civicrm-core/pull/28383))**

  Performance improvement when searching case activities.

### CiviContribute

- **Add Premium Product v4 api
  ([28261](https://github.com/civicrm/civicrm-core/pull/28261))**

  Adds `Premium` entity to APIv4.

- **Premiums metadata
  ([28544](https://github.com/civicrm/civicrm-core/pull/28544))**

  Set up Premiums metadata to make it compatible with searchkit conversion.

- **Blank out text version of online_contribution_receipt
  ([28268](https://github.com/civicrm/civicrm-core/pull/28268))**

  For new installs blank out text version of the `online_contribution_receipt`
  system workflow message template. When there is no text version of the
  `online_contribution_receipt` one will be generated based on the html version.

### CiviEvent

- **Add option to control display of calendar links.
  ([27768](https://github.com/civicrm/civicrm-core/pull/27768))**

  Adds an option to control whether calendar links are shown or not.

### CiviMail

- **Add filter on archived in Mailing Summary report
  ([28504](https://github.com/civicrm/civicrm-core/pull/28504))**

  Adds a archive filter to the Mailing Summary report.

- **APIv4 - Add is_draft field for mailings, fix test
  ([28019](https://github.com/civicrm/civicrm-core/pull/28019) and
  [28032](https://github.com/civicrm/civicrm-core/pull/28032))**

  Adds an `is_draft` field for mailings.

- **Schema - Add CiviMail field metadata
  ([28017](https://github.com/civicrm/civicrm-core/pull/28017))**

  Work toward converting the "Find Mailings" page to Searchkit/Afform.

### CiviMember

- **Add Membership log entity
  ([28220](https://github.com/civicrm/civicrm-core/pull/28220))**

  Adds a Membership log entity to APIv4.

- **Add is_new as a field on membership api or possibly via membership_status
  ([dev/core#4826](https://lab.civicrm.org/dev/core/-/issues/4826):
  [28395](https://github.com/civicrm/civicrm-core/pull/28395))**

  Adds `is_new` as a field on Membership status.

- **Blank out membership_online_receipt - text version
  ([28096](https://github.com/civicrm/civicrm-core/pull/28096))**

  Blanks out the membership_online_receipt (for new installs) and generates a
  text version based on the html version instead.

### CiviSMS

- **Add SMS provider API 4 Support
  ([28510](https://github.com/civicrm/civicrm-core/pull/28510))**

  Adds SMS provider support to APIv4.

### Standalone Implementation

- **Standalone language support (Work towards
  [dev/core#4411](https://lab.civicrm.org/dev/core/-/issues/4411):
  [28453](https://github.com/civicrm/civicrm-core/pull/28453) and
  [28469](https://github.com/civicrm/civicrm-core/pull/28469))**

  Adds the option to set a user language and if set that language is used for
  the UI when the user logs in. Freezes the element for inherit CMS Language
  under Administer > Localization > Languages, Currencies, Locations.

- **Roles - Define default taxonomy (for standalone deployments)
  ([dev/core#4466](https://lab.civicrm.org/dev/core/-/issues/4466):
  [28413](https://github.com/civicrm/civicrm-core/pull/28413))**

  Adds a staff role to the standalone CiviCRM. The staff role gets all
  permissions except for certain administer permissions.

- **Standalone - prevent users from deleting own user
  ([28532](https://github.com/civicrm/civicrm-core/pull/28532))**

  Prevents users from deleting their own user.

- **Standalone mobile support
  ([dev/core#4787](https://lab.civicrm.org/dev/core/-/issues/4787):
  [28213](https://github.com/civicrm/civicrm-core/pull/28213))**

  Adds viewport meta to improve mobile support for standalone sites.

- **Standalone - Improve administer user screen
  ([28528](https://github.com/civicrm/civicrm-core/pull/28528))**

  Improvements to the Standalone administer user screen.

- **Standalone - add name and delete en/disable actions for roles
  ([28420](https://github.com/civicrm/civicrm-core/pull/28420))**

  Adds the ability to enable/disable and delete roles.

- **standalone: implement User fields when_last_accessed and when_updated
  ([28440](https://github.com/civicrm/civicrm-core/pull/28440))**

  Implements fields to track when users last accessed the site and when they
  were last updated.

- **Standalone - give admin role super permission
  ([28447](https://github.com/civicrm/civicrm-core/pull/28447))**

  Makes admin role a super user.

- **Standalone - Add button to add user role Merging as it works and is a good
  improvement! Thanks @wmortada  
  ([28412](https://github.com/civicrm/civicrm-core/pull/28412))**

  Improvements to the the user role screen.

## WordPress Integration

- **Full update of the CiviCRM WP-CLI command
  ([309](https://github.com/civicrm/civicrm-wordpress/pull/309))**

  Updates the wp cli command options.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Upgrading to 5.66+ still has old copy of crm.menubar.js
  ([dev/core#4754](https://lab.civicrm.org/dev/core/-/issues/4754):
  [28033](https://github.com/civicrm/civicrm-core/pull/28033))**

- **When importing/updating persons, taking over the address of another contact
  does not work.
  ([dev/core#4447](https://lab.civicrm.org/dev/core/-/issues/4447):
  [28496](https://github.com/civicrm/civicrm-core/pull/28496))**

- **Cannot clear country and state/province in contact summary address
  ([dev/core#4702](https://lab.civicrm.org/dev/core/-/issues/4702):
  [28115](https://github.com/civicrm/civicrm-core/pull/28115))**

- **Angularjs.bootstrap behaves differently when opening in a popup on older
  CMSes ([dev/core#4811](https://lab.civicrm.org/dev/core/-/issues/4811):
  [28321](https://github.com/civicrm/civicrm-core/pull/28321))**

  Ensures that if a popup link requires AngularJS, it will always be available.

- **Fix duplicate instance of Spreadsheet import class
  ([28573](https://github.com/civicrm/civicrm-core/pull/28573))**

- **Add unique constraint on ufmatch user ID+domain ID
  ([28538](https://github.com/civicrm/civicrm-core/pull/28538))**

  Prevent creation of multiple ufmatch entries for different contacts to the
  same user account.

- **civi_case/civi_campaign extensions not configured properly on a fresh
  install ([dev/core#4867](https://lab.civicrm.org/dev/core/-/issues/4867):
  [28677](https://github.com/civicrm/civicrm-core/pull/28677))**

- **Update CustomField default_value to NULL instead of '' for floats
  ([28491](https://github.com/civicrm/civicrm-core/pull/28491))**

- **SearchKit: Don't assume a comparison value when none exists
  ([28515](https://github.com/civicrm/civicrm-core/pull/28515))**

- **AdminUI - Remove deleted contacts from group count
  ([28275](https://github.com/civicrm/civicrm-core/pull/28275))**

- **TemplateTrait - Fix references to CRM_Core_Exception
  ([28524](https://github.com/civicrm/civicrm-core/pull/28524))**

- **ensure exception class supports getErrorData
  ([28398](https://github.com/civicrm/civicrm-core/pull/28398))**

- **Use buttons instead of buttons, but only when not 4, but also if it's 4
  ([28470](https://github.com/civicrm/civicrm-core/pull/28470))**

- **Greenwich - Fix styling of summary collapsible element
  ([28448](https://github.com/civicrm/civicrm-core/pull/28448))**

  Fixes incorrect styling of summary/details collapsible element by Bootstrap3.

- **SearchKit: Many "group by" requests result in "illegal offset type" 500 error
  ([dev/core#4872](https://lab.civicrm.org/dev/core/-/issues/4872):
  [28741](https://github.com/civicrm/civicrm-core/pull/28741))**

- **SearchKit - Ensure result autocompleted by id is excluded from subsequent
  pages ([28460](https://github.com/civicrm/civicrm-core/pull/28460))**

- **Stop forcing apiVersion to 3 in setUp
  ([28404](https://github.com/civicrm/civicrm-core/pull/28404))**

- **set extension browser timeout to minimum of 10 seconds.
  ([27934](https://github.com/civicrm/civicrm-core/pull/27934))**

- **Fix notice, minor code cleanup with searching for a free text tag (advanced
  search) ([28377](https://github.com/civicrm/civicrm-core/pull/28377))**

- **Ensure onBehalfEmail always assigned to prevent notices
  ([28365](https://github.com/civicrm/civicrm-core/pull/28365))**

- **Check financial acls for product in extension
  ([28316](https://github.com/civicrm/civicrm-core/pull/28316))**

- **Use getCurrency() function for currency retrieval
  ([28289](https://github.com/civicrm/civicrm-core/pull/28289))**

- **PHP 8.x add getFromEmails() function, remove use of undeclared property
  ([28347](https://github.com/civicrm/civicrm-core/pull/28347))**

- **Simplify handling of discount_id in participant form postProcess
  ([28308](https://github.com/civicrm/civicrm-core/pull/28308))**

- **Fix Smarty3 notices on merge screen
  ([28334](https://github.com/civicrm/civicrm-core/pull/28334))**

- **Activity - Fix backwards logic in getViewOnlyActivityTypeIDs
  ([28331](https://github.com/civicrm/civicrm-core/pull/28331))**

- **BAO - Handle hypothetical userId in addSelectWhereClause
  ([28329](https://github.com/civicrm/civicrm-core/pull/28329))**

- **Fix tax when selection a contribution with the membership, test
  ([28317](https://github.com/civicrm/civicrm-core/pull/28317))**

- **Update send_receipt once actually sent, rather than predicting
  ([28166](https://github.com/civicrm/civicrm-core/pull/28166))**

- **Use function for getBillingID() rather than relying on form property
  ([28280](https://github.com/civicrm/civicrm-core/pull/28280))**

- **SearchBuilder - Add deprecation notice to users
  ([28274](https://github.com/civicrm/civicrm-core/pull/28274))**

  Adds a user-facing notice on the Search Builder page that Search Builder is
  deprecated in favor of SearchKit.

- **Use currentPath method to build QuickForm post URL
  ([28258](https://github.com/civicrm/civicrm-core/pull/28258))**

- **Replace ref to undeclared property with tax-inclusive lookup
  ([28267](https://github.com/civicrm/civicrm-core/pull/28267))**

- **Show membership info on pay later receipts
  ([28183](https://github.com/civicrm/civicrm-core/pull/28183))**

- **APIv4 - Add autocomplete & fix joins in CustomValue entities
  ([28132](https://github.com/civicrm/civicrm-core/pull/28132))**

  Fixes autocomplete widgets for entity types that do not have a label field
  declared (instead of an error, they will now at least allow a search by id).
  Adds the ability to autocomplete-search for CustomValue entities (aka
  multi-record custom field groups). Fixes a bug preventing joins in SearchKit
  from a multi-record custom entity back to the parent contact.

- **APIv4 - Fix autocomplete filters for multi-record custom groups
  ([28156](https://github.com/civicrm/civicrm-core/pull/28156))**

- **Clarify that the values passed are the submitted values, not altered values
  ([28076](https://github.com/civicrm/civicrm-core/pull/28076))**

- **Update Merger.php to compare strict type for checkboxes where a dummy-string
  is being used, to prevent this matching 'true'
  ([28160](https://github.com/civicrm/civicrm-core/pull/28160))**

- **Use token to avoid breaky-smarty3-maths
  ([28211](https://github.com/civicrm/civicrm-core/pull/28211))**

- **Replace math in template with variable, smarty3 support
  ([28144](https://github.com/civicrm/civicrm-core/pull/28144))**

- **Queue: hook_QueueTaskError missing some params
  ([dev/core#4774](https://lab.civicrm.org/dev/core/-/issues/4774):
  [28123](https://github.com/civicrm/civicrm-core/pull/28123))**

- **Revisit the default Scheduled Jobs. Adjust the frequency…
  ([28052](https://github.com/civicrm/civicrm-core/pull/28052))**

  Adjusts the defaults of several scheduled jobs to: adjust the frequency and
  remove comments that prevent the jobs from running correctly when enabled but
  not edited.

- **Fix online membership receipt to be form-independent
  ([28394](https://github.com/civicrm/civicrm-core/pull/28394))**

- **Fix notice regression on contact edit
  ([28611](https://github.com/civicrm/civicrm-core/pull/28611))**

- **Searchkit: Notes tab and relationships tab on contact crashing with
  DOMDocument::loadHTML(): Tag crm-search-display-table invalid in Entity
  ([dev/core#4855](https://lab.civicrm.org/dev/core/-/issues/4855):
  [28628](https://github.com/civicrm/civicrm-core/pull/28628))**

- **Viewing contact notes is broken
  ([dev/core#4852](https://lab.civicrm.org/dev/core/-/issues/4852):
  [28614](https://github.com/civicrm/civicrm-core/pull/28614))**

- **ContactSummary - Exclude deleted contacts from relationship tab
  ([28737](https://github.com/civicrm/civicrm-core/pull/28737))**

- **Follow up fixes on `maxFileSize`
  ([28074](https://github.com/civicrm/civicrm-core/pull/28074))**

- **Notice fix - specify emailMode is false when including SocialNetwork.tpl
  ([28359](https://github.com/civicrm/civicrm-core/pull/28359))**

- **[PHP 8.0] Curly brace syntax for accessing array elements
  ([dev/core#4758](https://lab.civicrm.org/dev/core/-/issues/4758):
  [28057](https://github.com/civicrm/civicrm-core/pull/28057))**

- **Recurring Activity: avoid validation if the fieldset is visible but not used
  ([28279](https://github.com/civicrm/civicrm-core/pull/28279))**

- **Fix activity view bug where an activity type id in the url overrides the
  actual activity type id
  ([27496](https://github.com/civicrm/civicrm-core/pull/27496))**

- **Switch to non deprecated functions for dompdf
  ([28059](https://github.com/civicrm/civicrm-core/pull/28059))**

- **Replace undefined property `_currentMemberships` with a define
  ([28222](https://github.com/civicrm/civicrm-core/pull/28222))**

- **Update 'Some kind of numbery-looky-printy thing.'  - ie
  `CRM_Utils_Number::formatUnitSize`
  ([28054](https://github.com/civicrm/civicrm-core/pull/28054))**

- **Do not suppress appropriate notices
  ([28576](https://github.com/civicrm/civicrm-core/pull/28576))**

- **Move form specific code out of shared function
  ([28344](https://github.com/civicrm/civicrm-core/pull/28344))**

- **Make undefined property local variable
  ([28345](https://github.com/civicrm/civicrm-core/pull/28345))**

- **Fix setting of misnamed property
  ([28172](https://github.com/civicrm/civicrm-core/pull/28172))**

- **Afform - Fix undefined index warning
  ([28081](https://github.com/civicrm/civicrm-core/pull/28081))**

- **Set cache folder for dompdf
  ([dev/core#4791 ](https://lab.civicrm.org/dev/core/-/issues/4791):
  [28257](https://github.com/civicrm/civicrm-core/pull/28257))**

- **Stop setting unused key
  ([28215](https://github.com/civicrm/civicrm-core/pull/28215))**

- **Add missing quote
  ([28088](https://github.com/civicrm/civicrm-core/pull/28088))**

- **Reverse variable check to fix notice
  ([28180](https://github.com/civicrm/civicrm-core/pull/28180))**

- **Notice fix
  ([28309](https://github.com/civicrm/civicrm-core/pull/28309))**

- **Fix notice on showCMS:
  ([28142](https://github.com/civicrm/civicrm-core/pull/28142))**

- **Fix recently-merged typo
  ([28288](https://github.com/civicrm/civicrm-core/pull/28288))**

- **Fix always present parameter
  ([28221](https://github.com/civicrm/civicrm-core/pull/28221))**

- **Fix typo in smarty compatibility class
  ([28791](https://github.com/civicrm/civicrm-core/pull/28791))**

- **Reduce smarty notices on civireport pages
  ([27985](https://github.com/civicrm/civicrm-core/pull/27985))**

- **Set correct financial type when creating membership using price set with
  single line item
  ([28319](https://github.com/civicrm/civicrm-core/pull/28319))**

- **Use local variable rather than undefined property to build array
  ([28281](https://github.com/civicrm/civicrm-core/pull/28281))**

- **php 8.2 undefined properties (Work towards
  [dev/core#4072](https://lab.civicrm.org/dev/core/-/issues/4072):
  [28044](https://github.com/civicrm/civicrm-core/pull/28044) and
  [28043](https://github.com/civicrm/civicrm-core/pull/28043))**

- **Php 8.x fix on variable
  ([28050](https://github.com/civicrm/civicrm-core/pull/28050))**

### CiviCase

- **When adding a follow up activity on an existing case activity with multiple
  assignees only one is saved
  ([dev/core#4770](https://lab.civicrm.org/dev/core/-/issues/4770):
  [28136](https://github.com/civicrm/civicrm-core/pull/28136))**

- **[php8] php warnings on case dashboard
  ([28117](https://github.com/civicrm/civicrm-core/pull/28117))**

- **CiviCase - Clear value before reusing editCaseRoleDialog
  ([28270](https://github.com/civicrm/civicrm-core/pull/28270))**

### CiviContribute

- **Online contribution flow - fix for php8.x, notices, smarty3
  (Work towards [dev/core#4798](https://lab.civicrm.org/dev/core/-/issues/4798):
  [28271](https://github.com/civicrm/civicrm-core/pull/28271) and
  [28276](https://github.com/civicrm/civicrm-core/pull/28276))**

  Contribution flow cleanup.

- **Price field and value weights not respected in 5.68
  ([dev/core#4880](https://lab.civicrm.org/dev/core/-/issues/4880):
  [28842](https://github.com/civicrm/civicrm-core/pull/28842))**

- **getNonDeductibleAmountFromPriceSet should take into account the financial
  type of the price field option (Work towards
  [dev/core#3083](https://lab.civicrm.org/dev/core/-/issues/3083):
  [28487](https://github.com/civicrm/civicrm-core/pull/28487))**

  Adds a warning about price fields where non_deductible amount potentially
  misconfigured.

- **Update Payment or receipt notification template
  ([28405](https://github.com/civicrm/civicrm-core/pull/28405))**

  Fixes notices.

- **Address payment processor notice in thankyou.tpl
  ([28696](https://github.com/civicrm/civicrm-core/pull/28696))**

- **Fix some notices on the Contribution ThankYou page
  ([28695](https://github.com/civicrm/civicrm-core/pull/28695))**

- **Fix amount not getting passed through in simple contribution flow
  ([28658](https://github.com/civicrm/civicrm-core/pull/28658))**

- **Check tax is present in online contribution page receipt
  ([28138](https://github.com/civicrm/civicrm-core/pull/28138))**

- **Tax amount on 'other amount field' - not being added
  ([dev/core#4806](https://lab.civicrm.org/dev/core/-/issues/4806):
  [28294](https://github.com/civicrm/civicrm-core/pull/28294))**

- **Thank you page notice - ensure friendText & linkText is assigned
  ([28358](https://github.com/civicrm/civicrm-core/pull/28358))**

- **Add notice fix for Confirm & thank you pages
  ([28362](https://github.com/civicrm/civicrm-core/pull/28362))**

- **[LineItem cleanup] Standardise a couple of calls to get values from the line
  items ([28264](https://github.com/civicrm/civicrm-core/pull/28264))**

- **[LineItem cleanup] Clean up & clarify code splitting line items in
  Contribution page membership flow
  ([28266](https://github.com/civicrm/civicrm-core/pull/28266))**

- **Reduce passing of `lineItems`
  ([28234](https://github.com/civicrm/civicrm-core/pull/28234))**

- **Auto renew options for membership types are not saving for a contribution
  page ([dev/core#3994](https://lab.civicrm.org/dev/core/-/issues/3994):
  [28387](https://github.com/civicrm/civicrm-core/pull/28387))**

- **Authorize.net webhooks fail, because processor expects Integer for
  x_invoice_num, while some have 20-character alphanumeric
  ([dev/core#4833](https://lab.civicrm.org/dev/core/-/issues/4833):
  [28474](https://github.com/civicrm/civicrm-core/pull/28474) and
  [28575](https://github.com/civicrm/civicrm-core/pull/28575))**

- **"Amount before tax" is wrong on online contribution receipt
  ([dev/financial#206](https://lab.civicrm.org/dev/financial/-/issues/206):
  [28008](https://github.com/civicrm/civicrm-core/pull/28008))**

- **Clean up smarty notices on Contribution View (when not in pop-up mode)
  ([28006](https://github.com/civicrm/civicrm-core/pull/28006))**

- **Use `supportsNoReturn()` instead of contributeMode check
  ([28060](https://github.com/civicrm/civicrm-core/pull/28060))**

- **Declare property from paypal express as public
  ([28227](https://github.com/civicrm/civicrm-core/pull/28227))**

- **Manage Contribution Pages: Open Live/Test page in new tab like old screen
  ([28173](https://github.com/civicrm/civicrm-core/pull/28173))**

- **Use payment create rather than transitionComponents
  ([26227](https://github.com/civicrm/civicrm-core/pull/26227))**

- **Pass year to mktime as int in CRM_Contribution_Form_ContributionCharts
 ([28013](https://github.com/civicrm/civicrm-core/pull/28013))**

- **Main contribution page - amounts entered with money formatting that is
  non-English are truncated
  ([dev/core#4802](https://lab.civicrm.org/dev/core/-/issues/4802):
  [28306](https://github.com/civicrm/civicrm-core/pull/28306))**

- **Add some assigns to prevent notices on Confirm
  ([28295](https://github.com/civicrm/civicrm-core/pull/28295))**

- **Extend line item notice fix from Confirm to Thank you page
  ([28252](https://github.com/civicrm/civicrm-core/pull/28252))**

- **Fix notice on is_quick_config - Main contribution page
  ([28095](https://github.com/civicrm/civicrm-core/pull/28095))**

- **Fix notice on payment processor object
  ([28141](https://github.com/civicrm/civicrm-core/pull/28141))**

- **Unshare toxic function `getContributionParams()`
  ([28254](https://github.com/civicrm/civicrm-core/pull/28254))**

- **Unshared toxic function `getNonDeductibleAmount()`
  ([28253](https://github.com/civicrm/civicrm-core/pull/28253))**

- **Fix notice on intro_text when none configured for the page
  ([28098](https://github.com/civicrm/civicrm-core/pull/28098))**

- **fix error on confirm page when using on-behalf-of
  ([28382](https://github.com/civicrm/civicrm-core/pull/28382))**

- **Notice fix on payment block
  ([28196](https://github.com/civicrm/civicrm-core/pull/28196))**

- **PHp8.x notice fix - remove use of legacy paymentObject
  ([28011](https://github.com/civicrm/civicrm-core/pull/28011))**

- **Fix fatal adding price set on contribution page
  ([28357](https://github.com/civicrm/civicrm-core/pull/28357))**

- **Fix a whole lot of conditional assignments on confirm & thank you pages
  ([28364](https://github.com/civicrm/civicrm-core/pull/28364))**

- **Fix notices on credit_card & bank number on Confirm & ThankYou
  ([28370](https://github.com/civicrm/civicrm-core/pull/28370))**

- **Fix notices on manage premiums page
  ([28250](https://github.com/civicrm/civicrm-core/pull/28250))**

- **Fix notices on premiums across all 3 pages
  ([28320](https://github.com/civicrm/civicrm-core/pull/28320))**

- **Ensure onBehalfProfile assigned
  ([28367](https://github.com/civicrm/civicrm-core/pull/28367))**

- **Fix Main Contribution form to identify money fields
  ([28300](https://github.com/civicrm/civicrm-core/pull/28300))**

- **Fix getTaxDetails notices on Confirm page
  ([28256](https://github.com/civicrm/civicrm-core/pull/28256))**

- **[Premiums] Fix access to undeclared property, remove unreachable code
  ([28238](https://github.com/civicrm/civicrm-core/pull/28238))**

- **Fix notice on unassigned tax
  ([28296](https://github.com/civicrm/civicrm-core/pull/28296))**

- **Cleanup notices around line Item display on Contribution Confirm Page
  ([28205](https://github.com/civicrm/civicrm-core/pull/28205))**

- **Sample data fixes for contribution pages
  ([28497](https://github.com/civicrm/civicrm-core/pull/28497))**

- **Replace last tpl uses of `contributeMode`
  ([28065](https://github.com/civicrm/civicrm-core/pull/28065))**

- **Replace use of contributeMode with alternatives
  ([28045](https://github.com/civicrm/civicrm-core/pull/28045))**

- **don't warn users about invalid financial types on unused price sets
  ([28322](https://github.com/civicrm/civicrm-core/pull/28322))**

- **Make financialacls require civi-contribute
  ([28318](https://github.com/civicrm/civicrm-core/pull/28318))**

- **Clarify which line items are passed in` processSecondaryMembership`
  ([28233](https://github.com/civicrm/civicrm-core/pull/28233))**

### CiviEvent

- **Add getParticipantID() to register
  ([28402](https://github.com/civicrm/civicrm-core/pull/28402))**

- **Updated fix for badge layouts
  ([28080](https://github.com/civicrm/civicrm-core/pull/28080))**

- **Fix eventcart to not interact with _tpl_vars directly
  ([28335](https://github.com/civicrm/civicrm-core/pull/28335))**

- **Get currency from the event for backoffice participant form
  ([28350](https://github.com/civicrm/civicrm-core/pull/28350))**

### CiviMail

- **Default mailing footer component incorrectly describes opt-out action as
  unsubscribe ([28053](https://github.com/civicrm/civicrm-core/pull/28053))**

- **Cancel button on the "unsubscribe mailing" form doesn't work as expected.
  ([dev/core#4796](https://lab.civicrm.org/dev/core/-/issues/4796):
  [28301](https://github.com/civicrm/civicrm-core/pull/28301))**

- **Fix ID retrieval for MailingComponent edit page
  ([28526](https://github.com/civicrm/civicrm-core/pull/28526))**

### CiviMember

- **Fix handling of auto renew memberships where frequency_interval > 1
  ([dev/core#3810](https://lab.civicrm.org/dev/core/-/issues/3810) and
  [dev/core#3339](https://lab.civicrm.org/dev/core/-/issues/3339):
  [28718](https://github.com/civicrm/civicrm-core/pull/28718)**

- **Recurring membership term is incorrect when using price sets
  ([dev/core#3344](https://lab.civicrm.org/dev/core/-/issues/3344):
  [28694](https://github.com/civicrm/civicrm-core/pull/28694))**

- **In membership detail report the join date field has a different output date
  format than the other date fields
  ([dev/core#3202](https://lab.civicrm.org/dev/core/-/issues/3202):
  [28089](https://github.com/civicrm/civicrm-core/pull/28089))**

- **Notice fix in membership_online_receipt
  ([28462](https://github.com/civicrm/civicrm-core/pull/28462))**

- **Use apiv4 rather than V3 for cached membershipTypes retrieval
  ([28386](https://github.com/civicrm/civicrm-core/pull/28386))**

- **Fix notices on new membership
  ([28434](https://github.com/civicrm/civicrm-core/pull/28434))**

- **Fix notices on view membership
  ([28435](https://github.com/civicrm/civicrm-core/pull/28435))**

- **Online membership receipt simplification
  ([28240](https://github.com/civicrm/civicrm-core/pull/28240))**

- **Align online membership receipt with other templates for line items, tax
  ([28181](https://github.com/civicrm/civicrm-core/pull/28181))**

- **Fix membership online preview to display subject (using token)
  ([28174](https://github.com/civicrm/civicrm-core/pull/28174))**

- **Reformat whitespace in online membership receipt
  ([28177](https://github.com/civicrm/civicrm-core/pull/28177))**

- **Declare _groupTree on MembershipRenewal form
  ([28066](https://github.com/civicrm/civicrm-core/pull/28066))**

- **Use getSubmittedValues() rather than ad-hoc money 'cleaning' on
  membershipType form
  ([28389](https://github.com/civicrm/civicrm-core/pull/28389))**

- **Unconditionally assign membership variables to fix notices on thankYou page
  ([28366](https://github.com/civicrm/civicrm-core/pull/28366))**

- **Fix notice on membership online main page
  ([28285](https://github.com/civicrm/civicrm-core/pull/28285))**

### Drupal Integration

- **CV crashes if LoginSecurity extension is enabled on Drupal8/9/10
  ([dev/core#4756](https://lab.civicrm.org/dev/core/-/issues/4756):
  [28037](https://github.com/civicrm/civicrm-core/pull/28037))**

### Joomla Integration

- **unable to authenticate in Joomla using Authx
  ([dev/core#4772](https://lab.civicrm.org/dev/core/-/issues/4772):
  [28119](https://github.com/civicrm/civicrm-core/pull/28119))**

- **Add Joomla user to group when created from civi profile
  ([27459](https://github.com/civicrm/civicrm-core/pull/27459))**

### Standalone Implementation

- **Epic: Re-implement CiviCRM Standalone (CMS-less CiviCRM) (Work towards
  [dev/core#2998](https://lab.civicrm.org/dev/core/-/issues/2998):
  [28407](https://github.com/civicrm/civicrm-core/pull/28407) and
  [28439](https://github.com/civicrm/civicrm-core/pull/28439))**

  Fixes an issue for standalone implementations where getUserIDFromUsername()
  was throwing an exception when fetching unknown users, rather than returning
  NULL. Also fixes JWT cookie test for standalone implementations.

- **Standalone timezone support
  ([dev/core#4410](https://lab.civicrm.org/dev/core/-/issues/4410):
  [28468](https://github.com/civicrm/civicrm-core/pull/28468))**

- **Standalone: civicrm/user path conflicts with existing path to user dashboard
  ([dev/core#4697](https://lab.civicrm.org/dev/core/-/issues/4697):
  [28343](https://github.com/civicrm/civicrm-core/pull/28343))**

- **Standalone: language change does not stick
  ([dev/core#4425](https://lab.civicrm.org/dev/core/-/issues/4425):
  [27292](https://github.com/civicrm/civicrm-core/pull/27292))**

- **Standalone: clean up styling on login/reset password
  ([28471](https://github.com/civicrm/civicrm-core/pull/28471))**

- **standaloneusers - Fix tokens+docblocks for "Password reset" email  
  ([28525](https://github.com/civicrm/civicrm-core/pull/28525))**

- **fix standalone permission for civimail subscribe pages
  ([28455](https://github.com/civicrm/civicrm-core/pull/28455))**

- **Fix confusing login screen on standalone + pretty up
  ([28424](https://github.com/civicrm/civicrm-core/pull/28424))**

- **Standalone - bootstrap script fixes
  ([28427](https://github.com/civicrm/civicrm-core/pull/28427))**

- **Standalone - Make active field required and labelled enabled
  ([28478](https://github.com/civicrm/civicrm-core/pull/28478))**

- **Standalone - remove role from users on deletion
  ([28429](https://github.com/civicrm/civicrm-core/pull/28429))**

- **Standalone - set default value to active when adding new user role
  ([28426](https://github.com/civicrm/civicrm-core/pull/28426))**

- **Standalone absolute paths
  ([28436](https://github.com/civicrm/civicrm-core/pull/28436))**

- **Standalone - Protect admin and everyone roles
  ([28451](https://github.com/civicrm/civicrm-core/pull/28451))**

### WordPress Integration

- **Attempting to create a pretty URL on a subpage results in non-pretty URL
  ([dev/wordpress#144](https://lab.civicrm.org/dev/wordpress/-/issues/144):
  [310](https://github.com/civicrm/civicrm-wordpress/pull/310))**

- **update the phpunit xml definition
  ([311](https://github.com/civicrm/civicrm-wordpress/pull/311))**

## <a name="misc"></a>Miscellany

- **Update Firebase JWT to version 6.x
  ([28055](https://github.com/civicrm/civicrm-core/pull/28055))**

- **Update Guzzle to 7.6.1 for Drupal 7/Backdrop/WordPress/Joomla
  ([28000](https://github.com/civicrm/civicrm-core/pull/28000))**

- **Deploy Package updates for DomPDF and PHP SVG Lib
  ([28643](https://github.com/civicrm/civicrm-core/pull/28643))**

- **set-version.php - Autocommit changes for version.json
  ([28622](https://github.com/civicrm/civicrm-core/pull/28622))**

- **Deprecate passing `billingID`to `mapParams`
  ([28310](https://github.com/civicrm/civicrm-core/pull/28310))**

- **Smarty3 Mark sectionTotals smarty function deprecated
  ([27777](https://github.com/civicrm/civicrm-core/pull/27777))**

- **Consolidate source text determination
  ([28047](https://github.com/civicrm/civicrm-core/pull/28047))**

- **Go to bed without supper 🥪🚫
  ([28340](https://github.com/civicrm/civicrm-core/pull/28340))**

- **Extract code that defines the renewal membership
  ([28287](https://github.com/civicrm/civicrm-core/pull/28287))**

- **[php8] undeclared property action and id in Page
  ([28314](https://github.com/civicrm/civicrm-core/pull/28314))**

- **Replace a few sub_str with str_contains
  ([28262](https://github.com/civicrm/civicrm-core/pull/28262))**

- **Use form property rather than passing mode
  ([28307](https://github.com/civicrm/civicrm-core/pull/28307))**

- **Simplify use of word 'Register'
  ([28046](https://github.com/civicrm/civicrm-core/pull/28046))**

- **Add helper functions to contribution page
  ([28228](https://github.com/civicrm/civicrm-core/pull/28228))**

- **Add warnings to processAmount
  ([28463](https://github.com/civicrm/civicrm-core/pull/28463))**

- **Update comment todos to referred to preferred method
  ([28324](https://github.com/civicrm/civicrm-core/pull/28324))**

- **Copy buildPremiumsBlock back to contribution page base
  ([28315](https://github.com/civicrm/civicrm-core/pull/28315))**

- **Stop using & deprectate `getSalesTaxTerm`
  ([28459](https://github.com/civicrm/civicrm-core/pull/28459))**

- **Pass contact id to sendmail function
  ([28229](https://github.com/civicrm/civicrm-core/pull/28229))**

- **Minor consolidation on `isTest()`
  ([28284](https://github.com/civicrm/civicrm-core/pull/28284))**

- **Clarify doRefund() signature
  ([28490](https://github.com/civicrm/civicrm-core/pull/28490))**

- **Add deprecation to transition components
  ([28485](https://github.com/civicrm/civicrm-core/pull/28485))**

- **Partial standardisation of MembershipType::Add
  ([28489](https://github.com/civicrm/civicrm-core/pull/28489))**

- **Consolidate invoice determination
  ([28493](https://github.com/civicrm/civicrm-core/pull/28493))**

- **Cleanup return on processContact
  ([28494](https://github.com/civicrm/civicrm-core/pull/28494))**

- **Clean up parameters in add payment form
  ([28479](https://github.com/civicrm/civicrm-core/pull/28479))**

- **Clean up `getMainContributionAmount()` function
  ([28292](https://github.com/civicrm/civicrm-core/pull/28292))**

- **Move getAmountLevel() to Order class
  ([28312](https://github.com/civicrm/civicrm-core/pull/28312))**

- **Superficial cleanup in Contribution Thank You form
  ([28269](https://github.com/civicrm/civicrm-core/pull/28269))**

- **Fix UFGroup add to call writeRecord
  ([28552](https://github.com/civicrm/civicrm-core/pull/28552))**

- **Copy functions back from metadata trait to only caller
  ([28555](https://github.com/civicrm/civicrm-core/pull/28555))**

- **Clean up contributionParams - backoffice participant form
  ([28070](https://github.com/civicrm/civicrm-core/pull/28070))**

- **CRM_Core_CodeGen_Schema: fix generated comments and whitespace
  ([28363](https://github.com/civicrm/civicrm-core/pull/28363))**

- **Simplify if
  ([28093](https://github.com/civicrm/civicrm-core/pull/28093))**

- **Further cleanup on previously shared participant form code
  ([28030](https://github.com/civicrm/civicrm-core/pull/28030))**

- **Follow up cleanup on multiple participant form edit
  ([28007](https://github.com/civicrm/civicrm-core/pull/28007))**

- **Fix docblock for loadUser()
  ([28563](https://github.com/civicrm/civicrm-core/pull/28563))**

- **Cleanup SQL in xml/templates/civicrm_state_province.tpl
  ([28041](https://github.com/civicrm/civicrm-core/pull/28041))**

- **Civi grant cleanup
  ([28438](https://github.com/civicrm/civicrm-core/pull/28438))**

- **Superficial cleanup
  ([28385](https://github.com/civicrm/civicrm-core/pull/28385))**

- **contributor_key.yml: add civiservice.de to four users, remove one duplicate
  ([28390](https://github.com/civicrm/civicrm-core/pull/28390))**

- **Page Templates - Remove unused `$localTasks` (`localNav.tpl`)
  ([28155](https://github.com/civicrm/civicrm-core/pull/28155))**

- **Finally remove `dataArray` , some notice fixes
  ([28184](https://github.com/civicrm/civicrm-core/pull/28184))**

- **Remove never-used variables
  ([28009](https://github.com/civicrm/civicrm-core/pull/28009))**

- **Remove extraneous space, breaks smarty3
  ([28100](https://github.com/civicrm/civicrm-core/pull/28100))**

- **Remove karama-phantomjs-launcher as we now use chrome browser for karma
  tests ([28056](https://github.com/civicrm/civicrm-core/pull/28056))**

- **Remove registered_by_id as not set in this flow
  ([28063](https://github.com/civicrm/civicrm-core/pull/28063))**

- **Remove more traces of the old 'contribution_invoice_settings'
  ([27955](https://github.com/civicrm/civicrm-core/pull/27955))**

- **Remove unused property from previously shared code
  ([28049](https://github.com/civicrm/civicrm-core/pull/28049))**

- **Remove references to not-set form _values array property 'event' from
  previously shared code
  ([28048](https://github.com/civicrm/civicrm-core/pull/28048))**

- **Remove unused property from previously shared code `_membershipTypeValues`
  ([28224](https://github.com/civicrm/civicrm-core/pull/28224))**

- **Remove unnecessary pass-by-reference
  ([28337](https://github.com/civicrm/civicrm-core/pull/28337))**

- **Remove code cruft which is now ignored
  ([28298](https://github.com/civicrm/civicrm-core/pull/28298))**

- **Remove assignments for template that are not needed for updated template
  ([28232](https://github.com/civicrm/civicrm-core/pull/28232))**

- **Remove assignment of now-unused membership_assign variable
  ([28208](https://github.com/civicrm/civicrm-core/pull/28208))**

- **Remove extraneous set from previously shared code
  ([28167](https://github.com/civicrm/civicrm-core/pull/28167))**

- **Remove last references to `_contributeMode`
  ([28140](https://github.com/civicrm/civicrm-core/pull/28140))**

- **Remove unused _tempClause
  ([28342](https://github.com/civicrm/civicrm-core/pull/28342))**

- **Remove handling from previously shared code
  ([28336](https://github.com/civicrm/civicrm-core/pull/28336))**

- **Remove notice from main donate page
  ([28498](https://github.com/civicrm/civicrm-core/pull/28498))**

- **Remove some calls to deprecated function
  ([28384](https://github.com/civicrm/civicrm-core/pull/28384))**

- **Remove unused functions noisily deprecated in 2021
  ([28346](https://github.com/civicrm/civicrm-core/pull/28346))**

- **Remove unreachable code
  ([28360](https://github.com/civicrm/civicrm-core/pull/28360))**

- **Remove unused variable
  ([28570](https://github.com/civicrm/civicrm-core/pull/28570))**

- **Remove unused variable
  ([28571](https://github.com/civicrm/civicrm-core/pull/28571))**

- **remove unused variable
  ([28572](https://github.com/civicrm/civicrm-core/pull/28572))**

- **[REF] Extract code to determine the column names
  ([28077](https://github.com/civicrm/civicrm-core/pull/28077))**

- **(REF) Authx - Split `AllFlowsTest` into smaller, themetic tests
  ([28161](https://github.com/civicrm/civicrm-core/pull/28161))**

- **[REF] Regen after #28144
  ([28158](https://github.com/civicrm/civicrm-core/pull/28158))**

- **[REF] APIv4 - Minor cleanup of redundant variables
  ([28150](https://github.com/civicrm/civicrm-core/pull/28150))**

- **[REF] Afform - Namespace mock tests for autoloading
  ([28165](https://github.com/civicrm/civicrm-core/pull/28165))**

- **[REF] Switch strstr to str_contains
  ([28323](https://github.com/civicrm/civicrm-core/pull/28323))**

- **REF: Cleanup to Event Registration Confirm form
  ([28071](https://github.com/civicrm/civicrm-core/pull/28071))**

- **[REF] Angular - cleanup core angular module declarations
  ([28042](https://github.com/civicrm/civicrm-core/pull/28042))**

- **[REF] Fix test fails caused by changes to mailing footer
  ([28146](https://github.com/civicrm/civicrm-core/pull/28146))**

- **[REF] Fix Smarty Notice Errors on Contribution Edit
  ([28163](https://github.com/civicrm/civicrm-core/pull/28163))**

- **REF - Cleanup overly-verbose conditionals
  ([28368](https://github.com/civicrm/civicrm-core/pull/28368))**

- **REF - Cleanup overly-verbose conditionals
  ([28373](https://github.com/civicrm/civicrm-core/pull/28373))**

- **[REF] Use Token Processor to generate sort name and display name for
  individuals ([28391](https://github.com/civicrm/civicrm-core/pull/28391))**

- **[REF][PHP8.2] Properties in TopDonor report
  ([28067](https://github.com/civicrm/civicrm-core/pull/28067))**

- **[REF][PHP8.2] Tidy up properties in CRM_Badge_BAO_Badge
  ([28304](https://github.com/civicrm/civicrm-core/pull/28304))**

- **[REF][PHP8.2] Remove unused property $_loadedMappingId
  ([28290](https://github.com/civicrm/civicrm-core/pull/28290))**

- **[REF][PHP8.2] Declare _context in CRM_Contact_Selector
  ([28200](https://github.com/civicrm/civicrm-core/pull/28200))**

- **[REF][PHP8.2] Declare donorEmail and donorDisplayName properties
  ([28204](https://github.com/civicrm/civicrm-core/pull/28204))**

- **[REF][PHP8.2] Remove need for _allowMultiClient property
  ([28203](https://github.com/civicrm/civicrm-core/pull/28203))**

- **[REF][PHP8.2] Remove unused property usage from test
  ([28201](https://github.com/civicrm/civicrm-core/pull/28201))**

- **[REF][PHP8.2] Declare _redactionRegexRules property
  ([28199](https://github.com/civicrm/civicrm-core/pull/28199))**

- **[REF][PHP8.2] Declare properties in CRM_Utils_PDF_Label
  ([28064](https://github.com/civicrm/civicrm-core/pull/28064))**

- **[REF][PHP8.2] Remove unused id property
  ([28062](https://github.com/civicrm/civicrm-core/pull/28062))**

- **[REF][PHP8.2] Update CRM_Activity_Form_ActivityView for PHP8.2 support
  ([28027](https://github.com/civicrm/civicrm-core/pull/28027))**

- **[REF][PHP8.2] Declare property in CRM_Admin_Form_ParticipantStatusType
  ([28457](https://github.com/civicrm/civicrm-core/pull/28457))**

- **[REF][PHP8.2] Declare properties in TimeSpent report
  ([28444](https://github.com/civicrm/civicrm-core/pull/28444))**

- **[REF][PHP8.2] Declare properties in CRM_Contact_Form_Task_Delete
  ([28446](https://github.com/civicrm/civicrm-core/pull/28446))**

- **[REF][PHP8.2] Declare properties in HouseholdSummary report
  ([28432](https://github.com/civicrm/civicrm-core/pull/28432))**

- **[REF][PHP8.2] Declare properties in CRM_Contact_Form_GroupContact
  ([28106](https://github.com/civicrm/civicrm-core/pull/28106))**

- **[REF][PHP8.2] Declare properties in CRM_Event_Form_Task_Badge
  ([28107](https://github.com/civicrm/civicrm-core/pull/28107))**

- **[REF][PHP8.2] Fix MembershipTest on PHP 8.2
  ([28108](https://github.com/civicrm/civicrm-core/pull/28108))**

- **[REF][PHP8.2] Remove unused property from CRM_Contact_Selector
  ([28341](https://github.com/civicrm/civicrm-core/pull/28341))**

- **[REF][PHP8.2] Ensure _subscriptionDetails is consistently declared
  ([28110](https://github.com/civicrm/civicrm-core/pull/28110))**

- **[REF][PHP8.2] Update CRM_Batch_Form_Entry
  ([28111](https://github.com/civicrm/civicrm-core/pull/28111))**

- **[REF][PHP8.2] Cleanup CRM_Event_Form_SelfSvcUpdate
  ([28109](https://github.com/civicrm/civicrm-core/pull/28109))**

- **[REF][PHP8.2] Remove unused dynamic props
  ([28022](https://github.com/civicrm/civicrm-core/pull/28022))**

- **[REF][PHP8.2] Fix Case_Form_TaskTest test fails on php8.2
  ([28016](https://github.com/civicrm/civicrm-core/pull/28016))**

- **[REF][PHP8.2] Declare properties
  ([305](https://github.com/civicrm/civicrm-wordpress/pull/305))**

- **[REF][PHP8.2] Tidy up CRM_Report_Form_Case_Detail
  ([28028](https://github.com/civicrm/civicrm-core/pull/28028))**

- **[REF][PHP8.2] Update CRM_SMS_Page_Provider
  ([28023](https://github.com/civicrm/civicrm-core/pull/28023))**

- **[REF][PHP8.2] Declare properties in CRM_Activity_Page_Tab
  ([28416](https://github.com/civicrm/civicrm-core/pull/28416))**

- **[REF][PHP8.2] Remove unused dynamic property
  ([28417](https://github.com/civicrm/civicrm-core/pull/28417))**

- **[php8]] Replace undeclared class var with local var
  ([28020](https://github.com/civicrm/civicrm-core/pull/28020))**

- **[NFC] APIv4 - Ensure ContactType api handles accent characters
  ([27994](https://github.com/civicrm/civicrm-core/pull/27994))**

- **[NFC] APIv4 - > test coverage for Search Download by 1 line
  ([27995](https://github.com/civicrm/civicrm-core/pull/27995))**

- **[NFC] update version info in readme.txt
  ([312](https://github.com/civicrm/civicrm-wordpress/pull/312))**

- **NFC - Fix breadcrumb variable type in docblock
  ([304](https://github.com/civicrm/civicrm-wordpress/pull/304))**

- **[NFC] Apply sub-set of WordPress codestyle
  ([306](https://github.com/civicrm/civicrm-wordpress/pull/306))**

- **[NFC] Fix typo in `Localization.tpl` file.
  ([28562](https://github.com/civicrm/civicrm-core/pull/28562))**

- **[NFC] Fix a tiypo
  ([28465](https://github.com/civicrm/civicrm-core/pull/28465))**

- **[NFC] Pass correct param types to file_get_contents
  ([28397](https://github.com/civicrm/civicrm-core/pull/28397))**

- **[NFC] Array formatting cleanup
  ([28339](https://github.com/civicrm/civicrm-core/pull/28339))**

- **Regen
  ([28516](https://github.com/civicrm/civicrm-core/pull/28516))**

- **Regen after 28052
  ([28116](https://github.com/civicrm/civicrm-core/pull/28116))**

- **Regen
  ([28551](https://github.com/civicrm/civicrm-core/pull/28551))**

- **Regen after 28096
  ([28120](https://github.com/civicrm/civicrm-core/pull/28120))**

- **regen
  ([28450](https://github.com/civicrm/civicrm-core/pull/28450))**

- **Regen after 28268
  ([28313](https://github.com/civicrm/civicrm-core/pull/28313))**

- **Re-run regen
  ([28210](https://github.com/civicrm/civicrm-core/pull/28210))**

- **Fix test to not do weird form-trait sharing thing
  ([28554](https://github.com/civicrm/civicrm-core/pull/28554))**

- **Further test consolidation
  ([28212](https://github.com/civicrm/civicrm-core/pull/28212))**

- **Standalone PathUrlTest
  ([28419](https://github.com/civicrm/civicrm-core/pull/28419))**

- **Standalone: fix e2e error message test(s)
  ([28507](https://github.com/civicrm/civicrm-core/pull/28507))**

- **standalone: fix failing E2E test due to getting resource base URL
  ([28475](https://github.com/civicrm/civicrm-core/pull/28475))**

- **add Query to AssetBuilder test to fix WP E2E test failures
  ([28561](https://github.com/civicrm/civicrm-core/pull/28561))**

- **Test-notice-fix affecting all tests
  ([28535](https://github.com/civicrm/civicrm-core/pull/28535))**

- **Fix tests calling AdditionalPayment form to use full flow, add standard ID
  get functions ([28461](https://github.com/civicrm/civicrm-core/pull/28461))**

- **Asset builder test
  ([28443](https://github.com/civicrm/civicrm-core/pull/28443))**

- **LegacyRestTest - No need to test `extern/rest.php` on `Standalone`
  ([28410](https://github.com/civicrm/civicrm-core/pull/28410))**

- **LocalizedDataTest - Fix for standalone
  ([28408](https://github.com/civicrm/civicrm-core/pull/28408))**

- **"Fix" test fail E2E_Extern_WidgetTest::testWidget by skipping it
  ([28411](https://github.com/civicrm/civicrm-core/pull/28411))**

- **Fix for intermittent test fail on checksum time
  ([28392](https://github.com/civicrm/civicrm-core/pull/28392))**

- **Fix dataSource test to test permissions
  ([28327](https://github.com/civicrm/civicrm-core/pull/28327))**

- **Minor test clean up
  ([28235](https://github.com/civicrm/civicrm-core/pull/28235))**

- **Add testing on emails for separate payment,
  ([28091](https://github.com/civicrm/civicrm-core/pull/28091))**

- **Improve test output message
  ([28214](https://github.com/civicrm/civicrm-core/pull/28214))**

- **Minor standardisation in test class
  ([28197](https://github.com/civicrm/civicrm-core/pull/28197))**

- **Move ContributionPage test to ConfirmTest class
  ([28692](https://github.com/civicrm/civicrm-core/pull/28692))**

- **Fix tests to use full form flow, more reliable data
  ([28207](https://github.com/civicrm/civicrm-core/pull/28207))**

- **Add test cover for tax details in Dummy payment online contribution receipt
  ([28143](https://github.com/civicrm/civicrm-core/pull/28143))**

- **Update contributor-key.yml
  ([28486](https://github.com/civicrm/civicrm-core/pull/28486))**

- **5.69.0 release notes initial run
  ([28590](https://github.com/civicrm/civicrm-core/pull/28590) and
  [28807](https://github.com/civicrm/civicrm-core/pull/28807))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

19ATF72; AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Francis Whittle,
Justin Freeman; Artful Robot - Rich Lott; ASMAC (American Society of Music
Arrangers and Composers) - Jeff Kellem; Benjamin W; BrightMinded Ltd - Bradley
Taylor; Christian Wach; Circle Interactive - Pradeep Nayak; CiviCoop - Erik
Hommel, Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha
Chaku; civiservice.de - Sebastian Lisken; CompuCorp - Omar Abu Hussein; Coop
SymbioTIC - Mathieu Lutfy; Dave D; Fuzion - Jitendra Purohit; Greenpeace Central
and Eastern Europe - Patrick Figel; iXiam - César Ramos; JMA Consulting - Seamus
Lee; Joinery - Allen Shaw; Lemniscus - Noah Miller; Lighthouse Consulting and
Design - Brian Shaughnessy; Megaphone Technology Consulting - Jon Goldberg; MJW
Consulting - Matthew Wire; Nicol Wistreich; OPEN - dewy; OSSeed Technologies
LLP - Vinay Gawade; PHD Computer Consultants Ltd - Chris Cant; Reflexive
Communications - Sandor Semsey; Skvare - Sunil Pawar; Squiffle Consulting -
Aidan Saunders; Tadpole Collective - Kevin Cristiano; Third Sector Design -
Kurund Jalmi, William Mortada; Wikimedia Foundation - Damilare Adedoyin, Eileen
McNaughton, Wenjun Fan

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Blackfly Solutions - Alan Dixon; civiservice.de - Andreas Howiller, Tobias
Voigt; Coop SymbioTIC - Samuel Vanhove; Francesc Bassas i Bullich; Freeform
Solutions - Herb van den Dool; Humanists UK - Andrew West; JMA Consulting - Joe
Murray, Monish Deb; Makoa - Usha F. Matisson; Mark; Megaphone Technology
Consulting - Brienne Kordis; Systopia - Dominic Tubach, Johannes Franz;
Wildsight - Lars Sander-Green

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
