# CiviCRM 5.54.0

Released October 5, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Double down or remove use of empoweredBy in invoice template
  ([dev/core#3681](https://lab.civicrm.org/dev/core/-/issues/3681):
  [24102](https://github.com/civicrm/civicrm-core/pull/24102))**

  Adds token for CiviCRM empowered by image.

- **Queue API - Expose option for delayed tasks (`$options['release_time']`)
  ([24395](https://github.com/civicrm/civicrm-core/pull/24395))**

  CRM_Queue_Queue_*::createItem() allows you to create new tasks for
  separate/parallel execution. This patch adds an option for marking new tasks
  as delayed (ie they will execute at some specific time in the future).

- **Unhide message_admin extension
  ([24269](https://github.com/civicrm/civicrm-core/pull/24269))**

  Makes message_admin extension available thru the user interface.

- **APIv4 - Add contact.getDuplicates action
  ([24384](https://github.com/civicrm/civicrm-core/pull/24384))**

  Adds an APIv4 action for finding duplicate contacts given a set of values to
  match.

- **APIv4 - Accept `match` param for Export action
  ([24375](https://github.com/civicrm/civicrm-core/pull/24375))**

  Makes APIv4 Export code generator a little friendlier by inserting the match
  param for you, if specified.

- **Add `civiimport` core extension with Import api code for viewing import
  tables ([24230](https://github.com/civicrm/civicrm-core/pull/24230))**

  Adds new pseudo-crud api for interacting with data import tables.

- **Add support for Contact tokens in welcome email using TokenProcessor
  ([24235](https://github.com/civicrm/civicrm-core/pull/24235))**

  Adds the possibility of using contact tokens in the welcome email

- **Message Templates - Allow rendering & previewing of translated messages
  ([24174](https://github.com/civicrm/civicrm-core/pull/24174))**

  Allows MessageTemplates to be translated.

- **SearchKit - Use combo button+dropdown for creating new search or segment
  ([24199](https://github.com/civicrm/civicrm-core/pull/24199))**

  Slightly more convenient buttons for creating a new search or segment.

- **SearchKit - Support form filters for relationships
  ([24293](https://github.com/civicrm/civicrm-core/pull/24293))**

  Makes it possible to filter related contacts by relationship fields.

- **SearchKit - Better title and description for managed entities
  ([24201](https://github.com/civicrm/civicrm-core/pull/24201))**

  Improves titles and descriptions for managed entities.

- **SearchKit - Add contacts to mailing group in batches
  ([24254](https://github.com/civicrm/civicrm-core/pull/24254))**

  Fixes potential problems when creating large CiviMail mailing groups via
  SearchKit (for the "Email - schedule/send via CiviMail" action).

- **SearchKit - Show other FK fields in the bridge join selector
  ([24505](https://github.com/civicrm/civicrm-core/pull/24505))**

  Allows Relationship IDs to be selected.

- **Search Kit: More options on field transformations of a Date Field
  ([dev/core#3700](https://lab.civicrm.org/dev/core/-/issues/3700):
  [24181](https://github.com/civicrm/civicrm-core/pull/24181))**

  Improves SearchKit so that you can e.g. Group by the month+year of a
  birth-date.

- **SearchKit - Better support for calculated fields as Afform filters
  ([24448](https://github.com/civicrm/civicrm-core/pull/24448))**

  More support for calculated fields in the Afform Admin UI, allowing them to
  be configured more like real fields. This allows e.g. a SUM() aggregate to be
  made a "search by range" filter.

- **SearchKit - Add activity task
  ([24391](https://github.com/civicrm/civicrm-core/pull/24391))**

  Adds the "Add activity" task to SearchKit (for contact searches).

- **FormBuilder - setting a field as 'required' does not implement any
  validation check
  (Work Towards [dev/core#3137](https://lab.civicrm.org/dev/core/-/issues/3137):
  [23604](https://github.com/civicrm/civicrm-core/pull/23604))**

  Implements a client-side only implementation of required field validation for
  Afforms.

- **Afform - add "Existing entity" selector
  ([24165](https://github.com/civicrm/civicrm-core/pull/24165))**

  Allows selecting an existing entity, optionally filtered by a Saved Search in
  Afform.

- **Require search kit & form builder for `civiimport`
  ([24635](https://github.com/civicrm/civicrm-core/pull/24635))**

  Requires search kit & form builder for civiimport.

- **Add angular form to civiimport extension
  ([24545](https://github.com/civicrm/civicrm-core/pull/24545))**

  Add alternate import angular mapping form for contribution import in the
  civimport extension.

- **Add Saved searches to view import jobs
  ([24343](https://github.com/civicrm/civicrm-core/pull/24343))**

  Adds Saved searches to view import jobs.

- **AdminUI - Add SearchKit-based screen for Administer Contact Types
  ([24512](https://github.com/civicrm/civicrm-core/pull/24512))**

  One more step toward building out the CiviCRM Admin UI extension, this
  converts the "Administer Contact Types" screen, while adding a new feature to
  SearchKit: a convenient "Add New..." button at the top of the search display.

- **File::findFiles - Save 200 million nanoseconds
  ([24490](https://github.com/civicrm/civicrm-core/pull/24490))**

  Performance Improvement.

- **CiviCRM sample data - use a price set for at least one contribution page &
  event ([dev/core#3685](https://lab.civicrm.org/dev/core/-/issues/3685):
  [24103](https://github.com/civicrm/civicrm-core/pull/24103))**

  Updates some of our sample data price sets to NOT be quick config.

- **Improve activity demo data - more types
  ([24314](https://github.com/civicrm/civicrm-core/pull/24314))**

  Extends the types of activities in the sample data

### CiviCase

- **Afform - support opening new case
  ([24236](https://github.com/civicrm/civicrm-core/pull/24236))**

  Allows the Case entity to be added to Form Builder and configure case client
  and other fields (including custom). Submitting the form will open a new case
  for the specified client, which could be the current user, or another contact
  on the form.

- **Case Dashboard improvements
  ([dev/core#3822](https://lab.civicrm.org/dev/core/-/issues/3822):
  [24382](https://github.com/civicrm/civicrm-core/pull/24382))**

  On the case dashboard sorts the recently performed activities by most recent
  first.

- **APIv4 - Add `case_id` field to Activity entity
  ([24244](https://github.com/civicrm/civicrm-core/pull/24244)
  and [24360](https://github.com/civicrm/civicrm-core/pull/24360))**

  Adds a case ID field to APIv4 Activity entity and adds support for updating
  it.

### CiviContribute

- **Update invoice template to be (mostly) previewable
  ([24122](https://github.com/civicrm/civicrm-core/pull/24122))**

- **Fix contribution online receipt to be, somewhat, previewable
  ([24321](https://github.com/civicrm/civicrm-core/pull/24321))**

- **Improve contribution import error handling
  ([24501](https://github.com/civicrm/civicrm-core/pull/24501))**

  Better error messages for contribution imports.

- **Financial Type ACLs don't work on soft credits (Work Towards
  [dev/financial#121](https://lab.civicrm.org/dev/financial/-/issues/121):
  [22504](https://github.com/civicrm/civicrm-core/pull/22504))**

  Supports modifying Soft Credit permissions via hook.

### CiviEvent

- **Add initial Event Message Template previewability
  ([24323](https://github.com/civicrm/civicrm-core/pull/24323))**

  Adds Event Message Template previewability (with tokens populated).

- **Event participant registered by contact ID
  (Work Towards [dev/core#3778](https://lab.civicrm.org/dev/core/-/issues/3778):
  [24304](https://github.com/civicrm/civicrm-core/pull/24304) and
  [24167](https://github.com/civicrm/civicrm-core/pull/24167))**

  Adds created_id field to civicrm_participant and adds a code hook to set the
  civicrm_participant.created_id.

### CiviMember

- **Add hint to create membership "You do not have all the permissions needed
  for this page" message
  ([24253](https://github.com/civicrm/civicrm-core/pull/24253))**

  Clearer error message when trying to create a membership when no membership
  types have been configured.

- **Membership should be listed chronologically by join date, the most recent
  member since first
  ([dev/core#3141](https://lab.civicrm.org/dev/core/-/issues/3141):
  [24194](https://github.com/civicrm/civicrm-core/pull/24194))**

  Improves the Membership tab on the contact record by sorting the memberships
  listed by join date.

### Drupal Integration

- **Epic: Drupal 10 readiness (Work Towards
  [dev/drupal#176](https://lab.civicrm.org/dev/drupal/-/issues/176):
  [24133](https://github.com/civicrm/civicrm-core/pull/24133))**

  Makes loadBootstrap work in drupal 10, e.g. to make `cv` work.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **allow contact reference custom fields to have lengths greater than 255
  characters ([24468](https://github.com/civicrm/civicrm-core/pull/24468))**

- **Define `setLocale()` for languages which aren't "all there"
  ([dev/translation#78](https://lab.civicrm.org/dev/translation/-/issues/78):
  [24403](https://github.com/civicrm/civicrm-core/pull/24403))**

- **Failed payment blocks member from joining again, should be Pending not
  Cancelled ([dev/core#2517](https://lab.civicrm.org/dev/core/-/issues/2517):
  [24342](https://github.com/civicrm/civicrm-core/pull/24342))**

  Remove tests from core test suites relating to membership cancellation process
  and update extension unit tests to cover for gaps in testing.

- **Remove dataColumnGuessing
  ([dev/core#3664](https://lab.civicrm.org/dev/core/-/issues/3664):
  [24212](https://github.com/civicrm/civicrm-core/pull/24212))**

- **Fix Import metadata to use apiv4 for contact on contribution imports
  ([24441](https://github.com/civicrm/civicrm-core/pull/24441))**

- **Importing Data: field "source" is updated instead of filled
 ([dev/core#3733](https://lab.civicrm.org/dev/core/-/issues/3733):
 [24001](https://github.com/civicrm/civicrm-core/pull/24001))**

- **Fix import class loading issue in entityTypes hook
 ([24621](https://github.com/civicrm/civicrm-core/pull/24621))**

- **Fix civiimport crash on unmapped fields, remove overzealous cleanup, add
  api to help debug & test
  ([24603](https://github.com/civicrm/civicrm-core/pull/24603))**

- **Stop removing Import tables during cache clearing
  ([24538](https://github.com/civicrm/civicrm-core/pull/24538))**

- **Fix import classes to call `runAllInteractive()` rather than `runAllViaWeb`
 (which in practice currently just calls `runAllViaWeb`)
 ([24396](https://github.com/civicrm/civicrm-core/pull/24396))**

- **Fix import to support entity_configuration
 ([24520](https://github.com/civicrm/civicrm-core/pull/24520))**

- **Fix some inconsistent key names, as used by civiimport
 ([24574](https://github.com/civicrm/civicrm-core/pull/24574))**

- **Add 'Entity' to the information import parser classes provide
 ([24285](https://github.com/civicrm/civicrm-core/pull/24285))**

- **Undefined array key "rows" in Search.tpl.php when entering "Manage Groups"
  ([dev/core#3771](https://lab.civicrm.org/dev/core/-/issues/3771):
  [24318](https://github.com/civicrm/civicrm-core/pull/24318))**

- **Custom Groups should not exclude activity types where filter > 0 if in
  managed entities
  ([dev/core#3796](https://lab.civicrm.org/dev/core/-/issues/3796):
  [24222](https://github.com/civicrm/civicrm-core/pull/24222))**

- **Allow other extensions to use Recaptcha extension for validation
  ([dev/core#3811](https://lab.civicrm.org/dev/core/-/issues/3811):
  [24303](https://github.com/civicrm/civicrm-core/pull/24303))**

  Fixes for missing recaptcha_check_answer() when validate is called by other
  extensions.

- **Scheduled Reminders' effective start/end date incorrectly described.
  ([dev/core#3823](https://lab.civicrm.org/dev/core/-/issues/3823):
  [24421](https://github.com/civicrm/civicrm-core/pull/24421))**

- **PHP 8.2 Deprecated ${} string interpolation
  ([dev/core#3831](https://lab.civicrm.org/dev/core/-/issues/3831):
  [24436](https://github.com/civicrm/civicrm-core/pull/24436))**

- **PHP 8.2 Dynamic Properties are deprecated
  ([dev/core#3833](https://lab.civicrm.org/dev/core/-/issues/3833):
  [24438](https://github.com/civicrm/civicrm-core/pull/24438) and
  [24440](https://github.com/civicrm/civicrm-core/pull/24440))**

- **Middle name is evaluating to literal word null in addressee greeting
  ([dev/core#3838](https://lab.civicrm.org/dev/core/-/issues/3838):
  [24513](https://github.com/civicrm/civicrm-core/pull/24513))**

- **Error when creating a message template
 ([dev/core#3862](https://lab.civicrm.org/dev/core/-/issues/3862):
 [24615](https://github.com/civicrm/civicrm-core/pull/24615))**

- **Default location type for email seems to have become Billing, even if Home
  is set as the default.
  ([dev/core#3863](https://lab.civicrm.org/dev/core/-/issues/3863):
  [24587](https://github.com/civicrm/civicrm-core/pull/24587))**

- **Move creating of nav & menu items to legacycustomsearches extension
  ([23862](https://github.com/civicrm/civicrm-core/pull/23862))**

- **Update references to 'workflow' (from old 'valueName' parameter)
  ([24054](https://github.com/civicrm/civicrm-core/pull/24054))**

- **Update DAO to use declared primary field, do not assume...
  ([24275](https://github.com/civicrm/civicrm-core/pull/24275))**

- **AllCoreTables - Dismbiguate `init `and `flush`
  ([24274](https://github.com/civicrm/civicrm-core/pull/24274))**

- **OAuth fixes
  ([24383](https://github.com/civicrm/civicrm-core/pull/24383))**

- **Fix array-cache-bypass - in FastArrays on `has()`
  ([24156](https://github.com/civicrm/civicrm-core/pull/24156))**

- **Fix email notices on email edit block
  ([24332](https://github.com/civicrm/civicrm-core/pull/24332))**

- **Afform - Fix date range filters for search displays
  ([24451](https://github.com/civicrm/civicrm-core/pull/24451))**

- **Afform - Fix setting default value for date filter fields
  ([24471](https://github.com/civicrm/civicrm-core/pull/24471))**

- **Afform - Fix "Existing" autocomplete field and add tests
  ([24551](https://github.com/civicrm/civicrm-core/pull/24551))**

- **SearchKit - Fix arithmetic in WHERE clause
  ([24514](https://github.com/civicrm/civicrm-core/pull/24514))**

- **Fix warnings on upgrade when non-core message templates exist
  ([24588](https://github.com/civicrm/civicrm-core/pull/24588))**

- **RecentItems - Fix inconsistent option values between upgrader & installer
  ([24632](https://github.com/civicrm/civicrm-core/pull/24632))**

- **Put back exception during class scanning
  ([24601](https://github.com/civicrm/civicrm-core/pull/24601))**

- **Undo breakage of multi-primary key entities
  ([24584](https://github.com/civicrm/civicrm-core/pull/24584))**

- **Class scanner - do not throw runTime Exception if class not loaded
  ([24580](https://github.com/civicrm/civicrm-core/pull/24580))**

- **Flush old user jobs
  ([24546](https://github.com/civicrm/civicrm-core/pull/24546))**

- **DebugSubscriber - Fix activation check
  ([24554](https://github.com/civicrm/civicrm-core/pull/24554))**

- **Pass correct variable type to CRM_Core_OptionValue::getValues
  ([24543](https://github.com/civicrm/civicrm-core/pull/24543))**

- **Deprecate preferred_mail_format column
  ([24426](https://github.com/civicrm/civicrm-core/pull/24426))**

- **Smarty notice fix - remove obsolete preferred_mail_format
  ([24335](https://github.com/civicrm/civicrm-core/pull/24335))**

- **CrmUi - Fix tabSetOptions variable
  ([24197](https://github.com/civicrm/civicrm-core/pull/24197))**

- **Mark some more fields deprecated or readonly
  ([24429](https://github.com/civicrm/civicrm-core/pull/24429))**

- **Increase the deprecation on some unused functions
  ([24442](https://github.com/civicrm/civicrm-core/pull/24442))**

- **Stop PHP warning on installations with no contributions
  ([24427](https://github.com/civicrm/civicrm-core/pull/24427))**

- **CRM_Queue_Queue - Add 'getStatistic($name)'. Deprecate 'numberOfItems()'
  ([24452](https://github.com/civicrm/civicrm-core/pull/24452))**

- **Languages - Dropdown lists should reflect supported languages
  ([24444](https://github.com/civicrm/civicrm-core/pull/24444))**

- **Use preferred `{contact.email_greeting_display}` token over deprecated
  `{contact.email_greeting}` in ALL templates
  ([24316](https://github.com/civicrm/civicrm-core/pull/24316))**

- **ManagedEntity - Ensure managed record is consistently deleted
  ([24435](https://github.com/civicrm/civicrm-core/pull/24435))**

- **When updating userJob status to match queue status skip permission check
  ([24394](https://github.com/civicrm/civicrm-core/pull/24394))**

- **Warning popup about copy of extension in system path disappears too fast
  ([24381](https://github.com/civicrm/civicrm-core/pull/24381))**

- **APIv4 - Fix some hard-coded references to 'id' in DAO action classes
  ([24290](https://github.com/civicrm/civicrm-core/pull/24290))**

- **APIv4 - Promote option `$language` from DAOActionTrait to AbstractAction
  ([24430](https://github.com/civicrm/civicrm-core/pull/24430))**

- **APIv4 - Add comments and fix data type for contact location joins
  ([24239](https://github.com/civicrm/civicrm-core/pull/24239))**

- **APIv4 - Fix GroupContact permission to use standard ACLs
  ([24186](https://github.com/civicrm/civicrm-core/pull/24186))**

- **Fix notice on skipTitle
  ([24338](https://github.com/civicrm/civicrm-core/pull/24338))**

- **Strict smarty notice fix on contact edit - `isSingleRecordEdit`
  ([24330](https://github.com/civicrm/civicrm-core/pull/24330))**

- **Fix Advanced search under strict smarty
  ([24336](https://github.com/civicrm/civicrm-core/pull/24336))**

- **Fix `returnProperties` on contact retrieval in `Contact_Tokens` to fetch
  less, less often
  ([24315](https://github.com/civicrm/civicrm-core/pull/24315))**

- **ClassScanner - Fix guard for preboot cache scenario
  ([24480](https://github.com/civicrm/civicrm-core/pull/24480))**

- **ClassScanner - Throw an exception if a class-file doesn't have the expected
  class ([24348](https://github.com/civicrm/civicrm-core/pull/24348))**

- **Clean up another cache usage to use metadata
  ([24298](https://github.com/civicrm/civicrm-core/pull/24298))**

- **Fix another cache usage to use metadata cache
  ([24297](https://github.com/civicrm/civicrm-core/pull/24297))**

- **Further fix on  `fastArrayCache` `has`
  ([24292](https://github.com/civicrm/civicrm-core/pull/24292))**

- **Fix use of legacy pseudoConstant methods
  ([24270](https://github.com/civicrm/civicrm-core/pull/24270))**

- **Case-insensitive match on subtypes when validating subtype by entity for
  custom groups ([24134](https://github.com/civicrm/civicrm-core/pull/24134))**

- **CiviEventDispatcher - Fix pass-by-reference of hook-style arguments for
  service-based listeners
  ([24282](https://github.com/civicrm/civicrm-core/pull/24282))**

- **[php 8 compat] Make sure variables are assigned in civireport
  ([24326](https://github.com/civicrm/civicrm-core/pull/24326))**

- **Fix PHP notice and hide/show 'including yourself' depending on if
  contact_id is set
  ([24301](https://github.com/civicrm/civicrm-core/pull/24301))**

- **AUS is not a valid ISO 3166-1 alpha-2 country code. Do not use it in tests
  ([24277](https://github.com/civicrm/civicrm-core/pull/24277))**

- **Further caching fix - use metadata cache
  ([24294](https://github.com/civicrm/civicrm-core/pull/24294))**

- **Mark `contact.created date` read-only in schema
  ([24417](https://github.com/civicrm/civicrm-core/pull/24417))**

- **CRM_Core_DAO - Be more flexible about the primary key name
  ([24299](https://github.com/civicrm/civicrm-core/pull/24299))**

- **QueueItem - Convert DATETIME to TIMESTAMP
  ([24399](https://github.com/civicrm/civicrm-core/pull/24399))**

- **Add unique index to DedupeRuleGroup.name field
  ([24385](https://github.com/civicrm/civicrm-core/pull/24385))**

- **Resolve existential crisis for customfield.is_active
  ([24246](https://github.com/civicrm/civicrm-core/pull/24246))**

- **Alternate to #24143 - Update all is_reserved message templates during
  upgrade and their corresponding is_default's if it hasn't been edited
  ([24345](https://github.com/civicrm/civicrm-core/pull/24345))**

### CiviCase

- **Migrate case activity revisions to trigger-based logging
  ([dev/core#1532](https://lab.civicrm.org/dev/core/-/issues/1532):
  [24266](https://github.com/civicrm/civicrm-core/pull/24266) and
  [24249](https://github.com/civicrm/civicrm-core/pull/24249))**

  Add upgrade message about civicase activity revisions and related cleanup.

### CiviContribute

- **Import of contributions (update existing) -> error for total_amount = "0"
  ([dev/core#3828](https://lab.civicrm.org/dev/core/-/issues/3828):
  [24414](https://github.com/civicrm/civicrm-core/pull/24414))**

- **Searchkit: Contribution tasks like receipt give fatal error
  ([dev/core#3826](https://lab.civicrm.org/dev/core/-/issues/3826):
  [24593](https://github.com/civicrm/civicrm-core/pull/24593))**

- **CiviCRM crashes when I select ZMK as default currency
  ([dev/financial#192](https://lab.civicrm.org/dev/financial/-/issues/192):
  [24428](https://github.com/civicrm/civicrm-core/pull/24428))**

  Fallback to custom currency object for codes which Brick\Money does not
  support.

- **Download invoice button on contribution view gives fatal error
 ([dev/financial#208](https://lab.civicrm.org/dev/financial/-/issues/208):
 [24434](https://github.com/civicrm/civicrm-core/pull/24434))**

- **Adjust contribution metadata to filter at display not load
  ([24475](https://github.com/civicrm/civicrm-core/pull/24475))**

- **Mapping field schema inadequate
  (Work Towards [dev/core#1172](https://lab.civicrm.org/dev/core/-/issues/1172):
  [24485](https://github.com/civicrm/civicrm-core/pull/24485))**

  Fix Contribution import to handle ContributionSoft in a storable way.

- **Fix imported statuses & contribution id storage on import job
  ([24344](https://github.com/civicrm/civicrm-core/pull/24344))**

- **Add missing country=>billingCountry to PropertyBag mapping
  ([24232](https://github.com/civicrm/civicrm-core/pull/24232))**

- **[php8] E_WARNING on Find Contributions
  ([24195](https://github.com/civicrm/civicrm-core/pull/24195))**

- **Fix some notices on New Contribution page (smarty)
  ([24409](https://github.com/civicrm/civicrm-core/pull/24409))**

- **Remove attempt to match on soft credit header
  ([24566](https://github.com/civicrm/civicrm-core/pull/24566))**

- **Enotice fix on payment processor browse
  ([24308](https://github.com/civicrm/civicrm-core/pull/24308))**

- **Fix broken js on Contribution Import
  ([24371](https://github.com/civicrm/civicrm-core/pull/24371))**

- **For Contribution pages with a recurring payment option. Change the label
  from "Regular amount"  to "Regular Amount"
  ([24310](https://github.com/civicrm/civicrm-core/pull/24310))**

### CiviEvent

- **Adding better wording to Events page for matching dates
  ([24489](https://github.com/civicrm/civicrm-core/pull/24489))**

- **🎁 CiviEvent, Event Dashboard, iCal links are inside the h3 styling move out
  and add spacing ([24149](https://github.com/civicrm/civicrm-core/pull/24149))**

- **Fix participant import not to import to deleted contacts
  ([24377](https://github.com/civicrm/civicrm-core/pull/24377))**

- **Stop PHP notice when accessing invalid event ID
  ([24406](https://github.com/civicrm/civicrm-core/pull/24406))**

### CiviMail

- **Search Kit: CiviMail search action fails for non-administrators
  ([dev/core#3755](https://lab.civicrm.org/dev/core/-/issues/3755):
  [24268](https://github.com/civicrm/civicrm-core/pull/24268))**

- **Increase field size for mailing bounce type
  ([dev/core#3489](https://lab.civicrm.org/dev/core/-/issues/3489):
  [23658](https://github.com/civicrm/civicrm-core/pull/23658))**

### CiviMember

- **Convert membership Import to use select2
  ([24356](https://github.com/civicrm/civicrm-core/pull/24356))**

- **Membership import - Simplify contact_id validation & avoid deleted contacts
  ([24380](https://github.com/civicrm/civicrm-core/pull/24380))**

- **Fix is_override variable in MembershipView
  ([24617](https://github.com/civicrm/civicrm-core/pull/24617))**

### CiviPledge

- **Pledge status is missing on View Pledge page
  ([dev/core#3790](https://lab.civicrm.org/dev/core/-/issues/3790):
  [24492](https://github.com/civicrm/civicrm-core/pull/24492))**

### Drupal Integration

- **Symfony 6 can't find the EventDispatcher when adding hooks that are defined
  in getSubscribedEvents
  ([dev/core#3802](https://lab.civicrm.org/dev/core/-/issues/3802):
  [24250](https://github.com/civicrm/civicrm-core/pull/24250))**

  Compatibility with symfony 6 for drupal 10 for listeners added via
  getSubscribedEvents.

- **Drupal views group filter is not working
  ([dev/core#414](https://lab.civicrm.org/dev/core/-/issues/414):
  [548](https://github.com/civicrm/civicrm-drupal/pull/548))**

  Fixes the contact subtype drupal views group filter.

### Joomla Integration

- **Add temporary file to help Joomla installers (5.54-rc)
  ([24572](https://github.com/civicrm/civicrm-core/pull/24572))**

## <a name="misc"></a>Miscellany

- **Fix PHPDoc comment for CRM_Financial_BAO_FinancialItem::add
  ([24439](https://github.com/civicrm/civicrm-core/pull/24439))**

- **Contribution import - test notes, cleanup notes, fix regression found
  in test writing ([24419](https://github.com/civicrm/civicrm-core/pull/24419))**

- **Add missing PHPDoc types
  ([24424](https://github.com/civicrm/civicrm-core/pull/24424))**

- **Use shared parent formRule in custom import api
  ([24389](https://github.com/civicrm/civicrm-core/pull/24389))**

- **Update Contribution import to use new v4 dedupe lookup
  ([24402](https://github.com/civicrm/civicrm-core/pull/24402))**

- **Switch Contact import to use new v4 dedupe lookup
  ([24401](https://github.com/civicrm/civicrm-core/pull/24401))**

- **Regenerate sql
  ([24311](https://github.com/civicrm/civicrm-core/pull/24311))**

- **Finish consolidating DataSource.tpl across non-contact imports
  ([24267](https://github.com/civicrm/civicrm-core/pull/24267))**

- **Unused function getOptionalSmartyElements
  ([24327](https://github.com/civicrm/civicrm-core/pull/24327))**

- **API - Standardize group ACL checks
  ([24337](https://github.com/civicrm/civicrm-core/pull/24337))**

- **Simplify Domain edit form to not call complete
  `LocationBlock::buildQuickForm`
  ([24333](https://github.com/civicrm/civicrm-core/pull/24333))**

- **Deprecate two single-use option-value functions `create-a-sock` and
  `delete-a-sock` ([24306](https://github.com/civicrm/civicrm-core/pull/24306))**

- **Deprecate `BAO_Membership::importableFields`
  ([24357](https://github.com/civicrm/civicrm-core/pull/24357))**

- **Move `isSkipDuplicates` to shared parent
  ([24354](https://github.com/civicrm/civicrm-core/pull/24354))**

- **Unused functions in CRM_Upgrade_Form
  ([24361](https://github.com/civicrm/civicrm-core/pull/24361))**

- **Consolidate error handling on Custom data import tpl
  ([24216](https://github.com/civicrm/civicrm-core/pull/24216))**

- **Code cleanup on greeting processing
  ([24129](https://github.com/civicrm/civicrm-core/pull/24129))**

- **Deprecate horrible function + unreleased regression
  ([24386](https://github.com/civicrm/civicrm-core/pull/24386))**

- **Fix processCaseActivity docblock
  ([24251](https://github.com/civicrm/civicrm-core/pull/24251))**

- **Deprecate `BAO_Contribution::importableFields`
  ([24225](https://github.com/civicrm/civicrm-core/pull/24225))**

- **Move non-shared function to private function on using class
  ([24227](https://github.com/civicrm/civicrm-core/pull/24227))**

- **Tidy up whereClause method of mailing browse
  ([24404](https://github.com/civicrm/civicrm-core/pull/24404))**

- **APIv4 - Drop support for deprecated join syntax
  ([24075](https://github.com/civicrm/civicrm-core/pull/24075))**

- **PHPDoc comment fixes
  ([24405](https://github.com/civicrm/civicrm-core/pull/24405))**

- **Minor code cleanup - the form rule is in the parent function
  ([24388](https://github.com/civicrm/civicrm-core/pull/24388))**

- **Move unshared code to unshared function
  ([24218](https://github.com/civicrm/civicrm-core/pull/24218))**

- **Move a little code from legacy function `loadRelatedObjects` to the calling
  functions ([24190](https://github.com/civicrm/civicrm-core/pull/24190))**

- **Docblock fix - findOrphanedFiles method
  ([24423](https://github.com/civicrm/civicrm-core/pull/24423))**

- **Re-run regen
  ([24461](https://github.com/civicrm/civicrm-core/pull/24461))**

- **Follow up code simplification - no need to map 'Individual' to 'Individual'
  ([24473](https://github.com/civicrm/civicrm-core/pull/24473))**

- **More PHPdoc fixes
  ([24495](https://github.com/civicrm/civicrm-core/pull/24495))**

- **report cleanup
  ([24503](https://github.com/civicrm/civicrm-core/pull/24503))**

- **report clean up templates
  ([24504](https://github.com/civicrm/civicrm-core/pull/24504))**

- **report clean up templates
  ([24508](https://github.com/civicrm/civicrm-core/pull/24508))**

- **BAO regen
  ([24507](https://github.com/civicrm/civicrm-core/pull/24507))**

- **(REF) Extract method `Array::single()`
  ([24287](https://github.com/civicrm/civicrm-core/pull/24287))**

- **(REF) I18nSubscriber - Rename parameter to be more evocative
  ([24281](https://github.com/civicrm/civicrm-core/pull/24281))**

- **[REF] Activity BAO - Decouple CiviCase logic from create function
  ([24247](https://github.com/civicrm/civicrm-core/pull/24247))**

- **(REF) Extract compiler passes from CRM_Api4_Services
  ([24283](https://github.com/civicrm/civicrm-core/pull/24283))**

- **[REF] Decouple CiviGrant from core permission function
  ([24191](https://github.com/civicrm/civicrm-core/pull/24191))**

- **[Import] [Ref] Extract shared form rule code
  ([24217](https://github.com/civicrm/civicrm-core/pull/24217))**

- **(REF) Extract LocaleTestTrait. Tighten up multilingual testing.
  ([24291](https://github.com/civicrm/civicrm-core/pull/24291))**

- **[REF] ManagedEntities - Move deprecated function
  ([24437](https://github.com/civicrm/civicrm-core/pull/24437))**

- **REF] Standardise validation of mapped fields in imports, fix over-zealous
  requirements when matching on trxn_id, invoice_id for update
  ([24433](https://github.com/civicrm/civicrm-core/pull/24433))**

- **REF Code cleanup for event configuration extracted from advancedevents
  extension ([24418](https://github.com/civicrm/civicrm-core/pull/24418))**

- **(REF) Tests - Misc updates in prepartion for l10n updates
  ([24400](https://github.com/civicrm/civicrm-core/pull/24400))**

- **[Ref] Import cleanup code that looks up contribution in import
  ([24374](https://github.com/civicrm/civicrm-core/pull/24374))**

- **[REF] Variable use cleanup
  ([24390](https://github.com/civicrm/civicrm-core/pull/24390))**

- **[Ref] Extract getContactFields
  ([24362](https://github.com/civicrm/civicrm-core/pull/24362))**

- **[REF] Simplify error handling in contribution import
  ([24351](https://github.com/civicrm/civicrm-core/pull/24351))**

- **[REF] Fold only parent class into only child class
  ([24353](https://github.com/civicrm/civicrm-core/pull/24353))**

- **[REF] Only add in entry to update Greeting if the greeting doesn't match
  what is already in the database
  ([24309](https://github.com/civicrm/civicrm-core/pull/24309))**

- **[REF] Convert Elavon Payment Processor to be a core Extension
  ([24183](https://github.com/civicrm/civicrm-core/pull/24183))**

- **[REF] Update Zetacomponents/mail to be 1.9.4
  ([24517](https://github.com/civicrm/civicrm-core/pull/24517))**

- **[REF] Fix syntax of var docblocks
  ([24498](https://github.com/civicrm/civicrm-core/pull/24498))**

- **(REF) SettingsMetadata - Small cleanup to prevent duplicate slashes
  ([24493](https://github.com/civicrm/civicrm-core/pull/24493))**

- **[REF] Cleanup code to getAvailableFields on Contribution MapField
  ([24484](https://github.com/civicrm/civicrm-core/pull/24484))**

- **[REF] Extract rule-loading function
  ([24474](https://github.com/civicrm/civicrm-core/pull/24474))**

- **[Ref] [Import] Simplify form event MapField (Contact)
  ([24464](https://github.com/civicrm/civicrm-core/pull/24464))**

- **[Ref] [Import] Simplify form event MapField to use shared rule (Participant)
  ([24463](https://github.com/civicrm/civicrm-core/pull/24463))**

- **[REF] Remove calls to settings from angularjs to php layer to assist with
  less permissioned users using civimail
  ([24462](https://github.com/civicrm/civicrm-core/pull/24462))**

- **[REF] Clarify what is being used from getElements, remove unused
  ([24317](https://github.com/civicrm/civicrm-core/pull/24317))**

- **[REF] [Upgrade] Remove the entry point that called the unused entry point
  ([24286](https://github.com/civicrm/civicrm-core/pull/24286))**

- **[REF] Remove unused message template upgrade code
  ([24231](https://github.com/civicrm/civicrm-core/pull/24231))**

- **Importer - Remove unused functions (`isErrorInCustomData`, `getSubtypes`,
  `validateCustomField`)
  ([24280](https://github.com/civicrm/civicrm-core/pull/24280))**

- **[Import-code-cleanup] Fold call to deprecated function back into calling
  function ([24188](https://github.com/civicrm/civicrm-core/pull/24188))**

- **[Import-code-cleanup] Remove unused function
  ([24210](https://github.com/civicrm/civicrm-core/pull/24210))**

- **[Import-code-cleanup] Remove now-unused tpl
  ([24214](https://github.com/civicrm/civicrm-core/pull/24214))**

- **[Import-code-cleanup] Remove now-unused summary forms
  ([24205](https://github.com/civicrm/civicrm-core/pull/24205))**

- **[Import-code-cleanup] Mark a few functions deprecated for clarity & mark
  parser class internal
  ([24185](https://github.com/civicrm/civicrm-core/pull/24185))**

- **[Import-code-cleanup] Fold call to weird deprecated function back into
  calling code ([24189](https://github.com/civicrm/civicrm-core/pull/24189))**

- **[Import-code-cleanup] Remove another now-unused class
  `CRM_Contact_Import_ImportJob`
  ([24211](https://github.com/civicrm/civicrm-core/pull/24211))**

- **Minor readability cleanup - remove code comments about removed item,
  comments ([24397](https://github.com/civicrm/civicrm-core/pull/24397))**

- **Remove last usage of `_fields` from `Import_Parser`
  ([24273](https://github.com/civicrm/civicrm-core/pull/24273))**

- **Remove another three no-longer-used functions
  ([24272](https://github.com/civicrm/civicrm-core/pull/24272))**

- **Remove no-longer-used function
  ([24271](https://github.com/civicrm/civicrm-core/pull/24271))**

- **Remove unused impossible function in upgrade page
  ([24252](https://github.com/civicrm/civicrm-core/pull/24252))**

- **Remove now-unused addField from Participant import
  ([24279](https://github.com/civicrm/civicrm-core/pull/24279))**

- **Remove now-unused addField from Membership import
  ([24288](https://github.com/civicrm/civicrm-core/pull/24288))**

- **Remove references to old temp table names
  ([24532](https://github.com/civicrm/civicrm-core/pull/24532))**

- **Remove silly constants for Contact Types (import)
  ([24465](https://github.com/civicrm/civicrm-core/pull/24465))**

- **Remove function after two years of noisy deprecation
  ([24443](https://github.com/civicrm/civicrm-core/pull/24443))**

- **Remove method getActionAttribute
  ([24425](https://github.com/civicrm/civicrm-core/pull/24425))**

- **Remove method updateDisplayNames
  ([24422](https://github.com/civicrm/civicrm-core/pull/24422))**

- **Remove unreachable legacy code
  ([24226](https://github.com/civicrm/civicrm-core/pull/24226))**

- **Remove always-true if
  ([24410](https://github.com/civicrm/civicrm-core/pull/24410))**

- **Remove obsolete param from duplicated function
  ([24412](https://github.com/civicrm/civicrm-core/pull/24412))**

- **Remove unreachable code
  ([24411](https://github.com/civicrm/civicrm-core/pull/24411))**

- **Remove misleading comment.
  ([24407](https://github.com/civicrm/civicrm-core/pull/24407))**

- **Remove obsolete addField from activity import
  ([24376](https://github.com/civicrm/civicrm-core/pull/24376))**

- **Remove do-nothing code, add test to prove
  ([24350](https://github.com/civicrm/civicrm-core/pull/24350))**

- **Remove extraneous `if` (`supportedFields` always returns an array)
  ([24339](https://github.com/civicrm/civicrm-core/pull/24339))**

- **Remove now-unused addField from Contribution Import
  ([24278](https://github.com/civicrm/civicrm-core/pull/24278))**

- **Remove now-unused addField from Custom import
  ([24289](https://github.com/civicrm/civicrm-core/pull/24289))**

- **Finally remove apiv2 DeprecatedUtils
  ([24208](https://github.com/civicrm/civicrm-core/pull/24208))**

- **Finally remove hated `loadRelatedObjects` call from Invoice task
  ([24319](https://github.com/civicrm/civicrm-core/pull/24319))**

- **Finally full remove the awful addField from import
  ([24379](https://github.com/civicrm/civicrm-core/pull/24379))**

- **Add unit test & handling  for processing from UserJob configuration rather
  than form submitted values
  ([24510](https://github.com/civicrm/civicrm-core/pull/24510))**

- **MailingSystemTest - Fix invalid PHP
  ([24481](https://github.com/civicrm/civicrm-core/pull/24481))**

- **Minor import test cleanup
  ([24387](https://github.com/civicrm/civicrm-core/pull/24387))**

- **Move participant cancel tests to extension
  ([24340](https://github.com/civicrm/civicrm-core/pull/24340))**

- **Test only fixes
  ([24369](https://github.com/civicrm/civicrm-core/pull/24369))**

- **SettingsStyleTest - Stop the madness
  ([24154](https://github.com/civicrm/civicrm-core/pull/24154))**

- **NFC IDE code format to get rid of array()
  ([24215](https://github.com/civicrm/civicrm-core/pull/24215))**

- **[NFC] Fix Typo in Dismaker list of core exts
  ([24570](https://github.com/civicrm/civicrm-core/pull/24570))**

- **[NFC] Add in Unit test to test domain token replacement in Reply process
  ([24453](https://github.com/civicrm/civicrm-core/pull/24453))**

- **(NFC) Fix sprintf syntax
  ([24447](https://github.com/civicrm/civicrm-core/pull/24447))**

- **(NFC) Autoformat big clusters of `list()` statements
  ([24392](https://github.com/civicrm/civicrm-core/pull/24392))**

- **[NFC] Remove no-longer used (protected) function `getAllContactReturnFields()`
  ([24313](https://github.com/civicrm/civicrm-core/pull/24313))**

- **[NFC] Better unit test of Link Cases form
  ([24328](https://github.com/civicrm/civicrm-core/pull/24328))**

- **(NFC) FileTest - Mark as ornery
  ([24307](https://github.com/civicrm/civicrm-core/pull/24307))**

- **[NFC] Add in Further debugging to authx test to try and debug issue
  ([24258](https://github.com/civicrm/civicrm-core/pull/24258))**

- **(NFC) Mark various tests with `@group locale`
  ([24284](https://github.com/civicrm/civicrm-core/pull/24284))**

- **[NFC] Add test for editing activity subject to file on case
  ([24262](https://github.com/civicrm/civicrm-core/pull/24262))**

- **NFC - Make it possible to mark a dao field @deprecated
  ([24248](https://github.com/civicrm/civicrm-core/pull/24248))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt, Alice Frumin; Agileware - Justin Freeman;
BrightMinded Ltd - Bradley Taylor; CiviCoop - Jaap Jansma; CiviCRM - Coleman
Watts, Tim Otten; CiviDesk - Yashodha Chaku; Coop SymbioTIC - Mathieu Lutfy,
Shane Bill; Dave D; Freeform Solutions - Herb van den Dool; JMA Consulting -
Seamus Lee; Megaphone Technology Consulting - Jon Goldberg; MJW Consulting -
Matthew Wire; PERORA SRL - Samuele Masetto; Progressive Technology Project -
Jamie McClelland; SYSTOPIA Organisationsberatung - Björn Endres; Third Sector
Design - Kurund Jalmi; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

alarmingcod; Andy Burns; Artful Robot - Rich Lott; Australian Greens - John
Twyman; avall-llovera; Digitalcourage - Detlev Sieber; Francesc Bassas i
Bullich; Jens Schuppe; Levi.k; Lighthouse Consulting and Design - Brian
Shaughnessy; Megaphone Technology Consulting - Brienne Kordis; Nicol Wistreich;
Squiffle Consulting - Aidan Saunders; Third Sector Design - Michael McAndrew

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
