<?php

use CRM_Utils_SQL_Literal as Literal;

return CRM_Core_CodeGen_SqlData::create('civicrm_financial_account')
  ->addDefaults([
    'contact_id' => new Literal('@contactID'),
    'is_active' => 1,
    'is_reserved' => 0,
  ])
  ->addValues([
    [
      'label' => ts('Donation'),
      'name' => 'Donation',
      'financial_account_type_id' => new Literal('@opval'),
      'description' => 'Default account for donations',
      'accounting_code' => '4200',
      'account_type_code' => 'INC',
      'is_deductible' => 1,
      'is_default' => 1,
    ],
    [
      'label' => ts('Member Dues'),
      'name' => 'Member Dues',
      'financial_account_type_id' => new Literal('@opval'),
      'description' => 'Default account for membership sales',
      'accounting_code' => '4400',
      'account_type_code' => 'INC',
      'is_deductible' => 1,
      'is_default' => 0,
    ],
    [
      'label' => ts('Campaign Contribution'),
      'name' => 'Campaign Contribution',
      'financial_account_type_id' => new Literal('@opval'),
      'description' => 'Sample account for recording payments to a campaign',
      'accounting_code' => '4100',
      'account_type_code' => 'INC',
      'is_deductible' => 0,
      'is_default' => 0,
    ],
    [
      'label' => ts('Event Fee'),
      'name' => 'Event Fee',
      'financial_account_type_id' => new Literal('@opval'),
      'description' => 'Default account for event ticket sales',
      'accounting_code' => '4300',
      'account_type_code' => 'INC',
      'is_deductible' => 0,
      'is_default' => 0,
    ],
    [
      'label' => ts('Banking Fees'),
      'name' => 'Banking Fees',
      'financial_account_type_id' => new Literal('@opexp'),
      'description' => 'Payment processor fees and manually recorded banking fees',
      'accounting_code' => '5200',
      'account_type_code' => 'EXP',
      'is_deductible' => 0,
      'is_default' => 1,
    ],
    [
      'label' => ts('Deposit Bank Account'),
      'name' => 'Deposit Bank Account',
      'financial_account_type_id' => new Literal('@opAsset'),
      'description' => 'All manually recorded cash and cheques go to this account',
      'accounting_code' => '1100',
      'account_type_code' => 'BANK',
      'is_deductible' => 0,
      'is_default' => 1,
    ],
    [
      'label' => ts('Accounts Receivable'),
      'name' => 'Accounts Receivable',
      'financial_account_type_id' => new Literal('@opAsset'),
      'description' => 'Amounts to be received later (eg pay later event revenues)',
      'accounting_code' => '1200',
      'account_type_code' => 'AR',
      'is_deductible' => 0,
      'is_default' => 0,
    ],
    [
      'label' => ts('Accounts Payable'),
      'name' => 'Accounts Payable',
      'financial_account_type_id' => new Literal('@opLiability'),
      'description' => 'Amounts to be paid out such as grants and refunds',
      'accounting_code' => '2200',
      'account_type_code' => 'AP',
      'is_deductible' => 0,
      'is_default' => 1,
    ],
    [
      'label' => ts('Premiums'),
      'name' => 'Premiums',
      'financial_account_type_id' => new Literal('@opCost'),
      'description' => 'Account to record cost of premiums provided to payors',
      'accounting_code' => '5100',
      'account_type_code' => 'COGS',
      'is_deductible' => 0,
      'is_default' => 1,
    ],
    [
      'label' => ts('Premiums inventory'),
      'name' => 'Premiums inventory',
      'financial_account_type_id' => new Literal('@opAsset'),
      'description' => 'Account representing value of premiums inventory',
      'accounting_code' => '1375',
      'account_type_code' => 'OCASSET',
      'is_deductible' => 0,
      'is_default' => 0,
    ],
    [
      'label' => ts('Discounts'),
      'name' => 'Discounts',
      'financial_account_type_id' => new Literal('@opval'),
      'description' => 'Contra-revenue account for amounts discounted from sales',
      'accounting_code' => '4900',
      'account_type_code' => 'INC',
      'is_deductible' => 0,
      'is_default' => 0,
    ],
    [
      'label' => ts('Payment Processor Account'),
      'name' => 'Payment Processor Account',
      'financial_account_type_id' => new Literal('@opAsset'),
      'description' => 'Account to record payments into a payment processor merchant account',
      'accounting_code' => '1150',
      'account_type_code' => 'BANK',
      'is_deductible' => 0,
      'is_default' => 0,
    ],
    [
      'label' => ts('Deferred Revenue - Event Fee'),
      'name' => 'Deferred Revenue - Event Fee',
      'financial_account_type_id' => new Literal('@opLiability'),
      'description' => 'Event revenue to be recognized in future months when the events occur',
      'accounting_code' => '2730',
      'account_type_code' => 'OCLIAB',
      'is_deductible' => 0,
      'is_default' => 0,
    ],
    [
      'label' => ts('Deferred Revenue - Member Dues'),
      'name' => 'Deferred Revenue - Member Dues',
      'financial_account_type_id' => new Literal('@opLiability'),
      'description' => 'Membership revenue to be recognized in future months',
      'accounting_code' => '2740',
      'account_type_code' => 'OCLIAB',
      'is_deductible' => 0,
      'is_default' => 0,
    ],
  ]);
