<?php

return [
  'name' => 'LineItem',
  'table' => 'civicrm_line_item',
  'class' => 'CRM_Price_DAO_LineItem',
  'getInfo' => fn() => [
    'title' => ts('Line Item'),
    'title_plural' => ts('Line Items'),
    'description' => ts('Line Items for Contributions'),
    'log' => TRUE,
    'add' => '1.7',
    'label_field' => 'label',
  ],
  'getFields' => fn() => [
    'id' => [
      'title' => ts('Line Item ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'required' => TRUE,
      'description' => ts('Line Item'),
      'add' => '1.7',
      'primary_key' => TRUE,
      'auto_increment' => TRUE,
    ],
    'entity_table' => [
      'title' => ts('Line Item Entity Type'),
      'sql_type' => 'varchar(64)',
      'input_type' => 'Select',
      'required' => TRUE,
      'description' => ts('May contain civicrm_contribution, civicrm_participant or civicrm_membership'),
      'add' => '1.7',
      'pseudoconstant' => [
        'callback' => ['CRM_Price_BAO_LineItem', 'entityTables'],
      ],
    ],
    'entity_id' => [
      'title' => ts('Line Item Entity'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'required' => TRUE,
      'description' => ts('entry in table'),
      'add' => '1.7',
      'entity_reference' => [
        'dynamic_entity' => 'entity_table',
        'key' => 'id',
      ],
    ],
    'contribution_id' => [
      'title' => ts('Contribution ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to civicrm_contribution'),
      'add' => '4.5',
      'input_attrs' => [
        'label' => ts('Contribution'),
      ],
      'entity_reference' => [
        'entity' => 'Contribution',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'price_field_id' => [
      'title' => ts('Price Field ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('FK to civicrm_price_field'),
      'add' => '1.7',
      'input_attrs' => [
        'label' => ts('Price Field'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_price_field',
        'key_column' => 'id',
        'name_column' => 'name',
        'label_column' => 'label',
      ],
      'entity_reference' => [
        'entity' => 'PriceField',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'label' => [
      'title' => ts('Line Item Label'),
      'sql_type' => 'varchar(255)',
      'input_type' => 'Text',
      'description' => ts('descriptive label for item - from price_field_value.label'),
      'add' => '1.7',
      'default' => NULL,
    ],
    'qty' => [
      'title' => ts('Line Item Quantity'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => 'Text',
      'data_type' => 'Float',
      'required' => TRUE,
      'description' => ts('How many items ordered'),
      'add' => '1.7',
    ],
    'unit_price' => [
      'title' => ts('Unit Price'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('price of each item'),
      'add' => '1.7',
      'input_attrs' => [
        'label' => ts('Unit Price'),
      ],
    ],
    'line_total' => [
      'title' => ts('Line Item Total'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => NULL,
      'required' => TRUE,
      'description' => ts('qty * unit_price'),
      'add' => '1.7',
    ],
    'participant_count' => [
      'title' => ts('Line Item Participant Count'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Text',
      'description' => ts('Participant count for field'),
      'add' => '3.2',
      'default' => NULL,
    ],
    'price_field_value_id' => [
      'title' => ts('Option ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'EntityRef',
      'description' => ts('FK to civicrm_price_field_value'),
      'add' => '3.3',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Option'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_price_field_value',
        'key_column' => 'id',
        'name_column' => 'name',
        'label_column' => 'label',
      ],
      'entity_reference' => [
        'entity' => 'PriceFieldValue',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'financial_type_id' => [
      'title' => ts('Financial Type ID'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Select',
      'description' => ts('FK to Financial Type.'),
      'add' => '4.3',
      'default' => NULL,
      'input_attrs' => [
        'label' => ts('Financial Type'),
      ],
      'pseudoconstant' => [
        'table' => 'civicrm_financial_type',
        'key_column' => 'id',
        'label_column' => 'label',
      ],
      'entity_reference' => [
        'entity' => 'FinancialType',
        'key' => 'id',
        'on_delete' => 'SET NULL',
      ],
    ],
    'non_deductible_amount' => [
      'title' => ts('Non-deductible Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('Portion of total amount which is NOT tax deductible.'),
      'add' => '4.7',
      'default' => '0.0',
    ],
    'tax_amount' => [
      'title' => ts('Tax Amount'),
      'sql_type' => 'decimal(20,2)',
      'input_type' => 'Text',
      'required' => TRUE,
      'description' => ts('tax of each item'),
      'add' => '4.6',
      'default' => '0',
      'usage' => [
        'import',
        'export',
        'duplicate_matching',
      ],
    ],
    'membership_num_terms' => [
      'title' => ts('Number of membership terms purchased'),
      'sql_type' => 'int unsigned',
      'input_type' => 'Number',
      'description' => ts('Number of terms for this membership (only supported in Order->Payment flow). If the field is NULL it means unknown and it will be assumed to be 1 during payment.create if entity_table is civicrm_membership'),
      'add' => '5.40',
      'default' => NULL,
    ],
  ],
];
