# CiviCRM 6.0.0

Released March 5, 2025;

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Installer - Use Riverlea's Minetta by default
  ([31985](https://github.com/civicrm/civicrm-core/pull/31985))**

  Enables Riverlea's Minetta by default on new installs.

- **RiverLea 1.3.4: 3 Thames & 1 core fix, ref MR #49
  ([31930](https://github.com/civicrm/civicrm-core/pull/31930),
  [31961](https://github.com/civicrm/civicrm-core/pull/31961),
  [32077](https://github.com/civicrm/civicrm-core/pull/32077),
  [31781](https://github.com/civicrm/civicrm-core/pull/31781),
  [31913](https://github.com/civicrm/civicrm-core/pull/31913),
  [32176](https://github.com/civicrm/civicrm-core/pull/32176),
  [32209](https://github.com/civicrm/civicrm-core/pull/32209),
  [32129](https://github.com/civicrm/civicrm-core/pull/32129) and
  [31833](https://github.com/civicrm/civicrm-core/pull/31833))**

  Improves accessibility and user experience for sites using RiverLea.

- **Add TIMESTAMPDIFF function to searchkit so you can show time between two
  dates ([31332](https://github.com/civicrm/civicrm-core/pull/31332))**

  Adds the ability to show the time between two dates in SearchKit.

- **Search: disable the alpha pager by default
  ([31883](https://github.com/civicrm/civicrm-core/pull/31883))**

  Improves user experience by disabling the alpha pager on search results by
  default.

- **UX: Could not find a valid session
  ([dev/core#5610](https://lab.civicrm.org/dev/core/-/issues/5610):
  [31638](https://github.com/civicrm/civicrm-core/pull/31638))**

  Improves user experience when a valid session key error is displayed.

- **Proposal - ship unicode fonts - Given the current size of the tarball, and
  the recent PSA about wkhtmltopdf, does it still make sense to remove the
  unicode font from dompdf in the tarball?
  ([dev/core#5539](https://lab.civicrm.org/dev/core/-/issues/5539):
  [31809](https://github.com/civicrm/civicrm-core/pull/31809))**

  Offers dejaVu fonts.

- **EntityRepository - The new canonical source for metadata & CRUD (Work
  Towards [dev/core#5410](https://lab.civicrm.org/dev/core/-/issues/5410):
  [31105](https://github.com/civicrm/civicrm-core/pull/31105))**

  Adds ACL checks to getOptions.

- **Queue.reset - Add API to drop all pending items
  ([31907](https://github.com/civicrm/civicrm-core/pull/31907))**

  Add a new API, `Queue.reset`. It is similar to `Queue.run` or `Queue.runItems`
  in that it's targeted at a specific queue. It deletes all pending items in the
  queue.

- **ChartKit - allow more numeric formats as sourceDataTypes
  ([31876](https://github.com/civicrm/civicrm-core/pull/31876))**

  Improves ChartKit by allowing more numeric formats as source data types.

- **Add pageRun hook to `CRM_Core_Page_File`
  ([31855](https://github.com/civicrm/civicrm-core/pull/31855))**

  Makes it possible to use the pageRun hook with `CRM_Core_Page_File`.

- **A11y - Add aria roles to tablists
  ([31929](https://github.com/civicrm/civicrm-core/pull/31929))**

  Adds accessibility tags to the tab markup.

- **Update existing navigation labels to match new 'Site Email Address'
  ([31988](https://github.com/civicrm/civicrm-core/pull/31988))**

  Changes the navigation menu item "FROM Email Addresses" to "Site Email
  Addresses".

- **Search Kit - For "Entity" displays, provide TABLE/VIEW options
  ([31632](https://github.com/civicrm/civicrm-core/pull/31632))**

  Makes it so in Search Kit, you can create a saved-search and use it to
  generate a read-only custom API.

- **SearchKit - Improve UI for adding/removing tags & fix error when tags
  already exist ([31745](https://github.com/civicrm/civicrm-core/pull/31745))**

  Improves user interface for adding and removing tags in SearchKit.

- **SearchKit Reports - add tagging functionality to categorise reports
  ([dev/core#5654](https://lab.civicrm.org/dev/core/-/issues/5654):
  [31890](https://github.com/civicrm/civicrm-core/pull/31890))**

  Adds support for tagging Afforms using Tag entity.

- **SearchKit - Improve the UI for sql functions
  ([31717](https://github.com/civicrm/civicrm-core/pull/31717))**

  Improves user interface for using sql functions in SearchKit.

- **SearchKit - Add new "Tree" display 🌲, use for AdminUI Navigation menu
  screen ([31803](https://github.com/civicrm/civicrm-core/pull/31803))**

  Adds a new searchKit display option "Tree" and uses it for the AdminUI
  Navigation menu.

- **Afform - Add support for saving and restoring draft submissions
  ([31882](https://github.com/civicrm/civicrm-core/pull/31882))**

  Adds support for saving and restoring draft submissions in Form Builder.

- **Afform - Improve UX for batch-processing submissions
  ([31906](https://github.com/civicrm/civicrm-core/pull/31906))**

  Improves the UX and simplifies the code for batch-processing Form Builder
  submissions. Adds "rejected" status.

- **Afform - Add status filter/icon to submission list
  ([31884](https://github.com/civicrm/civicrm-core/pull/31884))**

  Improves submission list by adding status filter/icon.

- **Afform - Add to contact summary actions menu
  ([31838](https://github.com/civicrm/civicrm-core/pull/31838))**

  Adds a no-code way to add a form to the "Actions" menu on the contact summary
  screen.

- **Move `from_email_address` options to new SiteEmailAddresses entity
  ([31909](https://github.com/civicrm/civicrm-core/pull/31909))**

  Moves the 'from_email_address' option group into its own table: Introducing
  the new SiteEmailAddress entity. 🎉

- **Dedupe performance & hooks (Work Towards
  [dev/core#5433](https://lab.civicrm.org/dev/core/-/issues/5433):
  [31689](https://github.com/civicrm/civicrm-core/pull/31689))**

  Adds the legacydedupefinder extension.

### CiviCampaign

- **Api4 - Enable managed, hierarchical traits for Campaign entities
  ([31359](https://github.com/civicrm/civicrm-core/pull/31359))**

  Adds a couple useful features to CiviCampaign, enabling a hierarchical
  searchKit display of campaigns, and allowing extensions to package them as
  managed entities.

### CiviContribute

- **Add Personal Campaign Page Admin UI Screen
  ([29541](https://github.com/civicrm/civicrm-core/pull/29541))**

  Recreates the Personal Campaign Admin UI screen as a SearchKit Search.

- **Display custom fields on Price Field Values
  ([31839](https://github.com/civicrm/civicrm-core/pull/31839))**

  Shows Custom Fields on Price Field Values on the Edit Price Option page.

- **ContributionView: show the contrib id, remove some buttons, layout changes
  ([31603](https://github.com/civicrm/civicrm-core/pull/31603))**

  Improves and standardizes the Contribution view.

### CiviMember

- **Membership renewal form: Clarify "Date renewal entered"
  ([30427](https://github.com/civicrm/civicrm-core/pull/30427))**

  Improves the user interface when renewing a membership.

### Standalone Integration

- **Standalone - Faster page load times
  ([32252](https://github.com/civicrm/civicrm-core/pull/32252))**

  Improves performance.

- **standaloneusers: support translation on the login screen
  ([31954](https://github.com/civicrm/civicrm-core/pull/31954))**

  Improves translation for the standalone login screen.

- **Update Miscellaneous admin form to mostly use settings
  ([31831](https://github.com/civicrm/civicrm-core/pull/31831))**

  Standardizes the Miscellaneous admin form.

### WordPress Integration

- **Iframe: Add support for WordPress
  ([dev/core#5464](https://lab.civicrm.org/dev/core/-/issues/5464):
  [336](https://github.com/civicrm/civicrm-wordpress/pull/336) and
  [31460](https://github.com/civicrm/civicrm-core/pull/31460))**

  Adds support for IFRAME URLs via `?_cvwpif=1`.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Certain Contact Summary Tabs Not Showing Count
  ([dev/core#5731](https://lab.civicrm.org/dev/core/-/issues/5731):
  [32078](https://github.com/civicrm/civicrm-core/pull/32078))**

- **Relationship tab - disable link gives fatal error
  ([dev/core#5741](https://lab.civicrm.org/dev/core/-/issues/5741):
  [32136](https://github.com/civicrm/civicrm-core/pull/32136))**
  
- **Names that have quotation marks mess up display formatting
  ([dev/core#5711](https://lab.civicrm.org/dev/core/-/issues/5711):
  [31922](https://github.com/civicrm/civicrm-core/pull/31922))**

- **Can't import using contact id
  ([dev/core#4389](https://lab.civicrm.org/dev/core/-/issues/4389):
  [30034](https://github.com/civicrm/civicrm-core/pull/30034))**

- **Default From Email Address not respected
  ([dev/core#5720](https://lab.civicrm.org/dev/core/-/issues/5720):
  [31987](https://github.com/civicrm/civicrm-core/pull/31987))**

- **Finish allowing use of SSL to connect to database (Work Towards
  [dev/core#1926](https://lab.civicrm.org/dev/core/-/issues/1926):
  [31912](https://github.com/civicrm/civicrm-core/pull/31912) and
  [31911](https://github.com/civicrm/civicrm-core/pull/31911))**

  MySQL SSL fixes for Backdrop, Drupal 7, and Standalone integrations and
  improves debug info about SSL failures.

- **Follow-up task - Remove the CiviCRM Connections functionality from CiviCRM
  core (Task 2 of 2) - Remove the code
  ([dev/core#2941](https://lab.civicrm.org/dev/core/-/issues/2941):
  [31740](https://github.com/civicrm/civicrm-core/pull/31740))**

- **FormBuilder - refreshing page after saving a new or cloned one lose current
  context ([dev/core#4827](https://lab.civicrm.org/dev/core/-/issues/4827):
  [31742](https://github.com/civicrm/civicrm-core/pull/31742))**

- **Afform - Autocomplete as filter fails when entity is not primary in SK
  ([dev/core#5679](https://lab.civicrm.org/dev/core/-/issues/5679):
  [31758](https://github.com/civicrm/civicrm-core/pull/31758))**

- **Div ID "contact-summary" changed to "contact-0"
  ([dev/core#5688](https://lab.civicrm.org/dev/core/-/issues/5688):
  [31812](https://github.com/civicrm/civicrm-core/pull/31812))**

- **Condition in Formbuilder: field is renamed 'false' when there's no label
  ([dev/core#5693](https://lab.civicrm.org/dev/core/-/issues/5693):
  [31844](https://github.com/civicrm/civicrm-core/pull/31844))**

- **Composer's `ext-*` requirements are inconsistently enforced
  ([dev/core#5702](https://lab.civicrm.org/dev/core/-/issues/5702):
  [31874](https://github.com/civicrm/civicrm-core/pull/31874))**

- **Formbuilder: ReadOnly fields don't display "view value"
  ([dev/core#5706](https://lab.civicrm.org/dev/core/-/issues/5706):
  [31894](https://github.com/civicrm/civicrm-core/pull/31894))**

- **Debug Mode - Behaves inconsistently on Backdrop/D7
  ([dev/core#5712](https://lab.civicrm.org/dev/core/-/issues/5712):
  [31921](https://github.com/civicrm/civicrm-core/pull/31921))**

- **CRM_Event_WorkflowMessage_EventOfflineReceipt::getProfiles(): Return value
  must be of type array, null returned
  ([dev/core#5717](https://lab.civicrm.org/dev/core/-/issues/5717):
  [32195](https://github.com/civicrm/civicrm-core/pull/32195))**

- **Column too short: civicrm_action_schedule.start_action_date
  ([dev/core#5725](https://lab.civicrm.org/dev/core/-/issues/5725):
  [32054](https://github.com/civicrm/civicrm-core/pull/32054))**

- **api3 contact.getoptions for custom fields either returns null or an error
  ([dev/core#5747](https://lab.civicrm.org/dev/core/-/issues/5747):
  [32170](https://github.com/civicrm/civicrm-core/pull/32170),
  [32168](https://github.com/civicrm/civicrm-core/pull/32168) and
  [32167](https://github.com/civicrm/civicrm-core/pull/32167))**

- **Afform - Fix reading urlHash
  ([31837](https://github.com/civicrm/civicrm-core/pull/31837))**

- **Afform - Fix maxlength comparisons
  ([32220](https://github.com/civicrm/civicrm-core/pull/32220))**

- **Afform - Fully deprecate `contact_id` and remove AfformBlock.tpl
  ([31836](https://github.com/civicrm/civicrm-core/pull/31836))**

- **afform: fixes defaults for join entities
  ([32139](https://github.com/civicrm/civicrm-core/pull/32139))**

- **Afform - Fix prefilling location blocks with different fields
  ([32121](https://github.com/civicrm/civicrm-core/pull/32121))**

- **Afform - Use entity-specific filter key, revert entity_id generic key
  ([32040](https://github.com/civicrm/civicrm-core/pull/32040))**

- **FormBuilder - Fix fatal crash with ContactLayout summary blocks
  ([32068](https://github.com/civicrm/civicrm-core/pull/32068))**

- **SearchKit - Refresh DB entities via table-swap
  ([31767](https://github.com/civicrm/civicrm-core/pull/31767))**

- **SearchKit - Correctly format numeric custom fields
  ([31772](https://github.com/civicrm/civicrm-core/pull/31772))**

- **SearchKit - Fix hiding buttons when downloading spreadsheet
  [32268](https://github.com/civicrm/civicrm-core/pull/32268)**

- **SearchKit - Fix undefined index warning
  ([32142](https://github.com/civicrm/civicrm-core/pull/32142))**

- **SearchKit - Fix tally with long column names
  ([31892](https://github.com/civicrm/civicrm-core/pull/31892))**

- **SearchKit - Improve enable/disable responsiveness and fix bugs in
  hierarchical displays
  ([31866](https://github.com/civicrm/civicrm-core/pull/31866))**

- **AdminUI - Fix custom field tabs appearing for wrong contact subtype
  ([32083](https://github.com/civicrm/civicrm-core/pull/32083))**

- **AdminUI - Prevent crash after adding new custom group
  ([32143](https://github.com/civicrm/civicrm-core/pull/32143))**

- **Switch long & angular caches to use fast-array
  ([31416](https://github.com/civicrm/civicrm-core/pull/31416))**

- **Fix mail settings page to use metadata
  ([31950](https://github.com/civicrm/civicrm-core/pull/31950))**

- **Developer settings page - switch to generating from meta
  ([31966](https://github.com/civicrm/civicrm-core/pull/31966))**

- **Improve crmUiIconPicker with ngModel support for binding
  ([31859](https://github.com/civicrm/civicrm-core/pull/31859))**

  Fixes a UI bug in SearchKit

- **Upgrader - Fix upgrade error with i18n-enabled databases
  ([32109](https://github.com/civicrm/civicrm-core/pull/32109))**

- **Upgrader tasks should not have ts
  ([32033](https://github.com/civicrm/civicrm-core/pull/32033))**

- **Profile - Fix e-notice when displaying website field with no value
  ([31918](https://github.com/civicrm/civicrm-core/pull/31918))**

- **LegacySpecScanner - only needs to look in extensions
  ([31253](https://github.com/civicrm/civicrm-core/pull/31253))**

- **ManagedEntity - Ensure multisite domain entities match on domain_id
  ([31888](https://github.com/civicrm/civicrm-core/pull/31888))**

- **Api3 - Fix profile.submit function to correctly handle more fields
  ([31914](https://github.com/civicrm/civicrm-core/pull/31914))**

- **Use proper table names in query
  ([31903](https://github.com/civicrm/civicrm-core/pull/31903))**

- **Break variable assignment into 2 rows
  ([31940](https://github.com/civicrm/civicrm-core/pull/31940))**

- **CustomField - Increase maxLength for Link fields to 2047 characters.
  ([31868](https://github.com/civicrm/civicrm-core/pull/31868))**

- **Urgent (before 6 freeze): Fix broken select2s on Thames stream
  ([31964](https://github.com/civicrm/civicrm-core/pull/31964))**

- **CRM_Core_BAO_MessageTemplate::getMessageTemplates throws API Request
  Authorization failed because check permissions is enforced
  ([31852](https://github.com/civicrm/civicrm-core/pull/31852))**

- **CustomField - Update searchable field label for consistency with form
  ([31872](https://github.com/civicrm/civicrm-core/pull/31872))**

- **CRM_Report_Form::_aliases set public
  ([31814](https://github.com/civicrm/civicrm-core/pull/31814))**

- **Check parents key exists in GroupsCommon.tpl
  ([30962](https://github.com/civicrm/civicrm-core/pull/30962))**

- **Api3 - Restore groupContact.delete action
  ([31826](https://github.com/civicrm/civicrm-core/pull/31826))**

- **Navigation - Get 'delete' link working
  ([31779](https://github.com/civicrm/civicrm-core/pull/31779))**

- **DeletedFiles - Always use case-sensitivity when generating list  
  ([31764](https://github.com/civicrm/civicrm-core/pull/31764))**

- **CustomGroup: provide a more helpful message when a extendsChildType fails to
  validate ([31766](https://github.com/civicrm/civicrm-core/pull/31766))**

- **PHPUnit Bootstrap - Minor workflow improvement re:xdebug
  ([31750](https://github.com/civicrm/civicrm-core/pull/31750))**

- **Discourage accessing `$form->_values`
  ([31958](https://github.com/civicrm/civicrm-core/pull/31958))**

- **fixes warning buildRecurBlock
  ([31915](https://github.com/civicrm/civicrm-core/pull/31915))**

- **Activity Priority: unhardcode the default priority
  ([31851](https://github.com/civicrm/civicrm-core/pull/31851))**

- **Fix position of closing icon tags
  ([31835](https://github.com/civicrm/civicrm-core/pull/31835))**

- **Online regen script needs sendmail now
  ([31853](https://github.com/civicrm/civicrm-core/pull/31853))**

- **Clarify function parameter
  ([31969](https://github.com/civicrm/civicrm-core/pull/31969))**

- **Improve legibilty by using mysql alias rather than long variable name
  ([31975](https://github.com/civicrm/civicrm-core/pull/31975))**

- **i18n: throw an exception if an invalid escape mode is used
  ([31963](https://github.com/civicrm/civicrm-core/pull/31963))**

- **SqlGenerator - Ensure FK index names are not too long
  ([31910](https://github.com/civicrm/civicrm-core/pull/31910))**

- **Cast to string for explode in CRM_Utils_CommaKV
  ([31827](https://github.com/civicrm/civicrm-core/pull/31827))**

- **CRM_Utils_System_Base::url() has 6 parameters not 7
  ([31800](https://github.com/civicrm/civicrm-core/pull/31800))**

- **Smarty notice fix
  ([31807](https://github.com/civicrm/civicrm-core/pull/31807))**

- **Handle possibility of a NULL source_record_id (address fatal error)
  ([31784](https://github.com/civicrm/civicrm-core/pull/31784))**

- **CiviReport - Fix saving report with is_reserved = false
  ([32141](https://github.com/civicrm/civicrm-core/pull/32141))**

- **many relative dates aren't going to 11:59:59
  ([31429](https://github.com/civicrm/civicrm-core/pull/31429))**

- **Use escaping in SQL query for best practice
  ([31741](https://github.com/civicrm/civicrm-core/pull/31741))**

- **Fix intermittent ExpiredToken error when Iframe patches applied
  ([341](https://github.com/civicrm/civicrm-wordpress/pull/341))**

- **php8.2 Fix use of curly braces in package
  ([420](https://github.com/civicrm/civicrm-packages/pull/420))**

- **PHP compatibility Remove usage of curly braces
  ([419](https://github.com/civicrm/civicrm-packages/pull/419))**

- **Make sorting of countries more consistent
  ([31869](https://github.com/civicrm/civicrm-core/pull/31869))**

### CiviCampaign

- **CiviCampaign - Remove hard-coded reference to unused custom fields
  ([31829](https://github.com/civicrm/civicrm-core/pull/31829))**

### CiviContribute

- **Authorize.net recurring subscription subsequent contributions not recording
  ([dev/core#5732](https://lab.civicrm.org/dev/core/-/issues/5732):
  [32181](https://github.com/civicrm/civicrm-core/pull/32181))**

- **When Importing contributions (including columns for soft credits) the soft
  credit mapping is not saved and the soft credits are not imported
  ([dev/core#5370](https://lab.civicrm.org/dev/core/-/issues/5370):
  [32087](https://github.com/civicrm/civicrm-core/pull/32087))**

- **Fix financial type permissions when label doesn't match name
  ([32189](https://github.com/civicrm/civicrm-core/pull/32189))**

- **Fix financial type custom fields
  ([32131](https://github.com/civicrm/civicrm-core/pull/32131))**

### CiviEvent

- **Events page, problem with pager, more/less than 20 items
  ([dev/core#5758](https://lab.civicrm.org/dev/core/-/issues/5758):
  [32239](https://github.com/civicrm/civicrm-core/pull/32239))**

- **Fix PHP Warning in getAdditionalParticipants
  ([31821](https://github.com/civicrm/civicrm-core/pull/31821))**

### CiviGrant

- **CiviGrant - Remove multi-domain from grant_type option group
  ([31924](https://github.com/civicrm/civicrm-core/pull/31924))**

### CiviMail

- **Suppress the warning Failed to set final value of List-Unsubscribe
  ([31899](https://github.com/civicrm/civicrm-core/pull/31899))**

- **CiviMail: don't pass unused job_id parameter to unsub methods
  ([31811](https://github.com/civicrm/civicrm-core/pull/31811))**

### CiviMember

- **Convert MembershipLog.modified_date from date to timestamp so we record time
  as well ([31799](https://github.com/civicrm/civicrm-core/pull/31799))**

- **Use shared getContactMatchingFields from membership import metadata
  ([31948](https://github.com/civicrm/civicrm-core/pull/31948))**

### Drupal Integration

- **Missing route cachability metadata in CiviCRM
  ([103](https://github.com/civicrm/civicrm-drupal-8/pull/103))**

### Standalone Integration

- **Login issue on CiviCRM Standalone: "unexpected error", "All requests that
  modify the database must be http POST, not GET"
  ([dev/core#5640](https://lab.civicrm.org/dev/core/-/issues/5640):
  [31727](https://github.com/civicrm/civicrm-core/pull/31727))**

- **Standalone login page - fix input text color
  ([32226](https://github.com/civicrm/civicrm-core/pull/32226))**

- **Standalone login box coloring - fix the text color to black to fix dark mode
  ([31991](https://github.com/civicrm/civicrm-core/pull/31991))**

- **Standalone - Fix crash when viewing afform
  ([32059](https://github.com/civicrm/civicrm-core/pull/32059))**

- **Standalone - Fix syntax error typo in conditional
  ([32041](https://github.com/civicrm/civicrm-core/pull/32041))**

- **Standalone - explicitly set $appRootPath and $settingsPath as globals in
  boot file ([31777](https://github.com/civicrm/civicrm-core/pull/31777))**

- **Standalone events
  ([31846](https://github.com/civicrm/civicrm-core/pull/31846))**

## <a name="misc"></a>Miscellany

- **Consolidate dupesByParam
  ([31974](https://github.com/civicrm/civicrm-core/pull/31974))**

- **Fold copy of getTree back into only caller
  ([31933](https://github.com/civicrm/civicrm-core/pull/31933))**

- **Move helper function from test to shared test trait
  ([31936](https://github.com/civicrm/civicrm-core/pull/31936))**

- **Upgrade core extensions to civix v25.01.1
  ([31885](https://github.com/civicrm/civicrm-core/pull/31885))**

- **Oauth - Upgrade to civix v2025.01.1 and EFv2
  ([31887](https://github.com/civicrm/civicrm-core/pull/31887))**

- **Bump min php version to 8.0
  ([31765](https://github.com/civicrm/civicrm-core/pull/31765),
  [340](https://github.com/civicrm/civicrm-wordpress/pull/340),
  [86](https://github.com/civicrm/civicrm-joomla/pull/86),
  [185](https://github.com/civicrm/civicrm-backdrop/pull/185) and
  [689](https://github.com/civicrm/civicrm-drupal/pull/689))**

- **Add deprecated warning to BaseIPN
  ([31453](https://github.com/civicrm/civicrm-core/pull/31453))**

- **Fix another code place to not use legacy query method
  ([31900](https://github.com/civicrm/civicrm-core/pull/31900))**

- **Update comment block with additional possible values
  ([31904](https://github.com/civicrm/civicrm-core/pull/31904))**

- **Stop setting unused variable
  ([31938](https://github.com/civicrm/civicrm-core/pull/31938))**

- **Minor query simplification
  ([31897](https://github.com/civicrm/civicrm-core/pull/31897))**

- **Stop passing unused parameter
  ([31896](https://github.com/civicrm/civicrm-core/pull/31896))**

- **Deprecate a couple of old bits of format wrangling
  ([31934](https://github.com/civicrm/civicrm-core/pull/31934))**

- **Finish deprecating PDFLetterCommon class
  ([31810](https://github.com/civicrm/civicrm-core/pull/31810))**

- **Move remaining 'build' functions from AdditionalInfo to only caller
  ([31956](https://github.com/civicrm/civicrm-core/pull/31956))**

- **Standardise parameter type (bool)
  ([31973](https://github.com/civicrm/civicrm-core/pull/31973))**

- **Move parameter standardisation to before the hook, add test
  ([31972](https://github.com/civicrm/civicrm-core/pull/31972))**

- **Membership renewal form: Minor Cleanup and simplification
  ([31875](https://github.com/civicrm/civicrm-core/pull/31875))**

- **Address deprecation notice
  ([31960](https://github.com/civicrm/civicrm-core/pull/31960))**

- **Install script - minor code cleanup
  ([31847](https://github.com/civicrm/civicrm-core/pull/31847))**

- **Stop using deprecated constant
  ([31952](https://github.com/civicrm/civicrm-core/pull/31952))**

- **Api3 - Remove old functions deprecated since 2014
  ([31773](https://github.com/civicrm/civicrm-core/pull/31773))**

- **Stop using function to get name of non-localised table
  `civicrm_mailing_event_opened`
  ([31901](https://github.com/civicrm/civicrm-core/pull/31901))**

- **UFField: remove unclear field_name check
  ([31891](https://github.com/civicrm/civicrm-core/pull/31891))**

- **Remove unused properties, duplicate catch
  ([31937](https://github.com/civicrm/civicrm-core/pull/31937))**

- **Remove unreachable code
  ([31939](https://github.com/civicrm/civicrm-core/pull/31939))**

- **Removed Unneccesary Enter Text
  ([31858](https://github.com/civicrm/civicrm-core/pull/31858))**

- **Remove variables used for 2 non-localisatable tables
  ([31902](https://github.com/civicrm/civicrm-core/pull/31902))**

- **Remove another call to dao->query()
  ([31898](https://github.com/civicrm/civicrm-core/pull/31898))**

- **Remove unreachable & do-nothing code
  ([31962](https://github.com/civicrm/civicrm-core/pull/31962))**

- **Remove deprecated SMSCommon.php
  ([31778](https://github.com/civicrm/civicrm-core/pull/31778))**

- **Remove assigns from previously shared code
  ([31957](https://github.com/civicrm/civicrm-core/pull/31957))**

- **Remove function noisily deprecated in 2022
  ([31949](https://github.com/civicrm/civicrm-core/pull/31949))**

- **Remove unused parameter from private function
  ([31955](https://github.com/civicrm/civicrm-core/pull/31955))**

- **Remove BAO_CustomGroup::postProcess deprecated in 5.71
  ([31932](https://github.com/civicrm/civicrm-core/pull/31932))**

- **Remove pointless price set wrangling from batch data entry form
  ([31675](https://github.com/civicrm/civicrm-core/pull/31675))**

- **Delete unused Location.php
  ([31776](https://github.com/civicrm/civicrm-core/pull/31776))**

- **Delete unused TabHeader.php
  ([31775](https://github.com/civicrm/civicrm-core/pull/31775))**

- **CRM_Import_Parser - Delete unused deprecated functions
  ([31774](https://github.com/civicrm/civicrm-core/pull/31774))**

- **SloppyTestChecker - Refine the definitions
  ([31798](https://github.com/civicrm/civicrm-core/pull/31798))**

- **[REF] userFrameworkLogging - update settings meta and switch System public
  property to a function
  ([31857](https://github.com/civicrm/civicrm-core/pull/31857))**

- **(REF) CiviUnitTestCase - Plug more leaks
  ([31796](https://github.com/civicrm/civicrm-core/pull/31796))**

- **[REF][PHP8.2] Declare properties on CRM_Admin_Form_WordReplacements
  ([31806](https://github.com/civicrm/civicrm-core/pull/31806))**

- **[REF][PHP8.2] Declare property in CRM_Mailing_Form_ForwardMailing
  ([31819](https://github.com/civicrm/civicrm-core/pull/31819))**

- **[REF][PHP8.2] Declare fields property in CRM_Contact_Form_Task_Batch
  ([31818](https://github.com/civicrm/civicrm-core/pull/31818))**

- **[REF][PHP8.2] Declare tabs property in CRM_Campaign_Page_Vote
  ([31817](https://github.com/civicrm/civicrm-core/pull/31817))**

- **[REF] Chart kit - move reduce types to a separate service
  ([31916](https://github.com/civicrm/civicrm-core/pull/31916))**

- **[REF] Api4 - Remove useless test
  ([31867](https://github.com/civicrm/civicrm-core/pull/31867))**

- **REF - Remove some uses of deprecated `CRM_Utils_Array::value`
  ([31841](https://github.com/civicrm/civicrm-core/pull/31841))**

- **[REF] Migrate determining the connection details to use from Drupal8 install
  file into setup code
  ([31917](https://github.com/civicrm/civicrm-core/pull/31917))**

- **(REF) Tests - Sundry cleanups
  ([31795](https://github.com/civicrm/civicrm-core/pull/31795))**

- **(REF) Api4TestBase - Each test starts with default list of components
  ([31797](https://github.com/civicrm/civicrm-core/pull/31797))**

- **[REF] Add Test of Billing update form for contribution Recur and ensure
  receipt from is assigned
  ([31905](https://github.com/civicrm/civicrm-core/pull/31905))**

- **[REF] Return tempTable name from fillTable
  ([31980](https://github.com/civicrm/civicrm-core/pull/31980))**

- **[REF] Remove code no longer needed as setup routine is now smarter See
 civicrm/civicrm-core#31917
 ([104](https://github.com/civicrm/civicrm-drupal-8/pull/104))**

- **[REF] Ensure that Privacy (single checkbox) fields show up on Event
  Registrations when fields are used in a profile
  ([31692](https://github.com/civicrm/civicrm-core/pull/31692))**

- **[NFC] Simplify function call in test
  ([31820](https://github.com/civicrm/civicrm-core/pull/31820))**

- **[NFC] remove duplicate from contributor-key.yml
  ([31951](https://github.com/civicrm/civicrm-core/pull/31951))**

- **(NFC) mixin/polyfill.php - Tweak boolean notation
  ([31840](https://github.com/civicrm/civicrm-core/pull/31840))**

- **Add name to contributor-key.yml
  ([31748](https://github.com/civicrm/civicrm-core/pull/31748))**

- **Add name to contributor-key.yml
  ([31743](https://github.com/civicrm/civicrm-core/pull/31743))**

- **minor test cleanup
  ([31759](https://github.com/civicrm/civicrm-core/pull/31759))**

- **Minor cleanup in test class
  ([31791](https://github.com/civicrm/civicrm-core/pull/31791))**

- **Minor clean up in test class
  ([31942](https://github.com/civicrm/civicrm-core/pull/31942))**

- **Reduce the hard-codedness of test data
  ([31749](https://github.com/civicrm/civicrm-core/pull/31749))**

- **Afform - Test cleanup
  ([31761](https://github.com/civicrm/civicrm-core/pull/31761))**

- **Use Mock Handler in A.net test
  ([32214](https://github.com/civicrm/civicrm-core/pull/32214))**

- **Fix failing test
  ([32187](https://github.com/civicrm/civicrm-core/pull/32187))**

- **Minor clean ups in test classes
  ([31754](https://github.com/civicrm/civicrm-core/pull/31754))**

- **Try removing more of the old test dataset
  ([31790](https://github.com/civicrm/civicrm-core/pull/31790))**

- **Test clean up on campaign
  ([31755](https://github.com/civicrm/civicrm-core/pull/31755))**

- **Some test clean up
  ([31753](https://github.com/civicrm/civicrm-core/pull/31753))**

- **SettingsAdminTest - Relax assertion re: permissions on disabled extenions
  ([31815](https://github.com/civicrm/civicrm-core/pull/31815))**

- **See if this test data is all used....
  ([31788](https://github.com/civicrm/civicrm-core/pull/31788))**

- **Minor clean up in test classes
  ([31747](https://github.com/civicrm/civicrm-core/pull/31747))**

- **Minor test cleanup on setUp & tearDown
  ([31941](https://github.com/civicrm/civicrm-core/pull/31941))**

- **SearchKit - Fix unit test assumptions
  ([31805](https://github.com/civicrm/civicrm-core/pull/31805))**

- **SearchKit - Fix failing test
  ([31804](https://github.com/civicrm/civicrm-core/pull/31804))**

- **Minor test cleanups
  ([31786](https://github.com/civicrm/civicrm-core/pull/31786))**

- **Minor test cleanups
  ([31787](https://github.com/civicrm/civicrm-core/pull/31787))**

- **minor test cleanup
  ([31760](https://github.com/civicrm/civicrm-core/pull/31760))**

- **MixinTestCase - Small usability tweaks
  ([31816](https://github.com/civicrm/civicrm-core/pull/31816))**

- **Minor clean ups in test classes
  ([31752](https://github.com/civicrm/civicrm-core/pull/31752))**

- **Minor cleanups in test classes
  ([31746](https://github.com/civicrm/civicrm-core/pull/31746))**

- **Change version to 6.0.alpha1
  ([31763](https://github.com/civicrm/civicrm-core/pull/31763))**

- **Fix typo in release notes
  ([32057](https://github.com/civicrm/civicrm-core/pull/32057))**

- **Add missing PR 31671 to release notes for 5.81.0
  ([31783](https://github.com/civicrm/civicrm-core/pull/31783))**

- **release-notes.md - Update TOC
  ([31978](https://github.com/civicrm/civicrm-core/pull/31978))**

- **Run regen
  ([32061](https://github.com/civicrm/civicrm-core/pull/32061))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin; Agileware - Justin Freeman; Artful Robot - Rich
Lott; Benjamin W; BrightMinded Ltd - Bradley Taylor, Anwen Williams; Business &
Code - Alain Benbassat; CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim
Otten; Coop SymbioTIC - Mathieu Lutfy, Shane Bill; Dave D; gitressa; JMA
Consulting - Monish Deb, Seamus Lee; Megaphone Technology Consulting - Jon
Goldberg; MJW Consulting - Matthew Wire; Mosier Consulting - Justin Mosier;
Nicol Wistreich; Reflexive Communications - Sandor Semsey; Squiffle
Consulting - Aidan Saunders; Tadpole Collective - Kevin Cristiano; Third Sector
Design - Kurund Jalmi, William Mortada; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Albrecht Schmidt; chumkui; Coop SymbioTIC - Samuel Vanhove; Daniel Strum; dev
ALL IN APPLI; Francesc Bassas i Bullich; Fuzion - Luke Stewart, Peter Davis;
Guydn; Jade Gaunt; JMA Consulting - Joe Murray; Lemniscus - Noah Miller;
ozhamlet; Richard Baugh; Semper IT - Karin Gerritsen; Sjoerd Langkemper
