# CiviCRM 5.75.0

Released July 3, 2024

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Custom Fields: Change the 'is searchable' field from checkbox to yes/no
  radio button and set to required
  ([dev/core#1735](https://lab.civicrm.org/dev/core/-/issues/1735):
  [30186](https://github.com/civicrm/civicrm-core/pull/30186),
  [30209](https://github.com/civicrm/civicrm-core/pull/30209) and
  [30188](https://github.com/civicrm/civicrm-core/pull/30188))**

  Improves user experience by making the "Is Searchable?" field on custom
  field configuration required.

- **Switch to using new crmPermission block
  ([30317](https://github.com/civicrm/civicrm-core/pull/30317),
  [30320](https://github.com/civicrm/civicrm-core/pull/30320),
  [30285](https://github.com/civicrm/civicrm-core/pull/30285) and
  [30300](https://github.com/civicrm/civicrm-core/pull/30300))**

  New crmPermission block.

- **Imagine a world without CodeGen (Work Towards
  [dev/core#4999](https://lab.civicrm.org/dev/core/-/issues/4999):
  [30007](https://github.com/civicrm/civicrm-core/pull/30007),
  [30312](https://github.com/civicrm/civicrm-core/pull/30312),
  [30311](https://github.com/civicrm/civicrm-core/pull/30311),
  [30310](https://github.com/civicrm/civicrm-core/pull/30310),
  [29991](https://github.com/civicrm/civicrm-core/pull/29991) and
  [30342](https://github.com/civicrm/civicrm-core/pull/30342))**

  Removes generated DAO code, use CRM_Core_DAO_Base instead.

- **Lack of hooks to detect when an Attachment is deleted
  ([dev/core#3130](https://lab.civicrm.org/dev/core/-/issues/3130):
  [28559](https://github.com/civicrm/civicrm-core/pull/28559))**

  Support pre/post hook calls on File and EntityFile entities when one or more
  activity attachments gets deleted.

- **Hides billing block if total amount is 0
  ([30313](https://github.com/civicrm/civicrm-core/pull/30313))**

  Improves user experience by hiding the billing block if the total amount is 0.

- **Add deceased date to contact reports
  ([dev/core#5210](https://lab.civicrm.org/dev/core/-/issues/5210):
  [30184](https://github.com/civicrm/civicrm-core/pull/30184))**

  Improves contact reports by adding deceased date as a column option.

- **Default Smarty version on new installs to 4
  ([29962](https://github.com/civicrm/civicrm-core/pull/29962))**

  Default smarty version to 4 on new installs.

- **Call hooks when recording a trackable URL open
  ([30121](https://github.com/civicrm/civicrm-core/pull/30121))**

  Adds hooks to recording a trackable URL open.

- **Schema - Simplify entityType files by removing redundant maxlength property
  ([30476](https://github.com/civicrm/civicrm-core/pull/30476))**

  Simplifies entityType files by removing max length property.

- **Add IsActiveTrait to Civi/Core/Service
  ([30091](https://github.com/civicrm/civicrm-core/pull/30091))**

  Adds the IsActiveTrait to Civi/Core/Service.

- **Update monaco to recent version
  ([dev/core#5298](https://lab.civicrm.org/dev/core/-/issues/5298):
  [30475](https://github.com/civicrm/civicrm-core/pull/30475))**

  Update Monaco-editor to version 0.49.0.

- **Afform - use contact-type-specific API entities  
  ([29246](https://github.com/civicrm/civicrm-core/pull/29246))**

  Makes Afform code more internally consistent.

- **SearchKit - Allow searching for search displays
  ([30181](https://github.com/civicrm/civicrm-core/pull/30181))**

  Makes it possible to create a search display of search displays.

### CiviMember

- **Expose membership type id for membership receipts
  ([dev/core#5235](https://lab.civicrm.org/dev/core/-/issues/5235):
  [30244](https://github.com/civicrm/civicrm-core/pull/30244))**

  Exposes Membership type id in Membership reciepts.

### Drupal Integration

- **Drupal 11 Prototype
  ([92](https://github.com/civicrm/civicrm-drupal-8/pull/92) and
  [30214](https://github.com/civicrm/civicrm-core/pull/30214))**

  Work Towards integration with Drupal 11.

### Standalone Integration

- **Standalone - Separate HTML templates for frontend and backend UIs
  ([29789](https://github.com/civicrm/civicrm-core/pull/29789))**

  Adds an HTML template for public-facing pages, e.g. Event registrations,
  unsubscribe etc.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **smarty 4/5 don't have a trigger_error function, used in civi smarty plugins
  and Smarty 3 causes crash if exception thrown, e.g. by crmAPI
  ([dev/core#5242](https://lab.civicrm.org/dev/core/-/issues/5242) and
  [dev/core#5109](https://lab.civicrm.org/dev/core/-/issues/5109):
  [30513](https://github.com/civicrm/civicrm-core/pull/30513))**

  Fixes assorted Smarty bugs.

- **Issue with SQL import with > and < in the SQL query
  ([dev/core#3787](https://lab.civicrm.org/dev/core/-/issues/3787):
  [30207](https://github.com/civicrm/civicrm-core/pull/30207))**

  Restores the ability to use > & < in sql query imports.

- **Afform - Custom fields of type YesNo (boolean): Defaults not displayed and
  changes not saved
  ([dev/core#4753](https://lab.civicrm.org/dev/core/-/issues/4753):
  [29695](https://github.com/civicrm/civicrm-core/pull/29695))**

- **CiviReport: Contribution Detail Report Joining Incorrectly on civicrm_note
  ([dev/core#4924](https://lab.civicrm.org/dev/core/-/issues/4924):
  [30512](https://github.com/civicrm/civicrm-core/pull/30512))**

  Fixes "Notes" column breaking some reports.

- **Attaching multiple contacts to an activity in afform dies if one in the
  middle is missing
  ([dev/core#4964](https://lab.civicrm.org/dev/core/-/issues/4964):
  [29213](https://github.com/civicrm/civicrm-core/pull/29213))**

- **Custom radio/checkbox fields - maximum options per line - alignment lost
  ([dev/core#4985](https://lab.civicrm.org/dev/core/-/issues/4985):
  [30162](https://github.com/civicrm/civicrm-core/pull/30162))**

- **Alert for smart group no longer displayed for deleted custom fields.
  ([dev/core#5187](https://lab.civicrm.org/dev/core/-/issues/5187):
  [30125](https://github.com/civicrm/civicrm-core/pull/30125))**

- **Fatal error on creating custom fields if extension has a post_hook with
  `getoptions` api call.
  ([dev/core#5233](https://lab.civicrm.org/dev/core/-/issues/5233):
  [30242](https://github.com/civicrm/civicrm-core/pull/30242))**

- **Proposal: don't drop tables in sql/civicrm.sql
  ([dev/core#5241](https://lab.civicrm.org/dev/core/-/issues/5241):
  [30271](https://github.com/civicrm/civicrm-core/pull/30271))**

- **Smarty performance issue when switching locales
  ([dev/core#5243](https://lab.civicrm.org/dev/core/-/issues/5243):
  [30273](https://github.com/civicrm/civicrm-core/pull/30273))**

- **javascripty bubble popups not working anymore
  ([dev/core#5271](https://lab.civicrm.org/dev/core/-/issues/5271):
  [30345](https://github.com/civicrm/civicrm-core/pull/30345))**

- **Altering custom fields used for subtypes throws up false or incorrect
  warning ([dev/core#5273](https://lab.civicrm.org/dev/core/-/issues/5273):
  [30349](https://github.com/civicrm/civicrm-core/pull/30349))**

- **handle multilingual + advanced logging in a separate db
  ([29813](https://github.com/civicrm/civicrm-core/pull/29813))**

- **Crash on Directory settings page
  ([dev/core#5274](https://lab.civicrm.org/dev/core/-/issues/5274):
  [30354](https://github.com/civicrm/civicrm-core/pull/30354))**

- **Installing extensions crashes
  ([dev/core#5276](https://lab.civicrm.org/dev/core/-/issues/5276):
  [30399](https://github.com/civicrm/civicrm-core/pull/30399))**

- **Formbuilder: the title of the form (submission or search) is "CiviCRM"
  instead of the public title given in form builder
  ([dev/core#5278](https://lab.civicrm.org/dev/core/-/issues/5278):
  [30373](https://github.com/civicrm/civicrm-core/pull/30373))**

- **EntityLookupTrait with NULL values
  ([dev/core#5282](https://lab.civicrm.org/dev/core/-/issues/5282):
  [30410](https://github.com/civicrm/civicrm-core/pull/30410))**

  Fixes form load error.

- **Participant Fee Amount Not Changing After Edits When Not Recording Payment
  ([dev/core#5289](https://lab.civicrm.org/dev/core/-/issues/5289):
  [30439](https://github.com/civicrm/civicrm-core/pull/30439))**

- **Smarty5 unknown modifier 'mb_substr'
  ([dev/core#5309](https://lab.civicrm.org/dev/core/-/issues/5309):
  [30534](https://github.com/civicrm/civicrm-core/pull/30534))**

- **api Contribution.sendconfirmation ignores receipt_text for memberships
  ([dev/core#5316](https://lab.civicrm.org/dev/core/-/issues/5316):
  [30549](https://github.com/civicrm/civicrm-core/pull/30549))**

- **Case roles section is squished
  ([dev/user-interface#73](https://lab.civicrm.org/dev/user-interface/-/issues/73):
  [30465](https://github.com/civicrm/civicrm-core/pull/30465))**

  Fixes squashed DataTables inside ajax accordions.

- **Unhide financial acls, disable if not required.
  ([29360](https://github.com/civicrm/civicrm-core/pull/29360))**

- **Add DAO entityID for sendSMSMessage() $smsProviderParams
  ([30340](https://github.com/civicrm/civicrm-core/pull/30340))**

- **Afform blocks for singular custom groups
  ([30239](https://github.com/civicrm/civicrm-core/pull/30239))**

- **Addition to master needed to allow smarty path override via env var
  ([30292](https://github.com/civicrm/civicrm-core/pull/30292))**

- **Api4 - Handle EMPTY operators correctly with boolean fields
  ([30182](https://github.com/civicrm/civicrm-core/pull/30182))**

- **Check if region has value in retval
  ([30315](https://github.com/civicrm/civicrm-core/pull/30315))**

- **Ensure error handler always restored
  ([30077](https://github.com/civicrm/civicrm-core/pull/30077))**

- **APIv4 - Add SqlFunctionNEXTANNIV, fix leap-year handling
  ([30338](https://github.com/civicrm/civicrm-core/pull/30338))**

- **Begone bad index
  ([30316](https://github.com/civicrm/civicrm-core/pull/30316))**

- **CRM_Admin_Form_MessageTemplates - Fix disabling user message templates via
  the edit form ([30195](https://github.com/civicrm/civicrm-core/pull/30195))**

- **Remove mailing_backend_store, confusingly set when we switch the environment
  to Development ([30133](https://github.com/civicrm/civicrm-core/pull/30133))**

- **Exclude MessageComponent.body_html from purify
  ([30444](https://github.com/civicrm/civicrm-core/pull/30444))**

- **ScheduledCommunications - Unit test + api fixes
  ([30360](https://github.com/civicrm/civicrm-core/pull/30360))**

- **Remove CRM_Core_Permission::check call in tpl with crmPermission smarty tag
  for Contact ([30361](https://github.com/civicrm/civicrm-core/pull/30361))**

- **Fix auto-respond to use token processor.
  ([29908](https://github.com/civicrm/civicrm-core/pull/29908))**

- **Fixes for "show payment on confirmation page" for events
  ([28286](https://github.com/civicrm/civicrm-core/pull/28286))**

- **CiviReport - Use cached function to get custom fields
  ([30187](https://github.com/civicrm/civicrm-core/pull/30187))**

- **return empty array from getSelectedIDs
  ([30323](https://github.com/civicrm/civicrm-core/pull/30323))**

- **Populate custom fields URL params when the custom group extends only
  particular types of event/contribution/etc.
  ([25636](https://github.com/civicrm/civicrm-core/pull/25636))**

- **Port Extends patch to smarty3
  ([406](https://github.com/civicrm/civicrm-packages/pull/406))**

- **Angular - Allow themes to override CSS files
  ([30467](https://github.com/civicrm/civicrm-core/pull/30467))**

- **Alternate to part of 30382 - replace tpl php call to permission::check
  ([30436](https://github.com/civicrm/civicrm-core/pull/30436))**

- **SearchSegment - Fix mismatch between field suffixes and options
  ([30435](https://github.com/civicrm/civicrm-core/pull/30435))**

- **fix getCancelUrls
  ([30392](https://github.com/civicrm/civicrm-core/pull/30392))**

- **ScheduledReminders - Fix hiding irrelevant fields
  ([30193](https://github.com/civicrm/civicrm-core/pull/30193))**

- **ensure shared address is updated in reverse
  ([30129](https://github.com/civicrm/civicrm-core/pull/30129))**

- **skip custom word replacements check during installer
  ([30166](https://github.com/civicrm/civicrm-core/pull/30166))**

- **Replace db_delete with user_save for consistency in process
  ([681](https://github.com/civicrm/civicrm-drupal/pull/681))**

- **Follow up fix on monaco upgrade
  ([30490](https://github.com/civicrm/civicrm-core/pull/30490))**

- **Fix crash flushing when a managed record is removed after the entity it
  manages has been deleted
  ([30254](https://github.com/civicrm/civicrm-core/pull/30254))**

- **SearchKit - Fix drag-n-drop of "Select Fields"
  ([30471](https://github.com/civicrm/civicrm-core/pull/30471))**

- **SearchKit - Always use backend links for tasks
  ([30247](https://github.com/civicrm/civicrm-core/pull/30247))**

- **Fix PHP warnings on contribute confirm when membership is not enabled
  ([30215](https://github.com/civicrm/civicrm-core/pull/30215))**

- **Fix missing opening <p> tag
  ([30185](https://github.com/civicrm/civicrm-core/pull/30185))**

- **Afform - Form fails to render if parent nav-item has its own URL
  ([30063](https://github.com/civicrm/civicrm-core/pull/30063))**

- **Afform - Format DisplayOnly fields as view value
  ([29186](https://github.com/civicrm/civicrm-core/pull/29186))**

- **Angular - Fix console error when using crmUiSelect+ngList with separator
  ([30477](https://github.com/civicrm/civicrm-core/pull/30477))**

- **Fix failure to render Custom Data on RelationshipType form
  ([30417](https://github.com/civicrm/civicrm-core/pull/30417))**

- **Remove extraneous `}` from generated link
  ([30433](https://github.com/civicrm/civicrm-core/pull/30433))**

- **Fix broken links in sched reminders
  ([30428](https://github.com/civicrm/civicrm-core/pull/30428))**

- **E_NOTICE when viewing a participant with no payment
  ([30160](https://github.com/civicrm/civicrm-core/pull/30160))**

- **Fix smarty notice when viewing a participant with no contribution (unpaid)
  ([30123](https://github.com/civicrm/civicrm-core/pull/30123))**

- **Fix error on relation-add where acl check fails
  ([28744](https://github.com/civicrm/civicrm-core/pull/28744))**

### CiviCase

- **Case roles section doesn't stay open after adding a role
  ([dev/core#5296](https://lab.civicrm.org/dev/core/-/issues/5296):
  [30502](https://github.com/civicrm/civicrm-core/pull/30502))**
  
### CiviContribute

- **find financial acl warning amongst other messages
  ([30213](https://github.com/civicrm/civicrm-core/pull/30213))**

- **Standardise implementation of financial type acl in query object
  ([28967](https://github.com/civicrm/civicrm-core/pull/28967))**

- **Fatal Error on adding new payment processor
  ([dev/core#5266](https://lab.civicrm.org/dev/core/-/issues/5266):
  [30339](https://github.com/civicrm/civicrm-core/pull/30339))**

- **Invoicing settings can send attachments even when invoicing is disabled
  ([dev/core#5224](https://lab.civicrm.org/dev/core/-/issues/5224):
  [30224](https://github.com/civicrm/civicrm-core/pull/30224))**

  Disables PDF invoice setting when conditionally hidden.

### CiviEvent

- **Additional participant event registration forms with multiple 'post'
  profiles issue
  ([dev/core#5206](https://lab.civicrm.org/dev/core/-/issues/5206):
  [30176](https://github.com/civicrm/civicrm-core/pull/30176))**

- **Remove the Participant Role from Event confirmations
  ([30322](https://github.com/civicrm/civicrm-core/pull/30322) and
  [30359](https://github.com/civicrm/civicrm-core/pull/30359)**

- **Remove calls to deprecated core function from event cart
  ([30116](https://github.com/civicrm/civicrm-core/pull/30116))**

- **Fix PHP warning when event has no end date
  ([30230](https://github.com/civicrm/civicrm-core/pull/30230))**

- **Fix smarty error on the manage event pcp tab
  ([30526](https://github.com/civicrm/civicrm-core/pull/30526))**

### CiviGrant

- **CiviGrant regression - Civi 5.74.0, PHP8
  ([dev/core#5284](https://lab.civicrm.org/dev/core/-/issues/5284):
  [30404](https://github.com/civicrm/civicrm-core/pull/30404))**

### CiviMember

- **Stop assigning no-longer used membership template variables
  ([30114](https://github.com/civicrm/civicrm-core/pull/30114))**

- **"Submit Credit Card Membership" form does not show Membership Types if the
  minimum fee is 0.00 and auto renew option is no
  ([dev/core#5202](https://lab.civicrm.org/dev/core/-/issues/5202):
  [30168](https://github.com/civicrm/civicrm-core/pull/30168))**

- **Fatal error when changing membership type, on membership with 0
  contributions
  ([dev/core#4048](https://lab.civicrm.org/dev/core/-/issues/4048):
  [30419](https://github.com/civicrm/civicrm-core/pull/30419))**

- **Fix regression on loading MembershipType edit form
  ([30403](https://github.com/civicrm/civicrm-core/pull/30403))**

- **Display issue on membership view for relationships
  ([dev/core#4984](https://lab.civicrm.org/dev/core/-/issues/4984):
  [29380](https://github.com/civicrm/civicrm-core/pull/29380))**

- **Rationalise renewal date in membership renew
  ([30113](https://github.com/civicrm/civicrm-core/pull/30113))**

- **Fix notice on Membership form custom data loading
  ([29743](https://github.com/civicrm/civicrm-core/pull/29743))**

- **Start using getMembershipValue in offline renewal form
  ([30115](https://github.com/civicrm/civicrm-core/pull/30115))**

### CiviPledge

- **Separate handlePledge back to calling forms, no universe usage
  ([30126](https://github.com/civicrm/civicrm-core/pull/30126))**

- **Clean up notices on pledge dashboard
  ([29701](https://github.com/civicrm/civicrm-core/pull/29701))**

### CiviSMS

- **ensure civisms adds SMS delivery activity
  ([30087](https://github.com/civicrm/civicrm-core/pull/30087))**

### Drupal Integration

- **Drupal10 clearResourceCache: check if hasContainer, avoid cv fatal
  ([30210](https://github.com/civicrm/civicrm-core/pull/30210))**

- **Authx - Fix stateful logins on D9/D10
  ([30145](https://github.com/civicrm/civicrm-core/pull/30145))**

- **Permission fix proto
  ([94](https://github.com/civicrm/civicrm-drupal-8/pull/94))**

### Joomla Integration

- **Fix joomla 3 regression from #27834 for Select2 drop down options in a modal
  ([30531](https://github.com/civicrm/civicrm-core/pull/30531))**

### Standalone Integration

- **Fix Standalone core source storage url double slash
  ([30212](https://github.com/civicrm/civicrm-core/pull/30212))**

- **Type safety in Standalone currentPath
  ([30211](https://github.com/civicrm/civicrm-core/pull/30211))**

### WordPress Integration

- **fix(wp-cli): confirm sentence
  ([326](https://github.com/civicrm/civicrm-wordpress/pull/326))**

- **WPML URL Integration for CiviCRM
  ([dev/wordpress#133](https://lab.civicrm.org/dev/wordpress/-/issues/133):
  [316](https://github.com/civicrm/civicrm-wordpress/pull/316))**

  Ensures urls are correct when using the WPML language plugin.

## <a name="misc"></a>Miscellany

- **Move eventCart call to getFull to the extension
  ([30318](https://github.com/civicrm/civicrm-core/pull/30318))**

- **Core - Add annotations to DAO stubs
  ([30265](https://github.com/civicrm/civicrm-core/pull/30265))**

- **Getter for log table names
  ([30246](https://github.com/civicrm/civicrm-core/pull/30246))**

- **Simplify looking up contact custom fields
  ([30314](https://github.com/civicrm/civicrm-core/pull/30314))**

- **Bump braces from 3.0.2 to 3.0.3
  ([30456](https://github.com/civicrm/civicrm-core/pull/30456))**

- **Add getContributionID() function to Confirm form
  ([30122](https://github.com/civicrm/civicrm-core/pull/30122))**

- **Stop calling run when loading multipleParticipantListing
  ([29482](https://github.com/civicrm/civicrm-core/pull/29482))**

- **Pass parameters to dedupe fill table
  ([29879](https://github.com/civicrm/civicrm-core/pull/29879))**

- **Fold function back to only caller
  ([30031](https://github.com/civicrm/civicrm-core/pull/30031))**

- **5.75 version of 30363 Adding self to contributor list
  ([30370](https://github.com/civicrm/civicrm-core/pull/30370))**

- **Add self to contributor list
  ([30324](https://github.com/civicrm/civicrm-core/pull/30324))**

- **Add self to contributor list
  ([30149](https://github.com/civicrm/civicrm-core/pull/30149))**

- **Extract isShowPaymentOnConfirm
  ([30319](https://github.com/civicrm/civicrm-core/pull/30319))**

- **Fold deprecated function back into only caller
  ([30047](https://github.com/civicrm/civicrm-core/pull/30047))**

- **Delete old placeholder files
  ([30221](https://github.com/civicrm/civicrm-core/pull/30221))**

- **Update deleted files list again
  ([30228](https://github.com/civicrm/civicrm-core/pull/30228))**

- **GenCode - Skip I18n generation
  ([30357](https://github.com/civicrm/civicrm-core/pull/30357))**

- **Remove deprecated handling for invalid value
  ([30029](https://github.com/civicrm/civicrm-core/pull/30029))**

- **Remove some unused variables
  ([30232](https://github.com/civicrm/civicrm-core/pull/30232))**

- **Remove Civi/ActionSchedule/Mapping workaround
  ([30220](https://github.com/civicrm/civicrm-core/pull/30220))**

- **Remove empty function & the test which is it's only caller
  ([30030](https://github.com/civicrm/civicrm-core/pull/30030))**

- **Remove unused variable
  ([30282](https://github.com/civicrm/civicrm-core/pull/30282))**

- **Remove some unreachable code
  ([30249](https://github.com/civicrm/civicrm-core/pull/30249))**

- **[REF] Update Civi Log channel in dreprecation function to match deprecated
  function function
  ([30248](https://github.com/civicrm/civicrm-core/pull/30248))**

- **[REF] Ensure that when deleting a schedule job it redirects appropriately to
  the list of schedule jobs
  ([30262](https://github.com/civicrm/civicrm-core/pull/30262))**

- **[REF] Modify Financial Trxn to use writeRecord
  ([30328](https://github.com/civicrm/civicrm-core/pull/30328))**

- **[REF] Add Payment.create APIv4 Action
  ([30333](https://github.com/civicrm/civicrm-core/pull/30333))**

- **[REF] Call Complete Order directly from Payment.Create BAO instead of using
  complete contribution API
  ([30347](https://github.com/civicrm/civicrm-core/pull/30347))**

- **[REF] Rewrite MailingQuery to allow for hook to modify criteria used
  ([30245](https://github.com/civicrm/civicrm-core/pull/30245))**

- **[REF] Regenerate composer hash
  ([30287](https://github.com/civicrm/civicrm-core/pull/30287))**

- **[REF] CRM - Refactor out CRM_Utils_Array::value
  ([30174](https://github.com/civicrm/civicrm-core/pull/30174))**

- **[REF] Fix Contribution Detail Report add to Group when using custom field as
  a section header
  ([30159](https://github.com/civicrm/civicrm-core/pull/30159))**

- **[REF] DAO - Outside parties should use `getTableName()` instead of
  `$_tableName` ([30167](https://github.com/civicrm/civicrm-core/pull/30167))**

- **[REF] CiviCampaign code cleanup
  ([30161](https://github.com/civicrm/civicrm-core/pull/30161))**

- **[REF] Result of npm audit fix
  ([30504](https://github.com/civicrm/civicrm-core/pull/30504))**

- **[REF] Remove CRM_Core_Permission::check call in tpl with crmPermission
  smarty tag ([30385](https://github.com/civicrm/civicrm-core/pull/30385))**

- **[REF] Remove CRM_Core_Permission::check call in tpl with crmPermission
  smarty tag for Event
  ([30383](https://github.com/civicrm/civicrm-core/pull/30383))**

- **[NFC] Use correct syntax for writing to arrays
  ([30218](https://github.com/civicrm/civicrm-core/pull/30218))**

- **[NFC] Make tests fail when any error handlers don't clean themselves up
  ([30183](https://github.com/civicrm/civicrm-core/pull/30183))**

- **[NFC] civicrm.settings.php.template: consistent whitespace
  ([30198](https://github.com/civicrm/civicrm-core/pull/30198))**

- **NFC: Fix since tags in WPML methods
  ([327](https://github.com/civicrm/civicrm-wordpress/pull/327))**

- **NFC: Introduce Post Content filter prior to parsing Posts for Shortcodes
  ([328](https://github.com/civicrm/civicrm-wordpress/pull/328))**

- **[NFC] Oauth - Remove unused boilerplate
  ([30175](https://github.com/civicrm/civicrm-core/pull/30175))**

- **Move some CRM tests to use apiv4
  ([30088](https://github.com/civicrm/civicrm-core/pull/30088))**

- **Move test to extension
  ([30253](https://github.com/civicrm/civicrm-core/pull/30253))**

- **Minor test improvements/ standardisation
  ([30252](https://github.com/civicrm/civicrm-core/pull/30252))**

- **Fix duplicate array key issue in CRM_Core_BAO_CustomQueryTest
  ([30219](https://github.com/civicrm/civicrm-core/pull/30219))**

- **Test clean up, use apiv4 more, considate tracking
  ([30173](https://github.com/civicrm/civicrm-core/pull/30173))**

- **update PermissionTest for Standalone case
  ([30137](https://github.com/civicrm/civicrm-core/pull/30137))**

- **php8 - Fix undefined class variable notices in report InstanceList
  ([30142](https://github.com/civicrm/civicrm-core/pull/30142))**

- **[php8] undeclared var on new individual on-the-fly popup
  ([30269](https://github.com/civicrm/civicrm-core/pull/30269))**

- **[php8] Undeclared vars on manage events
  ([30270](https://github.com/civicrm/civicrm-core/pull/30270))**

- **[php8] Undefined array key when editing event templates
  ([30255](https://github.com/civicrm/civicrm-core/pull/30255))**

- **[php8] Undeclared class variable in event fees
  ([30256](https://github.com/civicrm/civicrm-core/pull/30256))**

- **[php8] undeclared class vars on event online registration tab
  ([30257](https://github.com/civicrm/civicrm-core/pull/30257))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Angela Jackson; Artful Robot - Rich
Lott; Australian Greens - John Twyman; Benjamin W; BrightMinded Ltd - Bradley
Taylor; Christian Wach; Circle Interactive - Pradeep Nayak; CiviCRM - Coleman
Watts, Tim Otten; CiviDesk - Yashodha Chaku; ColoredCow: Abhishek Pokhriyal;
Compuco: Yogesh Pawar; Coop SymbioTIC - Mathieu Lutfy, Shane Bill; Dave D;
devdavc; David Cativo; Fuzion - Jitendra Purohit; JMA Consulting - Monish Deb,
Seamus Lee; John Kingsnorth; Joinery - Allen Shaw; Jonny Toomey; Megaphone
Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Nicol
Wistreich; Progressive Technology Project - Jamie McClelland; Reflexive
Communications - Sandor Semsey; Registered Nurses' Association of Ontario - Ian
Wilson; Responsive Development Technologies - Thomas Nilefalk; Skvare - Mark
Hanna; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Andy Burns; ASMAC (American Society of Music
Arrangers and Composers) - Jeff Kellem; Australian Greens - Andrew
Cormick-Dockery; CiviCoop - Jaap Jansma; Coop SymbioTIC - Samuel Vanhove,
mmyriam; Ezodesign: Jeremy Proffitt; Fuzion - Luke Stewart; Greenleaf
Advancement - Guy Iaccarino; Savion Lee; Semper IT - Karin Gerritsen; Squiffle
Consulting - Aidan Saunders; Tadpole Collective - Kevin Cristiano; Third Sector
Design - Kurund Jalmi; Wildsight - Lars Sander-Green

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
