# CiviCRM 5.72.0

Released April 3, 2024

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| **Require attention to configuration options?**                 | **yes** |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Scheduled Jobs - Define and track  "last_run_end" 
  ([29587](https://github.com/civicrm/civicrm-core/pull/29587))**

  If a job completes (whether successful or by exception) it will record a 
  `last_run_end` date in the job table.

- **Support oEmbed for external facing pages 
  ([dev/core#2994](https://lab.civicrm.org/dev/core/-/issues/2994):
  [29496](https://github.com/civicrm/civicrm-core/pull/29496) and
  [29536](https://github.com/civicrm/civicrm-core/pull/29536))**

  This adds initial support for CiviCRM to provide embeddable content on 
  external websites. However, the mechanism is somewhat experimental. 
  Consequently, it is implemented as a hidden extension (`oembed`).

- **Updating php-weasyprint to latest version 
  ([29806](https://github.com/civicrm/civicrm-core/pull/29806) and
  [29844](https://github.com/civicrm/civicrm-core/pull/29844))**

### CiviContribute

- **Convert confirm email text to html 
  ([29532](https://github.com/civicrm/civicrm-core/pull/29532))**

  The field for custom text in a contribution or event confirmation email is
  now rich text stored as HTML.

- **Switch variables for tokens in contribution invoice template 
  (Preparing for [dev/core#4940](https://lab.civicrm.org/dev/core/-/issues/4940): 
  [29119](https://github.com/civicrm/civicrm-core/pull/29119))**

  Most variables are no longer tied to the form layer.

### CiviEvent

- **Replace Contact Summary Events tab with Admin UI Search Display and Form 
  ([29570](https://github.com/civicrm/civicrm-core/pull/29570))**

  This continues work to replace admin screens with displays built on 
  SearchKit. Note: customizations using `hook_civicrm_links()` on the replaced
  tab will no longer work. They can be reimplemented by customizing the 
  display.

- **add class for fee level column 
  ([29123](https://github.com/civicrm/civicrm-core/pull/29123))**

  The results in Find Participants had classes for all the columns besides the
  Fee Level column. This adds a class to the column so that it can used as reference if needed to alter the column via JS or CSS.

### CiviMail

- **Add fields to mailing details report 
  ([dev/core#5010](https://lab.civicrm.org/dev/core/-/issues/5010): 
  [29387](https://github.com/civicrm/civicrm-core/pull/29387))**

  Time stamp fields are now available in the mailing details report to show when the mailing was delivered.

- **Updates SMS form to use api based widget to select phones rather than the 
  hacky one-off ajax 
  ([29647](https://github.com/civicrm/civicrm-core/pull/29647))**

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Accordions: Eight patterns in Civi markup – reduce & make more accessible?
  ([dev/user-interface#60](https://lab.civicrm.org/dev/user-interface/-/issues/60):
  [29446](https://github.com/civicrm/civicrm-core/pull/29446),
  [29448](https://github.com/civicrm/civicrm-core/pull/29448),
  [29449](https://github.com/civicrm/civicrm-core/pull/29449),
  [29533](https://github.com/civicrm/civicrm-core/pull/29533),
  [29543](https://github.com/civicrm/civicrm-core/pull/29543),
  [29551](https://github.com/civicrm/civicrm-core/pull/29551),
  [29563](https://github.com/civicrm/civicrm-core/pull/29563),
  [29594](https://github.com/civicrm/civicrm-core/pull/29594),
  [29600](https://github.com/civicrm/civicrm-core/pull/29600),
  [29602](https://github.com/civicrm/civicrm-core/pull/29602),
  [29633](https://github.com/civicrm/civicrm-core/pull/29633),
  [29704](https://github.com/civicrm/civicrm-core/pull/29704),
  [29713](https://github.com/civicrm/civicrm-core/pull/29713), and
  [680](https://github.com/civicrm/civicrm-drupal/pull/680))**

  This removes a `crm-collapsible` class which is deprecated, replacing it with
  `<summary>` and `<details>` elements.

- **Fix bug where fields is not present ([29870](https://github.com/civicrm/civicrm-core/pull/29870))**

- **Blank custom fields accordion appears on Find XXX search forms 
  ([dev/core#5112](https://lab.civicrm.org/dev/core/-/issues/5112):
  [29840](https://github.com/civicrm/civicrm-core/pull/29840))**

- **[REF] Do not add arrays consisting of just the auto renew as options … ([29770](https://github.com/civicrm/civicrm-core/pull/29770))**

- **[REF] Fix showing Main Email field only when email doesn't exist in a 
  profile ([29749](https://github.com/civicrm/civicrm-core/pull/29749))**

- **Update follow redirects to 1.15.6 ([29748](https://github.com/civicrm/civicrm-core/pull/29748))**

- **Afform - fix missing page title ([29694](https://github.com/civicrm/civicrm-core/pull/29694))**

- **Specify rounding mode when rendering Monetary entity tokens 
  ([29654](https://github.com/civicrm/civicrm-core/pull/29654))**

- **missing literal ([29668](https://github.com/civicrm/civicrm-core/pull/29668))**

- **Afform - typo when getting options from SavedSearch entity ([29662](https://github.com/civicrm/civicrm-core/pull/29662))**

- **Remove unnecessary pass-by-ref ([29650](https://github.com/civicrm/civicrm-core/pull/29650))**

- **SearchKit - Update crmSearchAdminFields.html to use X icon instead of ban icon for removing fields ([29549](https://github.com/civicrm/civicrm-core/pull/29549))**

- **Pass all available relevant fields to Contact.getduplicates on checkMatchingContact ([29554](https://github.com/civicrm/civicrm-core/pull/29554))**

- **Finish decommissioning use of legacy `getTree()` function ([29643](https://github.com/civicrm/civicrm-core/pull/29643))**

- **Dedupe finder field wrangler - de-nest groupTree results ([29640](https://github.com/civicrm/civicrm-core/pull/29640))**

- **Remove unset variables from previously shared function ([29636](https://github.com/civicrm/civicrm-core/pull/29636))**

- **Remove some legacy code that is not relevant in this previously shared function ([29639](https://github.com/civicrm/civicrm-core/pull/29639))**

- **Dont crash if we can't start a session when a file path doesnt exist ([29363](https://github.com/civicrm/civicrm-core/pull/29363))**

- **Don't clear sessions when clearing cache ([29610](https://github.com/civicrm/civicrm-core/pull/29610))**

- **Remove always NULL variable from previously shared function ([29635](https://github.com/civicrm/civicrm-core/pull/29635))**

- **Dedupe selected fields, simplify, removed greeting id fields ([29632](https://github.com/civicrm/civicrm-core/pull/29632))**

- **[Ref] Duplicate deprecated getTree function to another place in dedupe code ([29631](https://github.com/civicrm/civicrm-core/pull/29631))**

- **[custom data code cleanup, Finder] Fold another previously shared function into only caller ([29628](https://github.com/civicrm/civicrm-core/pull/29628))**

- **Check workflow not deprecated workflow_id on showing message templates ([29526](https://github.com/civicrm/civicrm-core/pull/29526))**

- **Fold another function back into caller ([29626](https://github.com/civicrm/civicrm-core/pull/29626))**

- **Access submitted value directly rather than passing around ([29627](https://github.com/civicrm/civicrm-core/pull/29627))**

- **Fold the 2 groupTree wrangling functions into 1 ([29622](https://github.com/civicrm/civicrm-core/pull/29622))**

- **Return function to only calling class ([29517](https://github.com/civicrm/civicrm-core/pull/29517))**

- **Import - Use localized alternative to English-only headerPattern from field metadata ([29612](https://github.com/civicrm/civicrm-core/pull/29612))**

- **Remove always true parameter & associated IF from previously shared function ([29531](https://github.com/civicrm/civicrm-core/pull/29531))**

- **avoid passing null to strnatcmp deprecation notice ([29615](https://github.com/civicrm/civicrm-core/pull/29615))**

- **OpenID - Set field widget to match field rule ([29611](https://github.com/civicrm/civicrm-core/pull/29611))**

- **Use name instead of label in conditionals ([29608](https://github.com/civicrm/civicrm-core/pull/29608))**

- **Replace assign_by_ref with assign 
  ([29433](https://github.com/civicrm/civicrm-core/pull/29433),
  [29442](https://github.com/civicrm/civicrm-core/pull/29442),
  [29443](https://github.com/civicrm/civicrm-core/pull/29443),
  [29576](https://github.com/civicrm/civicrm-core/pull/29576),
  [29601](https://github.com/civicrm/civicrm-core/pull/29601),
  [29603](https://github.com/civicrm/civicrm-core/pull/29603),
  [29606](https://github.com/civicrm/civicrm-core/pull/29606), and
  [29609](https://github.com/civicrm/civicrm-core/pull/29609))**

- **Extract isInvalidRecipient ([29565](https://github.com/civicrm/civicrm-core/pull/29565))**

- **Remove unused inputs & outputs from buildLegacyGroupTree ([29557](https://github.com/civicrm/civicrm-core/pull/29557))**

- **Update 'Administer Custom Groups' to show subtypes ([29584](https://github.com/civicrm/civicrm-core/pull/29584))**

- **(REF) Crypto - Cleanup service declarations ([29571](https://github.com/civicrm/civicrm-core/pull/29571))**

- **APIv4 Explorer - Accept action-parameters of type "float" ([29586](https://github.com/civicrm/civicrm-core/pull/29586))**

- **entity id in rows ([29582](https://github.com/civicrm/civicrm-core/pull/29582))**

- **if no clicks, display 0 rather than empty string ([29568](https://github.com/civicrm/civicrm-core/pull/29568))**

- **AdminUI - Edit title, description, comment to clarify what it's for ([29581](https://github.com/civicrm/civicrm-core/pull/29581))**

- **Conditionally show updateTemplate fields ([29577](https://github.com/civicrm/civicrm-core/pull/29577))**

- **More briefName fixes ([29579](https://github.com/civicrm/civicrm-core/pull/29579))**

- **Finish making DedupeRule sql() static ([29540](https://github.com/civicrm/civicrm-core/pull/29540))**

- **Call browse directly rather than forcing through run ([29481](https://github.com/civicrm/civicrm-core/pull/29481))**

- **Deprecate dupeQuery hook ([29544](https://github.com/civicrm/civicrm-core/pull/29544))**

- **Remove non-variable variables from recently unshared function ([29556](https://github.com/civicrm/civicrm-core/pull/29556))**

- **Add some noise to legacy code that I believe to be no longer reachable ([29535](https://github.com/civicrm/civicrm-core/pull/29535))**

- **Copy getTree function back to finder class ([29546](https://github.com/civicrm/civicrm-core/pull/29546))**

- **Admin UI page pdf formats ([29545](https://github.com/civicrm/civicrm-core/pull/29545))**

- **Assign profileID to template in UFNotify, add example ([29441](https://github.com/civicrm/civicrm-core/pull/29441))**

- **SearchKit - Support field comparisons in HAVING clause ([29542](https://github.com/civicrm/civicrm-core/pull/29542))**

- **A11y: Fix info button contrast ratio ([29529](https://github.com/civicrm/civicrm-core/pull/29529))**

- **Pass values into DedupeRule->sql() rather than hybrid object ([29520](https://github.com/civicrm/civicrm-core/pull/29520))**

- **Remove code slated for removal ([29534](https://github.com/civicrm/civicrm-core/pull/29534))**

- **UI: Swaps icon image sprite with FA icon ([29530](https://github.com/civicrm/civicrm-core/pull/29530))**

- **Deprecate function back to only caller ([29524](https://github.com/civicrm/civicrm-core/pull/29524))**

- **Remove unreachable broken rollback ([29511](https://github.com/civicrm/civicrm-core/pull/29511))**

- **[REF} extract code for formatting custom fields ([29518](https://github.com/civicrm/civicrm-core/pull/29518))**

- **Add some noise if people use getVar to access internal properties ([29492](https://github.com/civicrm/civicrm-core/pull/29492))**

- **Copy functions from TabHeader back to the only caller ([29490](https://github.com/civicrm/civicrm-core/pull/29490))**

- **Stop passing parameters to previously shared now-private function ([29491](https://github.com/civicrm/civicrm-core/pull/29491))**

- **Allow json parameter definition for scheduled jobs ([29486](https://github.com/civicrm/civicrm-core/pull/29486))**

- **Do not use getVar to access property on same form ([29493](https://github.com/civicrm/civicrm-core/pull/29493))**

- **Stop passing some-weird-but-always-the-same params to getPositions ([29395](https://github.com/civicrm/civicrm-core/pull/29395))**

- **[REF] Ensure that gName is always asigned to page template ([29480](https://github.com/civicrm/civicrm-core/pull/29480))**

- **Sub str_starts_with instead of substring ([29478](https://github.com/civicrm/civicrm-core/pull/29478))**

- **AllCoreTables - Reduce reliance on class index. ([29471](https://github.com/civicrm/civicrm-core/pull/29471))**

- **Add deprecation tag & pointers ([29467](https://github.com/civicrm/civicrm-core/pull/29467))**

- **Remove pass-by-ref ([29468](https://github.com/civicrm/civicrm-core/pull/29468))**

- **Copy last remaining usage of getComponentDetails() to relevant subsystem ([29459](https://github.com/civicrm/civicrm-core/pull/29459))**

- **[REF] Fully deprecated getSubType function ([29462](https://github.com/civicrm/civicrm-core/pull/29462))**

- **Display labels for numeric custom field key values in Log Detail Report ([29029](https://github.com/civicrm/civicrm-core/pull/29029))**

- **Split code from quasi-shared code in order to be able to clean it up ([29435](https://github.com/civicrm/civicrm-core/pull/29435))**

- **Remove unused function, noisily deprecated a year ago ([29434](https://github.com/civicrm/civicrm-core/pull/29434))**

- **SchemaHandler - Get table names from canonical sources instead of string-fu guesswork ([29389](https://github.com/civicrm/civicrm-core/pull/29389))**

- **[REF] AllCoreTables - Cleanup comments, rename functions for consistency ([29390](https://github.com/civicrm/civicrm-core/pull/29390))**

- **APIv4: Automatically add 'OR IS NULL' to 'NOT CONTAINS' ([29402](https://github.com/civicrm/civicrm-core/pull/29402))**

- **[REF] AllCoreTables - Make internal function private ([29418](https://github.com/civicrm/civicrm-core/pull/29418))**

- **[REF] DAO - Make `getEntityIcon()` function more useful ([29423](https://github.com/civicrm/civicrm-core/pull/29423))**

- **MultiLingual - Fix inconsistent handling of table names ([29366](https://github.com/civicrm/civicrm-core/pull/29366))**

- **Comment functions with deprecation/ preferred method notices ([29417](https://github.com/civicrm/civicrm-core/pull/29417))**

- **Remove (unreachable) call to clearAssign ([29412](https://github.com/civicrm/civicrm-core/pull/29412))**

- **Fix PHP Notice in Contact Import Parser 
  ([29396](https://github.com/civicrm/civicrm-core/pull/29396))**

- **CRM_Utils_JS - Improve encoding of object keys ([29392](https://github.com/civicrm/civicrm-core/pull/29392))**

- **AdminUI - Add link to create new field directly from custom group listing ([29397](https://github.com/civicrm/civicrm-core/pull/29397))**

- **[php8.2] Clean up the 2 forms that support Group-extending custom data for 
  notices, php8.2 compliance 
  ([29229](https://github.com/civicrm/civicrm-core/pull/29229))**

- **CRM_Core_DAO - Deprecate unused functions ([29391](https://github.com/civicrm/civicrm-core/pull/29391))**

- **(REF) Drop unused SQL file (civicrm_arms_sample_data.sql) ([29386](https://github.com/civicrm/civicrm-core/pull/29386))**

- **Switch Smartyv2 mixin to Smarty mixin ([29382](https://github.com/civicrm/civicrm-core/pull/29382))**

- **Fix references to old location for HookInterface ([29385](https://github.com/civicrm/civicrm-core/pull/29385))**

- **Switch our default dev & demo smarty version from 3 to 4 ([29370](https://github.com/civicrm/civicrm-core/pull/29370))**

- **Ext - Specify COLLATE when creating tables ([29384](https://github.com/civicrm/civicrm-core/pull/29384))**

- **avoid deprecation errors  ([29383](https://github.com/civicrm/civicrm-core/pull/29383))**

- **Update file ID in entity field on file upload in Afform ([29199](https://github.com/civicrm/civicrm-core/pull/29199))**

- **[REF] AllCoreTables - More efficient array lookups ([29377](https://github.com/civicrm/civicrm-core/pull/29377))**

- **Remove financial acls properties in core that are set but not accessed ([28960](https://github.com/civicrm/civicrm-core/pull/28960))**

- **Replace 'Expose Publicly' phrasing with 'Public Pages' 
  ([dev/core#2915](https://lab.civicrm.org/dev/core/-/issues/2915):
  [29347](https://github.com/civicrm/civicrm-core/pull/29347))**

- **[REF] DAO - Consolidate redundant functions keys() and getPrimaryKey() ([29367](https://github.com/civicrm/civicrm-core/pull/29367))**

- **Add load filter compatibility function to Smarty2 ([388](https://github.com/civicrm/civicrm-packages/pull/388))**

### CiviCampaign

- **[Survey] 5.71 regression - survey forms missing type hints 
  ([29658](https://github.com/civicrm/civicrm-core/pull/29658))**

- **CiviCampaign - Ensure dashboard fields are translated 
  ([29723](https://github.com/civicrm/civicrm-core/pull/29723))**

### CiviCase

- **php 8.2 fix ChangeCaseStartDate 
  ([29666](https://github.com/civicrm/civicrm-core/pull/29666))**

### CiviContribute

- **Premiums configuration gives a 500 error 
  ([dev/core#5107](https://lab.civicrm.org/dev/core/-/issues/5107): 
  [29843](https://github.com/civicrm/civicrm-core/pull/29843))**

- **(regression) Submission of non-numeric value on contribution form causes 
  crash ([dev/core#5079](https://lab.civicrm.org/dev/core/-/issues/5079):
  [29717](https://github.com/civicrm/civicrm-core/pull/29717))**

- **Price Sets: total calculation wrong if decimal separator is different than 
  "." ([dev/core#5026](https://lab.civicrm.org/dev/core/-/issues/5026):
  [29499](https://github.com/civicrm/civicrm-core/pull/29499))**

- **Fix Payment Processor form to use the right way to get the 
  `paymentProcessorID` 
  ([29477](https://github.com/civicrm/civicrm-core/pull/29477))**

- **Fix Smarty notice on add payment 
  ([29502](https://github.com/civicrm/civicrm-core/pull/29502))**

- **[Update Subscription Form] Align UpdateSubscription to more recent 
  practices ([29538](https://github.com/civicrm/civicrm-core/pull/29538),
  [29539](https://github.com/civicrm/civicrm-core/pull/29539),
  [29564](https://github.com/civicrm/civicrm-core/pull/29564),
  [29572](https://github.com/civicrm/civicrm-core/pull/29572),
  [29573](https://github.com/civicrm/civicrm-core/pull/29573), 
  [29574](https://github.com/civicrm/civicrm-core/pull/29574), and
  [29580](https://github.com/civicrm/civicrm-core/pull/29580))**

- **Use getPaymentProcessorObject() in updateBilling 
  ([29605](https://github.com/civicrm/civicrm-core/pull/29605))**

- **Make getContributionID public on AbstractEditPayment 
  ([29483](https://github.com/civicrm/civicrm-core/pull/29483))**

  We have the same function many places & have been making it public & api 
  supported but this one is protected

- **[REF] Ensure that CMS is booted prior to processing legacy PayPal IPN 
  ([29521](https://github.com/civicrm/civicrm-core/pull/29521))**

### CiviEvent

- **Incorrect fee level saved when editing event participant 
  ([dev/core#5085](https://lab.civicrm.org/dev/core/-/issues/5085): 
  [29726](https://github.com/civicrm/civicrm-core/pull/29726))**

- **Intro text on event confirm is actually html 
  ([29841](https://github.com/civicrm/civicrm-core/pull/29841))**

- **Display of autocomplete multi-select custom fields for events is broken 
  ([dev/core#5090](https://lab.civicrm.org/dev/core/-/issues/5090): 
  [29721](https://github.com/civicrm/civicrm-core/pull/29721))**

- **message template "Events - Registration Confirmation and Receipt (on-line)"
  transaction no. not displayed 
  ([dev/core#5088](https://lab.civicrm.org/dev/core/-/issues/5088): 
  [29715](https://github.com/civicrm/civicrm-core/pull/29715))**

- **Afform - Add Participant Note block 
  ([29575](https://github.com/civicrm/civicrm-core/pull/29575))**

  This adds a missing Note field for editing participants in Form Builder.

- **Disabled Event Name Badge Layouts Are Not Disabled 
  ([dev/core#5032](https://lab.civicrm.org/dev/core/-/issues/5032): 
  [29494](https://github.com/civicrm/civicrm-core/pull/29494))**

- **Columns are misaligned on find participants results 
  ([dev/core#5030](https://lab.civicrm.org/dev/core/-/issues/5030):
  [29489](https://github.com/civicrm/civicrm-core/pull/29489) and
  [29500](https://github.com/civicrm/civicrm-core/pull/29500))**

- **Fix manage event pages to clear caches on save 
  ([29510](https://github.com/civicrm/civicrm-core/pull/29510))**

- **Match event breadcrumb label to context 
  ([29537](https://github.com/civicrm/civicrm-core/pull/29537))**

- **Fix notices on participantView 
  ([29473](https://github.com/civicrm/civicrm-core/pull/29473) and
  [29476](https://github.com/civicrm/civicrm-core/pull/29476))**

### CiviMail

- **With URL tracking enabled, a personalised "View in your browser" link 
  incorrectly replaces ? with & which causes CiviCRM to respond with error: 
  "You do not have permission to access this page" 
  ([dev/core#5082](https://lab.civicrm.org/dev/core/-/issues/5082): 
  [29850](https://github.com/civicrm/civicrm-core/pull/29850))**

- **sms form missing tokens dropdown and save template section at bottom not  
  hidden properly 
  ([dev/core#5029](https://lab.civicrm.org/dev/core/-/issues/5029):
  [29667](https://github.com/civicrm/civicrm-core/pull/29667))**

- **[SMS Trait] Consolidate 2 foreach loops into 1 in sms trait 
  ([29629](https://github.com/civicrm/civicrm-core/pull/29629))**

- **SMSTrait - extract getSMSProviderParams 
  ([29607](https://github.com/civicrm/civicrm-core/pull/29607))**

- **Clean up phone filtering in sms activity trait 
  ([29604](https://github.com/civicrm/civicrm-core/pull/29604))**

- **SMS form cleanup Stop passing contactIds into previously shared function 
  ([29614](https://github.com/civicrm/civicrm-core/pull/29614))**

- **Use Api rather than BAO::create to create activity in SMS Trait 
  ([29475](https://github.com/civicrm/civicrm-core/pull/29475))**

- **[SMS Trait] Remove unvariable variables from previously shared code  
  ([29474](https://github.com/civicrm/civicrm-core/pull/29474))**

- **SMS Trait - add support for Autocomplete subscriber, notice fix 
  ([29429](https://github.com/civicrm/civicrm-core/pull/29429))**

### CiviMember

- **Scheduled Reminder listing will not load at all if any Scheduled Reminder 
  exists which refers to a deleted Membership Type 
  ([29460](https://github.com/civicrm/civicrm-core/pull/29460))**

- **TypeError when trying to use checkboxes with default non-membership 
  options in the Membership section of Contribution Pages 
  ([dev/core#5071](https://lab.civicrm.org/dev/core/-/issues/5071): 
  [29653](https://github.com/civicrm/civicrm-core/pull/29653))**
  
- **Custom field value not saved first time after membership type changed 
  ([dev/core#4026](https://lab.civicrm.org/dev/core/-/issues/4026): 
  [29355](https://github.com/civicrm/civicrm-core/pull/29355))**

- **Fix failure to handle localised money, notice on batch membership form 
  ([29349](https://github.com/civicrm/civicrm-core/pull/29349))**

- **Ensure price from url is set as default 
  ([29822](https://github.com/civicrm/civicrm-core/pull/29822))**

  Specifying price field ID in URL was overriden by current membership type.

- **Fix New Member receipt setting for non-English 
  ([29451](https://github.com/civicrm/civicrm-core/pull/29451))**

- **Fix BackOffice Membership forms getPriceSetID() to be standard 
  ([29348](https://github.com/civicrm/civicrm-core/pull/29348))**

- **Add filters to membership type sk on contact membership tab 
  ([29775](https://github.com/civicrm/civicrm-core/pull/29775))**

### Drupal Integration

- **drupal 8 - php warnings on every page: html_entity_decode(): Passing null 
  to parameter #1 ($string) of type string is deprecated 
  ([dev/core#5052](https://github.com/civicrm/civicrm-core/pull/29560): 
  [29560](https://github.com/civicrm/civicrm-core/pull/29560))**

- **Issue #194: add core resources to blocks 
  ([89](https://github.com/civicrm/civicrm-drupal-8/pull/89))**

### Joomla! Integration

- **Respect CIVICRM_DSN and CIVICRM_UF_DSN being different on upgrade 
  ([69](https://github.com/civicrm/civicrm-joomla/pull/69))**

- **Check if valid UF Match exists in user plugin 
  ([55](https://github.com/civicrm/civicrm-joomla/pull/55))**

- **Fixes broken links on post-upgrade/install page 
  ([66](https://github.com/civicrm/civicrm-joomla/pull/66))**

- **Fix event listing as front page for Joomla 4 
  ([73](https://github.com/civicrm/civicrm-joomla/pull/73))**

### Standalone Implementation

- **Standalone: doesn't install because of missing session class 
  ([dev/core#4988](https://lab.civicrm.org/dev/core/-/issues/4988): 
  [29352](https://github.com/civicrm/civicrm-core/pull/29352))**

- **Standalone install in another language 
  ([dev/core#5037](https://lab.civicrm.org/dev/core/-/issues/5037): 
  [29522](https://github.com/civicrm/civicrm-core/pull/29522))**

- **Disable Sync CMS Users form and functionality on Standalone 
  ([dev/core#4993](https://lab.civicrm.org/dev/core/-/issues/4993):
  [29351](https://github.com/civicrm/civicrm-core/pull/29351))**

- **Standalone install - check upload directory is writable 
  ([29354](https://github.com/civicrm/civicrm-core/pull/29354))**

## <a name="misc"></a>Miscellany

- **Imagine a world without CodeGen 
  (Toward [dev/core#4999](https://lab.civicrm.org/dev/core/-/issues/4999): 
  [29365](https://github.com/civicrm/civicrm-core/pull/29365) and
  [29364](https://github.com/civicrm/civicrm-core/pull/29364))**

- **ReferenceDynamic - Save lots of irrelevant queries when finding 
  backreferences ([29381](https://github.com/civicrm/civicrm-core/pull/29381) 
  and [29569](https://github.com/civicrm/civicrm-core/pull/29569))**

- **Regen DAOs ([29372](https://github.com/civicrm/civicrm-core/pull/29372))**

- **Make mailingJob::queue static 
  ([29175](https://github.com/civicrm/civicrm-core/pull/29175))**

- **Suppress last php8.2 test fail for PR tests 
  ([29724](https://github.com/civicrm/civicrm-core/pull/29724))**

- **[REF] Clarify type of group_id & rule_group_id is int or null 
  ([29394](https://github.com/civicrm/civicrm-core/pull/29394))**

- **Ornery++ ([29550](https://github.com/civicrm/civicrm-core/pull/29550))**

- **Fix test to call actual function 
  ([29630](https://github.com/civicrm/civicrm-core/pull/29630))**

- **add field name to SearchKit cells, primarily for testing 
  ([29595](https://github.com/civicrm/civicrm-core/pull/29595))**

- **fix 'Authorization Failed' on API4TestTrait 
  ([29590](https://github.com/civicrm/civicrm-core/pull/29590))**

- **[NFC] Fix tests for leap year 
  ([29562](https://github.com/civicrm/civicrm-core/pull/29562))**

- **LocalizedDataTest - Simplify test protocol. Only care about live SQL. 
  ([29311](https://github.com/civicrm/civicrm-core/pull/29311))**

- **SMS form test - fix to test the function actually being used 
  ([29432](https://github.com/civicrm/civicrm-core/pull/29432))**

- **Add test on merge code 
  ([29405](https://github.com/civicrm/civicrm-core/pull/29405))**

- **NFC: fix incorrect comment 
  ([29596](https://github.com/civicrm/civicrm-core/pull/29596))**

- **[NFC] Don't flush someone else's ob 
  ([29426](https://github.com/civicrm/civicrm-core/pull/29426))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andie Hunt; Agileware - Agileware Team, Francis Whittle, 
Justin Freeman; Benjamin W; Christian Wach; Circle Interactive - Pradeep 
Nayak; CiviCoop - Jaap Jansma; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - 
Yashodha Chaku; civiservice.de - Detlev Sieber; Coop SymbioTIC - Mathieu 
Lutfy, Samuel Vanhove, Shane Bill; Dave D; dependabot[bot]; Freeform Solutions 
- Herb van den Dool; Fuzion - Jitendra Purohit; Gokhalemethod - Sadashiv; 
Greenleaf Advancement - Guy Iaccarino; JMA Consulting - Seamus Lee; John 
Kingsnorth; kapn*net Technology Services - Keith Nunn; Lemniscus - Noah 
Miller; Makoa - Usha F. Matisson; Megaphone Technology Consulting - Jon 
Goldberg; MJW Consulting - Matthew Wire; Mosier Consulting - Justin Mosier; 
Nicol Wistreich; Progressive Technology Project - Jamie McClelland; Responsive 
Development Technologies - Thomas Nilefalk; Squiffle Consulting - Aidan 
Saunders; Third Sector Design - Kurund Jalmi; Wikimedia Foundation - Eileen 
McNaughton, Elliott Eggleston

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Chris Garaffa; Artful Robot - Rich Lott; ASMAC (American 
Society of Music Arrangers and Composers) - Jeff Kellem; Australian Greens - 
Andrew Cormick-Dockery; Francesc Bassas i Bullich; Fuzion - Luke Stewart; 
James Bugden; JMA Consulting - Joe Murray; mmyriam; Systopia - Dominic Tubach, 
Johannes Franz; Tadpole Collective - Kevin Cristiano; Third Sector Design - 
William Mortada

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
